/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.shelp.licence.OemBranding;
import com.jw.SHJWUtil;
import java.io.File;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import utils.files.FileUtil;

public class SGHttpsUtil {
    static boolean loaded = false;
    static boolean required;

    public static String getRequiredHttpProtocol() {
        if (SGHttpsUtil.mustUseHttps()) {
            return "https";
        }
        return "http";
    }

    public static boolean mustUseHttps() {
        if (loaded) {
            return required;
        }
        try {
            if (ServerManagement.isServerJVM()) {
                required = CentralDebugging.PX_PEER_CONNECTION_HTTPS;
                loaded = true;
                return required;
            }
            if (!JWSystem.getAppBundleName().toLowerCase().equals(OemBranding.OEM_ACCESS_APP_NAME)) {
                return SHJWUtil.getUpdateURLProtocol().equalsIgnoreCase("https");
            }
            File shared = JWSystem.getAllAppVersionsSharedFolder();
            File mustUseHttps = new File(shared, "mustUseHttps");
            if (!mustUseHttps.exists()) {
                String url = JWSystem.getUpdateURL();
                if (url.toLowerCase().trim().startsWith("https")) {
                    System.out.println("[Https] Update URL is HTTPS, mandating HTTPS for all comms");
                    FileUtil.writeFileAsString((File)mustUseHttps, (String)"true");
                } else {
                    System.out.println("[Https] Update URL is not HTTPS, mandating HTTP for all comms");
                    FileUtil.writeFileAsString((File)mustUseHttps, (String)"false");
                }
                JWGenericOS.setReadableForAllUsersAndWait((File)mustUseHttps, (boolean)false);
            }
            required = FileUtil.readFileAsString((File)mustUseHttps).trim().equalsIgnoreCase("true");
            System.out.println("[Https] HTTPS is " + (required ? "required" : "not required"));
            loaded = true;
            return required;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }
}

