/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import build.BuildConstants;
import com.aem.sgateway.SimpleGatewayServiceStop;
import com.aem.shelp.licence.OemBranding;
import com.aem.utils.StreamUtils;
import com.simplehelp.linux.LinuxServiceManager;
import com.simplehelp.macos.MacOSServiceManager;
import com.simplehelp.windows.WindowsServiceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.mappedfile.MFMessageHandler;
import utils.message.mappedfile.MessageHandler;
import utils.ostools.OS;
import utils.stream.MappedChannel;
import utils.string.HexData;

public class ManageRemoteAccessService
implements MessageHandler {
    public static final int COMMAND_COMPLETE = 655361;
    public static final int COMMAND_ERROR = 655362;
    public static String PROPERTY_START_LAUNCHER_PATH = "RemoteAccessStartLauncherPath";
    public static String PROPERTY_STOP_LAUNCHER_PATH = "RemoteAccessStopLauncherPath";
    public static String PROPERTY_SERVICE_DIR = "RemoteAccessTargetDir";
    public static String PROPERTY_ACTION = "RemoteAccessAction";
    public static String PROPERTY_CHANNEL_SERVER = "RemoteAccessChannelServer";
    public static String PROPERTY_CHANNEL_CLIENT = "RemoteAccessChannelClient";
    public static String PROPERTY_CONFIG_FILE = "RemoteAccessConfigFile";
    public static String PROPERTY_CONFIG_FILE_XML = "RemoteAccessConfigXML";
    public static String VALUE_ACTION_INSTALL = "RemoteAccessInstall";
    public static String VALUE_ACTION_REMOVE = "RemoteAccessRemove";
    public static String VALUE_ACTION_SAVECONFIG = "RemoteAccessSaveConfig";
    public static String VALUE_ACTION_REINSTALL_FORCED = "RemoteAccessReinstallForced";
    private MFMessageHandler messenger = null;
    private static final boolean OSX_USE_NATIVE_LAUNCHER_INSTEAD_OF_APP = true;

    public void println(String s) {
        if (this.messenger != null) {
            this.messenger.println(s);
        } else {
            System.out.println(s);
        }
    }

    public void printStackTrace(Throwable t) {
        if (this.messenger != null) {
            this.messenger.printStackTrace(t);
        } else {
            t.printStackTrace();
        }
    }

    public ManageRemoteAccessService() {
        String server = JWSystem.getAppLaunchProperty((String)PROPERTY_CHANNEL_SERVER);
        String client = JWSystem.getAppLaunchProperty((String)PROPERTY_CHANNEL_CLIENT);
        if (server.length() == 0 && client.length() == 0) {
            System.out.println("[ManageRemoteAccessService] Initialised with no communication");
        } else {
            File serverFile = new File(server);
            File clientFile = new File(client);
            System.out.println("[ManageRemoteAccessService] ServerFile = " + serverFile.getAbsolutePath() + " (exists = " + serverFile.exists() + ")");
            System.out.println("[ManageRemoteAccessService] ClientFile = " + clientFile.getAbsolutePath() + " (exists = " + clientFile.exists() + ")");
            try {
                System.out.println("[ManageRemoteAccessService] Initialising communication channel as client");
                MappedChannel mappedFile = MappedChannel.openAsClient((File)serverFile, (File)clientFile, (long)30000L);
                System.out.println("[ManageRemoteAccessService] Initialising message handler");
                this.messenger = new MFMessageHandler(mappedFile, (MessageHandler)this);
            }
            catch (Throwable t) {
                System.out.println("[ManageRemoteAccessService] messenger failed:");
                t.printStackTrace();
            }
        }
        this.println("[ManageRemoteAccessService] Starting up service manager");
        String action = JWSystem.getAppLaunchProperty((String)PROPERTY_ACTION);
        this.println("[ManageRemoteAccessService] Action is '" + action + "'. Processing...");
        if (action == null) {
            this.println("[ManageRemoteAccessService] No action specified. Returning.");
            return;
        }
        if (action.equals(VALUE_ACTION_INSTALL)) {
            this.installService();
        } else if (action.equals(VALUE_ACTION_REMOVE)) {
            this.removeService();
        } else if (action.equals(VALUE_ACTION_REINSTALL_FORCED)) {
            this.removeService();
            try {
                SimpleGatewayServiceStop.stopService(true, false);
            }
            catch (Throwable t) {
                this.printStackTrace(t);
            }
            this.installService();
        } else if (action.equals(VALUE_ACTION_SAVECONFIG)) {
            this.println("[ManageRemoteAccessService] Calling saveConfig();");
            System.out.flush();
            this.saveConfig();
        }
        this.println("[ManageRemoteAccessService] Finished. Sending complete notification.");
        if (this.messenger != null) {
            this.messenger.sendMessage(new Message(655361));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        new ManageRemoteAccessService();
        System.exit(0);
    }

    public void saveConfig() {
        this.println("[ManageRemoteAccessService] Attempting to save configuration");
        try {
            String configFile = JWSystem.getAppLaunchProperty((String)PROPERTY_CONFIG_FILE);
            this.println("[ManageRemoteAccessService] configFile = " + configFile);
            String hexData = JWSystem.getAppLaunchProperty((String)PROPERTY_CONFIG_FILE_XML);
            byte[] configBytes = HexData.hexStringToByteArray((String)hexData);
            this.println("[ManageRemoteAccessService] configXML = " + new String(configBytes, StandardCharsets.UTF_8));
            this.println("[ManageRemoteAccessService] Writing configuration...");
            FileUtil.writeFile((String)configFile, (byte[])configBytes);
        }
        catch (Throwable t) {
            this.printStackTrace(t);
        }
        this.println("[ManageRemoteAccessService] Done!");
    }

    public static File getSimpleServiceExe() {
        File shared = JWSystem.getAllAppVersionsSharedFolder();
        File restricted = new File(shared, "restricted");
        if (!restricted.exists()) {
            restricted.mkdirs();
        }
        File simpleServiceFile = new File(JWSystem.getAppFolder(), "SimpleService.exe");
        File targetFile = new File(restricted, "SimpleService.exe");
        try {
            FileUtil.copy((File)simpleServiceFile, (File)targetFile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JWGenericOS.setReadableForAllUsersAndWait((File)restricted, (boolean)true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return targetFile;
    }

    public static String getLinuxServiceName() {
        if (OemBranding.OEM_IS_SH) {
            return "simplegateway";
        }
        return ManageRemoteAccessService.getShortServiceName();
    }

    public static String getShortServiceName() {
        String serviceName = OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME.toLowerCase().trim();
        serviceName = serviceName.replaceAll("\\s+", "");
        return serviceName;
    }

    public static String getWindowsDotServiceFilename() {
        if (OemBranding.OEM_IS_SH) {
            return "simplegateway.service";
        }
        return ManageRemoteAccessService.getShortServiceName() + ".service";
    }

    public static String getMacOSAgentName() {
        if (OemBranding.OEM_IS_SH) {
            return "com.simplehelp.simplegateway";
        }
        return "com.simplehelp." + ManageRemoteAccessService.getShortServiceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService() {
        block10: {
            this.println("[ManageRemoteAccessService] Removing service");
            String serviceDir = JWSystem.getAppLaunchProperty((String)PROPERTY_SERVICE_DIR);
            try {
                if (OS.isWindows()) {
                    File dotServiceFile = new File(serviceDir, ManageRemoteAccessService.getWindowsDotServiceFilename());
                    File simpleServiceFile = ManageRemoteAccessService.getSimpleServiceExe();
                    WindowsServiceManager manager = new WindowsServiceManager(simpleServiceFile);
                    manager.removeService(dotServiceFile);
                    dotServiceFile.delete();
                    break block10;
                }
                if (OS.isMacOS()) {
                    try {
                        MacOSServiceManager.unloadAgent((String)ManageRemoteAccessService.getMacOSAgentName(), (PrintStream)System.out);
                        break block10;
                    }
                    finally {
                        MacOSServiceManager.removeAgent((String)ManageRemoteAccessService.getMacOSAgentName(), (PrintStream)System.out);
                    }
                }
                LinuxServiceManager manager = new LinuxServiceManager("2 3 4 5", "0 1 6", "99", "0");
                try {
                    manager.stop(ManageRemoteAccessService.getLinuxServiceName());
                }
                finally {
                    manager.remove(ManageRemoteAccessService.getLinuxServiceName());
                }
            }
            catch (Throwable t) {
                this.printStackTrace(t);
            }
        }
    }

    public static File getLivenessFile() {
        File livenessFile = new File(JWSystem.getAllAppVersionsSharedFolder(), "sgalive");
        if (!livenessFile.exists()) {
            try {
                livenessFile.createNewFile();
                if (OS.isMacOS()) {
                    System.out.println("[SimpleGatewayService] Setting permissions for liveness file");
                    try {
                        JWGenericOS.setWritableForAllUsers((File)livenessFile, (boolean)true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return livenessFile;
    }

    public void installService() {
        try {
            this.println("[ManageRemoteAccessService] Installing service");
            String starterPath = JWSystem.getAppLaunchProperty((String)PROPERTY_START_LAUNCHER_PATH);
            String stopperPath = JWSystem.getAppLaunchProperty((String)PROPERTY_STOP_LAUNCHER_PATH);
            String serviceDir = JWSystem.getAppLaunchProperty((String)PROPERTY_SERVICE_DIR);
            ManageRemoteAccessService.installSgService(starterPath, stopperPath, serviceDir, ManageRemoteAccessService.getLivenessFile());
        }
        catch (Throwable t) {
            this.printStackTrace(t);
        }
    }

    public static void uninstallSgService(String serviceDir) throws Exception {
        if (OS.isWindows()) {
            File dotServiceFile = new File(serviceDir, ManageRemoteAccessService.getWindowsDotServiceFilename());
            File simpleServiceFile = ManageRemoteAccessService.getSimpleServiceExe();
            WindowsServiceManager manager = new WindowsServiceManager(simpleServiceFile);
            manager.removeService(dotServiceFile);
        } else if (OS.isMacOS()) {
            MacOSServiceManager.removeAgent((String)ManageRemoteAccessService.getMacOSAgentName(), (PrintStream)System.out);
        } else {
            LinuxServiceManager manager = new LinuxServiceManager("2 3 4 5", "0 1 6", "99", "0");
            manager.stop(ManageRemoteAccessService.getLinuxServiceName());
            manager.remove(ManageRemoteAccessService.getLinuxServiceName());
        }
    }

    public static void installSgService(String launcherPath, String stopPath, String serviceDir, File livenessFile) throws Exception {
        if (OS.isWindows()) {
            File dotServiceFile = new File(serviceDir, ManageRemoteAccessService.getWindowsDotServiceFilename());
            File simpleServiceFile = ManageRemoteAccessService.getSimpleServiceExe();
            WindowsServiceManager manager = new WindowsServiceManager(simpleServiceFile);
            manager.writeDotServiceFile(dotServiceFile, BuildConstants.REMOTE_ACCESS_SERVICE_NAME, "The SimpleHelp Remote Access Service registers this machine with a SimpleHelp server in order to facilitate remote support.", new File(serviceDir), launcherPath, new File(serviceDir), stopPath, false, false, livenessFile);
            try {
                System.out.println("[SimpleGatewayServiceConfigure] Removing any existing Windows service");
                manager.removeService(dotServiceFile);
                System.out.println("[SimpleGatewayServiceConfigure] Done removing any existing Windows service");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("[SimpleGatewayServiceConfigure] Installing Windows service");
            manager.installService(dotServiceFile);
            System.out.println("[SimpleGatewayServiceConfigure] Done installing Windows service");
        } else if (OS.isMacOS()) {
            System.out.println("[SimpleGatewayServiceConfigure] Installing OSX agent");
            File launcher = JWMacOS.getNativeLauncherForDotApp((File)new File(launcherPath));
            System.out.println("[SimpleGatewayServiceConfigure] Got native launcher " + launcher);
            MacOSServiceManager.installAgent((String)ManageRemoteAccessService.getMacOSAgentName(), (String[])new String[]{launcher.getAbsolutePath()}, (File)new File(serviceDir), (String[])new String[]{"Aqua", "LoginWindow"}, (PrintStream)System.out, (boolean)true);
            System.out.println("[SimpleGatewayServiceConfigure] Loading OSX agent");
            MacOSServiceManager.loadAgent((String)ManageRemoteAccessService.getMacOSAgentName(), (PrintStream)System.out);
            System.out.println("[SimpleGatewayServiceConfigure] Loaded OSX agent");
        } else {
            File waitForXLauncherScript;
            try {
                waitForXLauncherScript = ManageRemoteAccessService.createWaitForXScript(serviceDir, launcherPath);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                waitForXLauncherScript = new File(launcherPath);
            }
            System.out.println("[SimpleGatewayServiceConfigure] Installing Linux service");
            LinuxServiceManager manager = new LinuxServiceManager("2 3 4 5", "0 1 6", "99", "0");
            manager.installAndStart(ManageRemoteAccessService.getLinuxServiceName(), OemBranding.OEM_IS_SH ? "SimpleGateway remote access service" : OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME, "\"" + waitForXLauncherScript.getAbsolutePath() + "\"", "\"" + stopPath + "\"", "\"" + serviceDir + "\"", false);
            System.out.println("[SimpleGatewayServiceConfigure] Installed Linux service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createWaitForXScript(String serviceDir, String startExec) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#!/bin/bash\n");
        buffer.append("##############\n");
        buffer.append("# Pick up the X server pid, and sleep if it not up yet\n");
        buffer.append("##############\n");
        buffer.append("\n");
        buffer.append("oldXPid=\"-1\"\n");
        buffer.append("newXPid=\"\"\n");
        buffer.append("\n");
        buffer.append("getXPid()\n");
        buffer.append("{\n");
        buffer.append("\tXPid=` `\n");
        buffer.append("\tcounter=0\n");
        buffer.append("\twhile [  -z \"$XPid\" ]\n");
        buffer.append("\tdo \n");
        buffer.append("\t\tXPid=`ps ww -C X,Xorg | grep auth | awk '{ print $1 }'`\n");
        buffer.append("\t\n");
        buffer.append("\t\t##############\n");
        buffer.append("\t\t# Timeout after 3 minutes\n");
        buffer.append("\t\t##############\n");
        buffer.append("\t\tcounter=$(( $counter + 1 ))\n");
        buffer.append("\t\tif [ \"$counter\" -eq 180 ]\n");
        buffer.append("\t\tthen\n");
        buffer.append("\t\t\tbreak\n");
        buffer.append("\t\tfi\n");
        buffer.append("\t\tsleep 1\n");
        buffer.append("\tdone\n");
        buffer.append("\tsleep 1\n");
        buffer.append("\techo $XPid\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("getXAuthority()\n");
        buffer.append("{\n");
        buffer.append("\t##############\n");
        buffer.append("\t# Pickup the auth magic cookie from a ps scan\n");
        buffer.append("\t##############\n");
        buffer.append("\txauthority=`ps ww -C X,Xorg -o args= --sort=-stime | grep -m 1 -o '\\B[-]auth\\s*/\\S*' |  cut -d ' ' -f 2`\n");
        buffer.append("\techo $xauthority\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("getDisplay()\n");
        buffer.append("{\n");
        buffer.append("\t##############\n");
        buffer.append("\t# Pickup the display from a ps scan\n");
        buffer.append("\t##############\n");
        buffer.append("\tdisplay=`ps ww -C X,Xorg -o args= --sort=-stime | grep -m 1 '\\B[-]auth\\s*/\\S*' | grep -o '\\B[:][0-9]*' | head -n 1`\n");
        buffer.append("\techo $display\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("getDisplayAlternative()\n");
        buffer.append("{\n");
        buffer.append("\t##############\n");
        buffer.append("\t# Pickup the display from a /tmp/.X11-unix scan\n");
        buffer.append("\t##############\n");
        buffer.append("\tdisplay=`ls /tmp/.X11-unix | tr 'X' ':' | head -n 1`\n");
        buffer.append("\techo $display\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("while [ 1 ]\n");
        buffer.append("do\n");
        buffer.append("\tnewXPid=`getXPid`\n");
        buffer.append("\n");
        buffer.append("\texport XAUTHORITY=`getXAuthority`\n");
        buffer.append("\tif [ \"A$newXPid\" = \"A$oldXPid\" ]\n");
        buffer.append("\tthen\n");
        buffer.append("\t\tsleep 5\n");
        buffer.append("\telse\n");
        buffer.append("\t\techo \"[Remote Access] Detected XPid: $newXPid\"\n");
        buffer.append("\t\toldXPid=$newXPid\n");
        buffer.append("\n");
        buffer.append("\t\techo \"[Remote Access] Detected XAuthority: $XAUTHORITY\"\n");
        buffer.append("\n");
        buffer.append("\t\tdetectedDisplay=`getDisplay`\n");
        buffer.append("\t\tif [ -z $detectedDisplay ]\n");
        buffer.append("\t\tthen\n");
        buffer.append("\t\t\tdetectedDisplay=`getDisplayAlternative`\n");
        buffer.append("\t\tfi\n");
        buffer.append("\t\tif [ -z $detectedDisplay ]\n");
        buffer.append("\t\tthen\n");
        buffer.append("\t\t\tdetectedDisplay=\":0\"\n");
        buffer.append("\t\tfi\n");
        buffer.append("\t\texport DISPLAY=$detectedDisplay\n");
        buffer.append("\t\techo \"[Remote Access] Detected XDisplay: $DISPLAY\"\n");
        buffer.append("\n");
        buffer.append("\t\t\"" + startExec + "\"\n");
        buffer.append("\tfi\n");
        buffer.append("done\n");
        if (serviceDir == null) {
            System.out.println(buffer);
            return null;
        }
        File serviceDirectory = new File(serviceDir);
        File launcherFile = new File(serviceDirectory, "service_launch.sh");
        try (FileOutputStream fout = new FileOutputStream(launcherFile);){
            StreamUtils.writeStringISO88591WithoutSize(fout, buffer.toString());
        }
        JWGenericOS.setReadableForAllUsers((File)launcherFile, (boolean)false);
        return launcherFile;
    }

    public void handleMessage(Message bytesToMessage) {
    }

    public void closed() {
        if (this.messenger != null) {
            this.messenger.close();
        }
        this.messenger = null;
    }
}

