/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import com.aem.BuildDate;
import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.ServerManagement;
import com.aem.VersionUtil;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.server.SimpleDesktopServer;
import com.aem.sdesktop.server.controller.MiniController;
import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.server.gui.ServerGUI;
import com.aem.sdesktop.server.gui.ServerNoGUI;
import com.aem.sdesktop.util.MouseMover;
import com.aem.sgateway.ManageRemoteAccessService;
import com.aem.sgateway.SGExtensionUtil;
import com.aem.sgateway.SGHttpsUtil;
import com.aem.sgateway.SGServiceInstallationManager;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.SimpleGatewayService;
import com.aem.sgateway.SimpleGatewayServiceStop;
import com.aem.sgateway.common.SGPortUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.EncodedArgs;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.PasswordStorage;
import com.aem.shelp.util.ProxyOverride;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import com.aem.utils.entropy.TimedEntropyWrap;
import com.jw.AuxConfig;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileLockUtil;
import utils.files.FileUtil;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;
import utils.vm.VMFork;

public class AutomaticCustomer {
    private static FileLockUtil.LockResult sharedLockFile;

    private static File getAppFolder() {
        File appFolder = JWSystem.getAppFolder();
        if (appFolder.exists()) {
            return appFolder;
        }
        appFolder = new File("lib");
        if (!appFolder.exists()) {
            System.out.println("[AutomaticCustomer] ERROR: Cannot find app folder! Neither JWSystem nor lib folders present.");
        }
        return appFolder;
    }

    public static File getSessionTrackerLockFile() {
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("sessiontracker");
        }
        return new File(parent, "sessiontracker");
    }

    public static void main(String[] v3UnusedArguments) throws Exception {
        String activity;
        ConnectionSettings settings;
        SimpleGatewayConfig config;
        try {
            Acculog.setJVM("CustomerSession");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("[AutomaticCustomer] SimpleGateway Session v" + VersionUtil.getVersion());
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[Session] Session process is running");
        }
        AuxConfig.initAuxDownload();
        System.setProperty("apple.awt.UIElement", "true");
        FixedByteBuffer.injectIntoStdout();
        System.setProperty("http.agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.16) Gecko/20080702 Firefox/2.0.0.16");
        System.out.println("[AutomaticCustomer] Starting entropy wrap");
        TimedEntropyWrap.startup();
        System.out.println("[AutomaticCustomer] Started entropy wrap");
        System.out.println("[AutomaticCustomer] Starting CentralDebugging");
        try {
            CentralDebugging.loadDebugSettings("SimpleGatewayServiceSession", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("[AutomaticCustomer] Started CentralDebugging");
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[Session] Waiting for auxiliary archive downloads to complete");
        }
        System.out.println("[AutomaticCustomer] Loading native libs");
        try {
            AuxConfig.blockUntilAuxDownloaded();
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session] Auxiliary archives downloaded");
            }
            NativeLibraryLoader.loadLibrary(AutomaticCustomer.getAppFolder());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            NativeUtils.getInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            NativeScreenUtil.getInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            NativeGrab.getInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[AutomaticCustomer] Loaded native libs");
        AutomaticCustomer.tryDeleteDubiousLogs();
        if (OS.isMacOS()) {
            try {
                System.out.println("[AutomaticCustomer] Switching on Mac OS display");
                NativeScreenUtil.getInstance().switchOnDisplayMacOSX();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            sharedLockFile = FileLockUtil.sharedLockFile((File)AutomaticCustomer.getSessionTrackerLockFile(), (boolean)false);
            System.out.println("[AutomaticCustomer] Acquired shared lock");
        }
        catch (Throwable t) {
            System.out.println("[AutomaticCustomer] Failed to acquire shared lock");
            t.printStackTrace();
        }
        ClientManagement.SIMPLEGATEWAY = true;
        ClientManagement.SIMPLEHELP = false;
        boolean VERSION_3_INSTALLATION = false;
        File currentDir = new File(".").getAbsoluteFile();
        File sh3ConfigFile = new File(currentDir.getCanonicalFile().getParentFile().getParentFile(), "serviceconfig.xml");
        System.out.println("[AutomaticCustomer] Running from " + currentDir.getCanonicalPath());
        System.out.println("[AutomaticCustomer] Checking for V3 config file at " + sh3ConfigFile.getCanonicalPath());
        if (sh3ConfigFile.exists()) {
            VERSION_3_INSTALLATION = true;
        }
        if (VERSION_3_INSTALLATION) {
            System.out.println("[AutomaticCustomer] Version **3** installation");
            config = new SimpleGatewayConfig(sh3ConfigFile);
        } else {
            System.out.println("[AutomaticCustomer] Version 4+ installation");
            config = new SimpleGatewayConfig(SimpleGatewayConfig.getConfigLocation());
        }
        System.out.println("[AutomaticCustomer] Version is " + VersionUtil.getVersion());
        System.out.println("[AutomaticCustomer] Build is " + BuildDate.YMD + "-" + BuildDate.HMS);
        if (config.getPassword() != null) {
            PasswordStorage.REQUIRED = true;
            PasswordStorage.PASSWORD = config.getPassword();
        } else {
            PasswordStorage.REQUIRED = false;
        }
        if (config.getProxyHost() != null) {
            ProxyOverride.PROXY_HOST = config.getProxyHost();
            ProxyOverride.PROXY_PORT = "" + config.getProxyPort();
            if (config.getProxyUser() != null) {
                ProxyOverride.PROXY_USER = config.getProxyUser();
                ProxyOverride.PROXY_PASS = config.getProxyPass();
            }
        }
        System.out.println("[AutomaticCustomer] Proxy Host: " + ProxyOverride.PROXY_HOST);
        System.out.println("[AutomaticCustomer] Proxy Port: " + ProxyOverride.PROXY_PORT);
        System.out.println("[AutomaticCustomer] Proxy User: " + ProxyOverride.PROXY_USER);
        System.out.println("[AutomaticCustomer] Setting proxy from config");
        SimpleGatewayConfig.setJavaUrlProxyFromConfig(config);
        try {
            NativeUtils.getInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            NativeScreenUtil.getInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SimpleDesktopServer.callback_only = true;
        SimpleDesktopServer.callback_via_proxy_server = true;
        if (VERSION_3_INSTALLATION) {
            System.out.println("[AutomaticCustomer] Picking out V3 arguments");
            System.out.println("[AutomaticCustomer] Unencoding args");
            String[] args = EncodedArgs.unencodeArgs(v3UnusedArguments[0], true);
            System.out.println("[AutomaticCustomer] Unencoded args");
            for (int i = 0; i < args.length; ++i) {
                System.out.println("[AutomaticCustomer] v3 arg " + i + ": " + args[i]);
            }
            settings = new ConnectionSettings(new Customer(1, args[2]));
            settings.host = args[0];
            settings.port = Integer.parseInt(args[1]);
            settings.url = SGHttpsUtil.getRequiredHttpProtocol() + "://" + settings.host + ":" + settings.port + "/";
            activity = args[2];
        } else {
            System.out.println("[AutomaticCustomer] Loading V4 arguments");
            if (JWLaunchProperties.isJWrapperSetup()) {
                AutomaticCustomerArguments arguments = new AutomaticCustomerArguments();
                settings = new ConnectionSettings(new Customer(1, arguments.getID()));
                settings.host = arguments.getHost();
                settings.port = arguments.getPort();
                settings.url = SGHttpsUtil.getRequiredHttpProtocol() + "://" + settings.host + ":" + settings.port + "/";
                settings.remoteAccessMustRequestConnection = arguments.mustRequestConnection();
                settings.remoteAccessMustRequestConnectionTimeout = arguments.getRequestTimeout();
                System.out.println("[AutomaticCustomer] Loading safe resource bundle");
                Language.loadTranslations();
                activity = arguments.getID();
            } else {
                settings = new ConnectionSettings(new Customer(1));
                activity = "";
            }
        }
        try {
            SGExtensionUtil.load();
        }
        catch (Throwable arguments) {
            // empty catch block
        }
        System.out.println("[AutomaticCustomer] Checking for automated activity request");
        if (activity.startsWith("ACTIVITY_")) {
            String sgServiceDir = new File(".." + File.separator + ".." + File.separator).getCanonicalPath();
            if (!sgServiceDir.endsWith(File.separator)) {
                sgServiceDir = sgServiceDir + File.separator;
            }
            System.out.println("[AutomaticCustomer] Asked to perform automated activity " + activity);
            if (activity.startsWith("ACTIVITY_SERVICE_SESSION")) {
                MiniController mini = new MiniController();
                mini.backwardsConnection(activity, settings, new KillVmNodeLinkStatusListener(true), VERSION_3_INSTALLATION);
            } else if (activity.equals("ACTIVITY_RESTART_SERVICE")) {
                AutomaticCustomer.restartRemoteAccessService();
            } else if (activity.equals("ACTIVITY_STOP_DISABLE") || activity.equals("ACTIVITY_STOP_ONLY")) {
                System.out.println("[AutomaticCustomer] Asked to stop and disable SimpleGateway service");
                if (VERSION_3_INSTALLATION) {
                    System.out.println("[AutomaticCustomer] Asked to stop and disable Version **3** SimpleGateway service");
                    if (OS.isWindows()) {
                        WmicUtil util;
                        System.out.println("[AutomaticCustomer] Windows machine, trying to stop SG service");
                        try {
                            util = new WmicUtil();
                            util.stopService("SimpleGateway Service");
                            util.finish();
                            System.out.println(util.getResults());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            util = new WmicUtil();
                            util.stopService("SimpleGatewayService");
                            util.finish();
                            System.out.println(util.getResults());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            util = new WmicUtil();
                            util.stopService("SimpleHelpSimpleGatewayService");
                            util.finish();
                            System.out.println(util.getResults());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.println("[AutomaticCustomer] Windows machine, trying to disable SG service (start mode)");
                        try {
                            util = new WmicUtil();
                            util.setServiceStartModeDisabled("SimpleGateway Service");
                            util.finish();
                            System.out.println(util.getResults());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            util = new WmicUtil();
                            util.setServiceStartModeDisabled("SimpleHelpSimpleGatewayService");
                            util.finish();
                            System.out.println(util.getResults());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            util = new WmicUtil();
                            util.setServiceStartModeDisabled("SimpleGatewayService");
                            util.finish();
                            System.out.println(util.getResults());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        System.out.println("[AutomaticCustomer] Trying to stop the service");
                        SimpleGatewayServiceStop.stopService(false, true);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    if (activity.equals("ACTIVITY_STOP_DISABLE")) {
                        System.out.println("[AutomaticCustomer] Trying to disable .xml file");
                        File existingfile = SimpleGatewayConfig.getConfigLocation();
                        if (!existingfile.exists()) {
                            existingfile = new File("../../", "serviceconfig.xml");
                        }
                        if (!existingfile.exists()) {
                            System.out.println("[AutomaticCustomer] Unable to locate serverconfig.xml file for disabling?");
                        }
                        try {
                            existingfile.renameTo(new File(existingfile.getParentFile(), existingfile.getName() + ".old" + System.currentTimeMillis()));
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                        try {
                            String buffer = "<SimpleGatewayService>\n<Name>AUTODETECT</Name>\n</SimpleGatewayService>\n";
                            FileUtil.writeFile((File)existingfile, (byte[])buffer.getBytes(StandardCharsets.UTF_8));
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                } else {
                    System.out.println("[AutomaticCustomer] Asked to stop Version 4+ SimpleGateway service");
                    System.out.println("[AutomaticCustomer] ERROR request ignored, should use mini session");
                }
            } else {
                System.out.println("[AutomaticCustomer] ERROR - unrecognised activity " + activity);
            }
            System.exit(0);
        }
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[Session] Downloading branding from server");
        }
        try {
            ClientBranding.startBrandingDownload(SGHttpsUtil.getRequiredHttpProtocol() + "://" + settings.host + ":" + settings.port);
        }
        catch (Throwable sgServiceDir) {
            // empty catch block
        }
        System.out.println("[AutomaticCustomer] Launching MouseMover");
        File nativeLauncher = JWSystem.getNativeJavaLauncher();
        if (nativeLauncher != null) {
            VMFork.overrideDefaultJavaExe((String)nativeLauncher.getAbsolutePath());
        }
        final String factivity = activity;
        Thread mmovesetup = new Thread(){

            @Override
            public void run() {
                try {
                    boolean isActivitySession;
                    String classPath = System.getProperty("java.class.path");
                    String pathSeparator = System.getProperty("path.separator");
                    String[] jarPaths = classPath.split(pathSeparator);
                    boolean bl = isActivitySession = factivity != null && factivity.startsWith("ACTIVITY_");
                    if (MouseMover.mouseMoverRequired() && !isActivitySession) {
                        try {
                            MouseMover.getInstance(jarPaths, true, true);
                        }
                        catch (Throwable t) {
                            System.out.println("[AutomaticCustomer] Mouse mover startup failed. Requesting unelevated instance.");
                            t.printStackTrace();
                            MouseMover.getInstance(jarPaths, true, false);
                        }
                    } else {
                        MouseMover.setPathsForFutureUse(jarPaths);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (!Switches.SH_asyncMMoveStartup && LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Session] Launched MouseMover");
                }
                System.out.println("[AutomaticCustomer] Launched MouseMover (" + MouseMover.getStaticMouseMover() + "," + MouseMover.getPossiblyRestrictedMouseMover() + ")");
            }
        };
        if (Switches.SH_asyncMMoveStartup) {
            mmovesetup.start();
        } else {
            mmovesetup.run();
        }
        try {
            boolean headless = false;
            try {
                SimpleHelpFrame.setLnf();
            }
            catch (Throwable t) {
                System.setProperty("java.awt.headless", "true");
                headless = true;
            }
            if (!headless && SimpleHelpFrame.failedToLoad()) {
                System.out.println("[AutomaticCustomer] LNF failed to load - assuming headless.");
                headless = true;
            }
            ServerNoGUI gui = null;
            if (!headless) {
                try {
                    if (LocalSwitches.DEV_acculogSessionLaunch) {
                        Acculog.log("[Session] Waiting for branding to finish downloading");
                    }
                    ClientBranding.waitForBrandingToComplete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                JFrame frame = null;
                JPanel sui = null;
                System.out.println("[AutomaticCustomer] Creating panel");
                sui = new JPanel();
                System.out.println("[AutomaticCustomer] Setting layout");
                sui.setLayout(new GridLayout(1, 1));
                System.out.println("[AutomaticCustomer] Initialising chat frame");
                frame = AutomaticCustomer.initChatFrame();
                frame.getContentPane().add(sui);
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Session] Creating ServerGUI");
                }
                System.out.println("[AutomaticCustomer] Creating server gui");
                gui = new ServerGUI(frame, sui, false, true, null);
            } else {
                System.out.println("[AutomaticCustomer] Creating server gui");
                gui = new ServerNoGUI(false, true);
            }
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session] Initing GUI and Controller");
            }
            System.out.println("[AutomaticCustomer] Creating controller");
            SDesktopServerController con = new SDesktopServerController(Language.DEFLANG);
            System.out.println("[AutomaticCustomer] Initing controller");
            gui.init(con, config.getName());
            System.out.println("[AutomaticCustomer] Setting controller server");
            con.setGUI(gui);
            settings.rdp = true;
            settings.ftp = true;
            settings.chat = true;
            settings.queuePassword = null;
            gui.setEnabled(false);
            if (CentralDebugging.ENABLE_NATIVE_HOOKS) {
                AutomaticCustomer.setupInputCapture();
            }
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session] Initiating session connection");
            }
            System.out.println("[AutomaticCustomer] Initialised server and controller ok, starting remote connection");
            if (gui.requestCallbackConnection(settings, new KillVmNodeLinkStatusListener(false))) {
                gui.setEnabled(true);
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Session] Connected OK");
                }
            } else {
                System.out.println("[AutomaticCustomer] Initialised server and controller ok, starting remote connection");
                gui.setFinished();
                System.out.println("[AutomaticCustomer] Exiting now...");
                if (!ServerManagement.isServerJVM()) {
                    System.exit(1);
                }
            }
        }
        catch (Throwable t) {
            System.out.println("[AutomaticCustomer] Attempt to connect failed");
            t.printStackTrace(System.out);
            System.out.println("[AutomaticCustomer] Exiting in 10...");
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Runtime.getRuntime().halt(88);
        }
    }

    public static void restartRemoteAccessService() throws Exception {
        long timeout;
        File myPortFile = SGPortUtil.getSGPortFile(true);
        int currentPort = SimpleGatewayServiceStop.getMySGPort();
        boolean portFileIsLocked = SGPortUtil.isSGPortFileLocked(myPortFile);
        System.out.println("[AutomaticCustomer] Restart requested. Port file locked = " + portFileIsLocked);
        ForceKillThread fkt = new ForceKillThread();
        fkt.start();
        try {
            System.out.println("[AutomaticCustomer] Trying to stop the service (" + currentPort + ")");
            SimpleGatewayServiceStop.stopJustMyService(true, false);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        fkt.cease();
        if (portFileIsLocked) {
            boolean serviceDead;
            System.out.println("[AutomaticCustomer] Port file is locked - waiting for up to 60 seconds for the service to die");
            timeout = System.currentTimeMillis() + 60000L;
            boolean bl = serviceDead = !SGPortUtil.isSGPortFileLocked(myPortFile);
            while (!serviceDead && System.currentTimeMillis() < timeout) {
                int newPort;
                Thread.sleep(100L);
                serviceDead = !SGPortUtil.isSGPortFileLocked(myPortFile);
                if (serviceDead || (newPort = SimpleGatewayServiceStop.getMySGPort()) == currentPort) continue;
                System.out.println("[AutomaticCustomer] Detected a SGPort change (" + currentPort + "->" + newPort + ")");
                System.out.println("[AutomaticCustomer] Trying to stop the service (" + newPort + ")");
                SimpleGatewayServiceStop.stopJustMyService(true, false);
                currentPort = newPort;
            }
            if (serviceDead) {
                System.out.println("[AutomaticCustomer] Services are all terminated");
            }
        } else {
            System.out.println("[AutomaticCustomer] SGPort was not locked - will wait for 30 seconds to make sure");
            currentPort = -1;
            timeout = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < timeout) {
                Thread.sleep(100L);
                if (!SGPortUtil.isSGPortFileLocked(myPortFile)) continue;
                System.out.println("[AutomaticCustomer] SGPort is locked!");
                int newPort = SimpleGatewayServiceStop.getMySGPort();
                if (newPort == currentPort) continue;
                System.out.println("[AutomaticCustomer] Detected a SGPort change (" + currentPort + "->" + newPort + ")");
                SimpleGatewayServiceStop.stopJustMyService(true, false);
                currentPort = newPort;
            }
        }
        timeout = System.currentTimeMillis() + 30000L;
        while (SGPortUtil.isSGPortFileLocked(myPortFile) && System.currentTimeMillis() < timeout) {
            Thread.sleep(2000L);
            try {
                System.out.println("[AutomaticCustomer] Forcefully terminating a V4 service.");
                SimpleGatewayServiceStop.forceKillMyV4Service();
            }
            catch (Throwable newPort) {
                // empty catch block
            }
            Thread.sleep(500L);
        }
        if (OS.isWindowsVistaOrAbove() && Switches.SH_restartRaServiceOnWindowsUpdate) {
            try {
                Thread restart = new Thread(){

                    @Override
                    public void run() {
                        Process p;
                        System.out.println("[AutomaticCustomer] Attempting to restart the Windows service");
                        System.out.println("");
                        try {
                            System.out.println("[AutomaticCustomer] Stopping windows service [" + OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME + "]...");
                            p = Runtime.getRuntime().exec(new String[]{"net", "stop", OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME});
                            ProcessPrinter.printAllOutputToStdout((Process)p);
                            p.waitFor();
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                        try {
                            System.out.println("[AutomaticCustomer] Starting windows service [" + OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME + "]...");
                            p = Runtime.getRuntime().exec(new String[]{"net", "start", OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME});
                            ProcessPrinter.printAllOutputToStdout((Process)p);
                            p.waitFor();
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                };
                restart.start();
                restart.join(30000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            System.out.println("Service attempted restart is complete (or timed out after 30s), continuing...");
        }
        timeout = System.currentTimeMillis() + 180000L;
        System.out.println("[AutomaticCustomer] Waiting for organic service to come up.");
        boolean isLocked = SGPortUtil.isSGPortFileLocked(myPortFile);
        while (!isLocked && System.currentTimeMillis() < timeout) {
            Thread.sleep(1000L);
            isLocked = SGPortUtil.isSGPortFileLocked(myPortFile);
        }
        boolean serviceRestartedOrganically = isLocked;
        if (serviceRestartedOrganically) {
            System.out.println("[AutomaticCustomer] New organic service detected, all is well.");
        } else {
            System.out.println("[AutomaticCustomer] No organic service appeared, so trying to spawn one now.");
            AutomaticCustomer.restartService();
            System.out.println("[AutomaticCustomer] Waiting for new service to come up.");
            timeout = System.currentTimeMillis() + 300000L;
            while (System.currentTimeMillis() < timeout) {
                if (SGPortUtil.isSGPortFileLocked(myPortFile)) {
                    System.out.println("[AutomaticCustomer] New forced service detected, all is well.");
                    break;
                }
                Thread.sleep(1000L);
            }
        }
    }

    private static void restartService() throws Exception {
        boolean inheritProps;
        Properties cleanProps;
        System.out.println("[AutomaticCustomer] Restarting the service");
        boolean hardRestartRequired = false;
        if (OS.isWindowsVistaOrAbove()) {
            System.out.println("[AutomaticCustomer] Windows Vista or later detected, with session isolation.");
            try {
                int mySessionID = JWNativeAPI.getInstance().getTsMySessionId();
                System.out.println("[AutomaticCustomer] This process session ID is " + mySessionID);
                if (mySessionID > 0) {
                    System.out.println("[AutomaticCustomer] Manage remote access service restart required");
                    hardRestartRequired = true;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (Switches.SH_1567_useCleanPropertiesForRaLaunch) {
            try {
                cleanProps = SimpleGatewayService.sessionGetAccessServiceLaunchPropsOrNull(false);
                inheritProps = false;
                if (cleanProps == null) {
                    throw new Exception("WARNING: SG service shortcut does not exist yet, unable to load clean properties from RA launcher");
                }
            }
            catch (Exception x) {
                System.out.println("[AutomaticCustomer] WARNING: unable to load clean RA properties from launcher: " + x);
                x.printStackTrace();
                cleanProps = new Properties();
                System.out.println("[AutomaticCustomer] Will use inherited properties with key props forcibly reset");
                cleanProps.setProperty("launch_expect_appversion", "");
                cleanProps.setProperty("launch_expect_appname", "");
                cleanProps.setProperty("launch_prepare_only", "");
                cleanProps.setProperty("launch_in_specific_session", "");
                cleanProps.setProperty("launch_in_session", "");
                inheritProps = true;
            }
        } else {
            cleanProps = new Properties();
            inheritProps = true;
        }
        if (!hardRestartRequired) {
            JWSystem.forkVirtualApp((String)"Remote Access Service", (Properties)cleanProps, (String[])new String[0], (boolean)false, (boolean)true, (boolean)inheritProps);
        } else {
            try {
                System.out.println("[AutomaticCustomer] Attempting to use manage remote access service to restart the service.");
                AutomaticCustomer.useManageRemoteServiceToRestart();
            }
            catch (Exception ex) {
                System.out.println("[AutomaticCustomer] Manage remote access service launch failed.");
                ex.printStackTrace();
                JWSystem.forkVirtualApp((String)"Remote Access Service", (Properties)cleanProps, (String[])new String[0], (boolean)false, (boolean)true, (boolean)inheritProps);
            }
        }
    }

    private static void useManageRemoteServiceToRestart() throws Exception {
        File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
        File targetDirectory = new File(parentDirectory, "SimpleGatewayService");
        File starter = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"SimpleGatewayService");
        File stopper = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"StopSimpleGatewayService");
        Properties lprops = new Properties();
        if (OS.isWindows()) {
            lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, "\"" + starter.getCanonicalPath() + "\"");
            lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, "\"" + stopper.getCanonicalPath() + "\"");
        } else {
            lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
            lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
        }
        SGServiceInstallationManager.initManageServiceVirtualApp(lprops, ManageRemoteAccessService.VALUE_ACTION_INSTALL, null);
    }

    private static void tryDeleteDubiousLogs() {
        try {
            File file;
            if (OS.isWindows() && (file = new File("C:\\ProgramData\\SimpleHelp\\service.log")).exists()) {
                file.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static JFrame initChatFrame() {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        try {
            frame.setIconImage(ClientBranding.get().getLogo32(ClientManagement.isSimpleHelp()).getImage());
        }
        catch (Throwable t) {
            System.out.println("[AutomaticCustomer] Cannot set the frame icon (" + t.getMessage() + ")");
        }
        frame.setTitle(Language.get("CHAT_CUSTOMER_TITLE"));
        int width = 300;
        int height = 400 + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT;
        frame.setSize(width, height);
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Dimension dim = defaultToolkit.getScreenSize();
        Insets screenInsets = defaultToolkit.getScreenInsets(frame.getGraphicsConfiguration());
        int x = dim.width - screenInsets.right - width;
        int y = dim.height - screenInsets.bottom - height;
        frame.setLocation(x, y);
        frame.setDefaultCloseOperation(0);
        System.out.println("[AutomaticCustomer] screenInsets=" + screenInsets + " x=" + x + " y=" + y);
        return frame;
    }

    private static void setupInputCapture() {
        System.out.println("[AutomaticCustomer] Setting up keyboard capture hook");
        if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
            new Thread("KeyboardHook"){

                @Override
                public void run() {
                    System.out.println("[CommonHelpUtil] Loading keyboard hook.");
                    JWNativeAPI.getInstance().installKeyboardHookAndBlockThread(null);
                }
            }.start();
            new Thread("MouseHook"){

                @Override
                public void run() {
                    System.out.println("[CommonHelpUtil] Loading mouse hook.");
                    JWNativeAPI.getInstance().installMouseHook();
                }
            }.start();
        } else {
            System.out.println("[AutomaticCustomer] Cannot set up keyboard capture hook as NativeUtils was not initialised.");
        }
    }

    public static class AutomaticCustomerArguments {
        private final Properties properties;
        static final String KEY_HOST = "AutomaticCustomerHost";
        static final String KEY_PORT = "AutomaticCustomerPort";
        static final String KEY_ID = "AutomaticCustomerID";
        static final String KEY_MUSTREQUEST = "AutomaticCustomerRequest";
        static final String KEY_MUSTREQUEST_TIMEOUT = "AutomaticCustomerRequestTimeout";

        AutomaticCustomerArguments(Properties properties) {
            this.properties = properties;
        }

        AutomaticCustomerArguments() {
            this(new Properties());
        }

        boolean mustRequestConnection() {
            String val = JWLaunchProperties.getProperty((String)KEY_MUSTREQUEST);
            if (val != null) {
                return Boolean.parseBoolean(val);
            }
            return false;
        }

        public long getRequestTimeout() {
            String val = JWLaunchProperties.getProperty((String)KEY_MUSTREQUEST_TIMEOUT);
            try {
                if (val != null && val.length() > 0) {
                    return Long.parseLong(val);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 0L;
            }
            return 0L;
        }

        public Properties getPopulatedProperties() {
            return this.properties;
        }

        public String getHost() {
            String val = JWLaunchProperties.getProperty((String)KEY_HOST);
            if (val != null) {
                return val;
            }
            return "";
        }

        public void setHost(String host) {
            this.properties.setProperty(KEY_HOST, host);
        }

        public int getPort() {
            String val = JWLaunchProperties.getProperty((String)KEY_PORT);
            if (val != null) {
                return Integer.parseInt(val);
            }
            return -1;
        }

        public void setPort(int port) {
            this.properties.setProperty(KEY_PORT, Integer.toString(port));
        }

        public String getID() {
            String val = JWLaunchProperties.getProperty((String)KEY_ID);
            if (val != null) {
                return val;
            }
            return "";
        }

        public void setID(String ID) {
            this.properties.setProperty(KEY_ID, ID);
        }
    }

    private static class ForceKillThread
    extends Thread {
        boolean mustKill = true;

        private ForceKillThread() {
        }

        @Override
        public void run() {
            this.setName("ForceKillThread");
            for (int i = 0; i < 120; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.mustKill) continue;
                return;
            }
            System.out.println("[AutomaticCustomer] 2 min timeout, forcing termination of the SG service");
            if (!this.mustKill) {
                return;
            }
            SimpleGatewayServiceStop.forceKillMyV4Service();
            System.out.println("[AutomaticCustomer] Forced termination of SG service attempted");
        }

        public void cease() {
            this.mustKill = false;
        }
    }

    static class KillVmNodeLinkStatusListener
    implements NodeLinkStatusListener {
        final boolean fast;

        public KillVmNodeLinkStatusListener(boolean fast) {
            this.fast = fast;
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            int delay = 3500;
            if (!this.fast) {
                delay = 90000;
            }
            Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    MouseMover.killAllMouseMoversWith5SecondPossibleWait();
                    System.exit(0);
                }
            }, delay);
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
        }

        @Override
        public void linkOK(NodeLink link) {
        }
    }
}

