/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.CentralDebugging;
import com.aem.thp.LevelGzipOutputStream;
import com.aem.utils.StreamUtils;
import com.aem.utils.VariableLengthStreamUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.stream.OpenByteArrayOutputStream;

public class ScreenDataBatch {
    protected static final boolean COMPRESS = true;
    protected static final boolean DEFLATE = true;
    BufferedOutputStream bfout;
    DeflaterOutputStream dout;
    LevelGzipOutputStream zout;
    OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
    int count = 0;
    byte[] empty = new byte[0];
    static long aggregateGzipNperTime;
    static long aggregateGzipSize;
    static long aggregateDeflateMaxNperTime;
    static long aggregateDeflateMaxSize;
    static long aggregateDeflateNperTime;
    static long aggregateDeflateSize;

    public byte[] getEmpty() {
        return this.empty;
    }

    public ScreenDataBatch() {
        this.reset();
    }

    public void reset() {
        try {
            this.count = 0;
            this.bout.reset();
            this.dout = new DeflaterOutputStream((OutputStream)new BufferedOutputStream((OutputStream)this.bout), new Deflater(2));
            this.bfout = new BufferedOutputStream(this.dout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCachedBlock(Message m) throws IOException {
        MessageUtils.writeMessage((OutputStream)this.bfout, (Message)m);
        ++this.count;
    }

    public void addTranslatedBlock(Message m, ArrayList scanlines) throws IOException {
        MessageUtils.writeMessage((OutputStream)this.bfout, (Message)m);
        VariableLengthStreamUtils.writeInt(this.bfout, scanlines.size() * 3);
        for (int i = 0; i < scanlines.size(); ++i) {
            int[] tmp = (int[])scanlines.get(i);
            VariableLengthStreamUtils.writeInt(this.bfout, tmp[0]);
            VariableLengthStreamUtils.writeInt(this.bfout, tmp[1]);
            VariableLengthStreamUtils.writeInt(this.bfout, tmp[2]);
        }
        ++this.count;
    }

    public void addBlock(Message m, byte[] dat, int offset, int len) throws IOException {
        MessageUtils.writeMessage((OutputStream)this.bfout, (Message)m);
        VariableLengthStreamUtils.writeInt(this.bfout, len);
        this.bfout.write(dat, offset, len);
        ++this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int compressedSize() {
        return this.bout.size();
    }

    public Message getBatchMessage() throws IOException {
        Message all = new Message(196617);
        this.bfout.flush();
        this.dout.finish();
        this.dout.flush();
        all.append(this.count);
        all.appendRef_WARNING_NO_GETS(this.bout.getByteArray(), 0, this.bout.size());
        if (CentralDebugging.SCR_TEST_SCREEN_COMPRESSION) {
            try {
                BufferedOutputStream out;
                DeflaterOutputStream zip;
                InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(this.bout.toByteArray()));
                byte[] source = StreamUtils.readAll(in);
                System.out.println("[Screen Compression Test] Uncompressed: " + source.length);
                ByteArrayOutputStream btest = new ByteArrayOutputStream(source.length * 2);
                long T = System.currentTimeMillis() + 1000L;
                int N = 0;
                while (System.currentTimeMillis() < T) {
                    btest.reset();
                    zip = new DeflaterOutputStream((OutputStream)new BufferedOutputStream(btest), new Deflater(2));
                    out = new BufferedOutputStream(zip);
                    ((OutputStream)out).write(source);
                    ((OutputStream)out).flush();
                    zip.finish();
                    ++N;
                }
                System.out.println("[Screen Compression Test] Deflater HUFFMAN: " + N + " per second, " + btest.size());
                aggregateDeflateNperTime += (long)N;
                aggregateDeflateSize += (long)btest.size();
                T = System.currentTimeMillis() + 1000L;
                N = 0;
                while (System.currentTimeMillis() < T) {
                    btest.reset();
                    zip = new DeflaterOutputStream((OutputStream)new BufferedOutputStream(btest), new Deflater(1));
                    out = new BufferedOutputStream(zip);
                    ((OutputStream)out).write(source);
                    ((OutputStream)out).flush();
                    zip.finish();
                    ++N;
                }
                System.out.println("[Screen Compression Test] Deflater BEST_COMPRESSION: " + N + " per second, " + btest.size());
                aggregateDeflateMaxNperTime += (long)N;
                aggregateDeflateMaxSize += (long)btest.size();
                T = System.currentTimeMillis() + 1000L;
                N = 0;
                while (System.currentTimeMillis() < T) {
                    btest.reset();
                    zip = new LevelGzipOutputStream(new BufferedOutputStream(btest));
                    ((LevelGzipOutputStream)zip).setLevel(5);
                    out = new BufferedOutputStream(zip);
                    ((OutputStream)out).write(source);
                    ((OutputStream)out).flush();
                    ((GZIPOutputStream)zip).finish();
                    ++N;
                }
                System.out.println("[Screen Compression Test] 3.11 (GZIP lvl 5): " + N + " per second, " + btest.size());
                System.out.println("[Screen Compression Test] Aggregates:");
                System.out.println("[Screen Compression Test] -- 3.11 GZIP lvl 5 - " + (aggregateGzipNperTime += (long)N) + " iterations, " + (aggregateGzipSize += (long)btest.size()) + " bytes");
                System.out.println("[Screen Compression Test] -- Deflate HUFFMAN - " + aggregateDeflateNperTime + " iterations, " + aggregateDeflateSize + " bytes");
                System.out.println("[Screen Compression Test] -- Deflate BEST_COMPRESSION - " + aggregateDeflateMaxNperTime + " iterations, " + aggregateDeflateMaxSize + " bytes");
            }
            catch (Throwable t) {
                System.out.println("[Screen Compression Test] failed: " + t);
                t.printStackTrace();
            }
            this.dout = new DeflaterOutputStream((OutputStream)new BufferedOutputStream((OutputStream)this.bout), new Deflater(2));
            this.bfout = new BufferedOutputStream(this.dout);
        } else {
            this.zout = new LevelGzipOutputStream(new BufferedOutputStream((OutputStream)this.bout));
            this.zout.setLevel(5);
            this.bfout = new BufferedOutputStream(this.zout);
        }
        return all;
    }

    public static Message[] splitBatchMessage(Message batch) throws IOException {
        int count = (Integer)batch.get(0);
        byte[] dat = (byte[])batch.get(1);
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        InflaterInputStream gin = new InflaterInputStream(bin);
        Message[] packets = new Message[count];
        for (int i = 0; i < packets.length; ++i) {
            int mlen;
            Message m = MessageUtils.readMessage((InputStream)gin);
            if (m.getType() == 196641) {
                mlen = VariableLengthStreamUtils.readInt(gin);
                for (int z = 0; z < mlen; ++z) {
                    m.append(VariableLengthStreamUtils.readInt(gin));
                }
            } else if (m.getType() != 196640) {
                mlen = VariableLengthStreamUtils.readInt(gin);
                byte[] mdat = VariableLengthStreamUtils.readBytes(gin, mlen);
                m.set(7, (Object)mdat);
            }
            packets[i] = m;
        }
        return packets;
    }

    public static void main(String[] args) throws Exception {
        ScreenDataBatch sdb = new ScreenDataBatch();
        for (int i = 0; i < 10; ++i) {
            byte[] data = new byte[5];
            for (int k = 0; k < data.length; ++k) {
                data[k] = (byte)i;
            }
            Message m = new Message(196611);
            m.append(i);
            m.append(i);
            m.append(i);
            m.append(i);
            m.append(i);
            m.append(i);
            m.append(i);
            m.append(data);
            m.append(i);
            m.append(i);
            sdb.addBlock(m, data, 0, data.length);
        }
        Message batch = sdb.getBatchMessage();
        batch = MessageUtils.bytesToMessage((byte[])MessageUtils.messageToBytes((Message)batch));
        Message[] packets = ScreenDataBatch.splitBatchMessage(batch);
        for (int i = 0; i < packets.length; ++i) {
            System.out.println(packets[i]);
            byte[] dat = (byte[])packets[i].get(7);
            for (int k = 0; k < dat.length; ++k) {
                System.out.println(dat[k]);
            }
        }
    }
}

