/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import java.awt.Robot;
import java.awt.Toolkit;
import java.util.Properties;
import utils.ostools.LockUtil;

public class CleanupWithProperties {
    public static void cleanup(Properties properties) {
        boolean setToOn;
        String prop;
        try {
            prop = properties.getProperty("numlock");
            if (prop != null) {
                setToOn = Boolean.parseBoolean(prop);
                CleanupWithProperties.restoreNumlock(setToOn);
            }
        }
        catch (Throwable t) {
            System.out.println("[CleanupWithProperties] Error reinstating NUM LOCK.");
            t.printStackTrace();
        }
        try {
            prop = properties.getProperty("lock");
            if (prop != null) {
                System.out.println("[CleanupWithProperties] Locking desktop");
                setToOn = Boolean.parseBoolean(prop);
                if (setToOn) {
                    LockUtil.lockDesktop();
                }
            }
        }
        catch (Throwable t) {
            System.out.println("[CleanupWithProperties] Error locking desktop");
            t.printStackTrace();
        }
    }

    private static void restoreNumlock(boolean setToOn) {
        System.out.println("[CleanupWithProperties] Reinstating NUM LOCK to " + setToOn);
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (tk.getLockingKeyState(144) != setToOn) {
                tk.setLockingKeyState(144, setToOn);
            }
        }
        catch (Exception tk) {
            // empty catch block
        }
        try {
            Robot robot = new Robot();
            robot.keyRelease(144);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

