/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.sounds;

import com.aem.utils.StreamUtils;
import com.aem.utils.sound.SampledSound;
import com.aem.utils.sound.SoundUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.sound.sampled.Mixer;

public class SHSounds {
    public static SampledSound beep;
    public static SampledSound bell;
    public static SampledSound clang;
    public static SampledSound ding;
    public static SampledSound notify;
    public static SampledSound pong;
    public static SampledSound pop;
    public static SampledSound ptwiiing;
    static Mixer mix;

    public static SampledSound loadSound(String filename) {
        try {
            Class<?> techSoundsClass;
            InputStream resourceAsStream = SHSounds.class.getResourceAsStream(filename);
            if (resourceAsStream == null && (resourceAsStream = (techSoundsClass = Class.forName("com.aem.shelp.tech.notifiers.audio.TechSounds")).getResourceAsStream(filename)) == null) {
                return null;
            }
            byte[] bytes = StreamUtils.readAll(resourceAsStream);
            SampledSound sound = new SampledSound(filename, new ByteArrayInputStream(bytes));
            return sound;
        }
        catch (Exception ex) {
            System.out.println("[Sound Mixer] Unable to load audio '" + filename + "'");
            ex.printStackTrace();
            return null;
        }
    }

    public static void play(SampledSound sound) {
        if (sound == null) {
            return;
        }
        System.out.println("[ShSounds] Play " + sound.getName() + " through " + mix);
        if (mix == null) {
            return;
        }
        try {
            SoundUtils.playSound(sound, mix);
        }
        catch (Exception e) {
            System.out.println("[Sound Mixer] Unable to play sound " + sound.getName());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Thread.sleep(1000L);
        System.out.println("Format: " + SHSounds.bell.format);
        System.out.println("Size: " + SHSounds.bell.data.length);
        SHSounds.play(bell);
    }

    static {
        new Thread(){

            @Override
            public void run() {
                System.out.println("[ShSounds] Loading sounds...");
                beep = SHSounds.loadSound("beep.wav");
                bell = SHSounds.loadSound("bell.wav");
                clang = SHSounds.loadSound("clang.wav");
                ding = SHSounds.loadSound("ding.wav");
                notify = SHSounds.loadSound("notify.wav");
                pong = SHSounds.loadSound("pong.wav");
                pop = SHSounds.loadSound("pop.wav");
                ptwiiing = SHSounds.loadSound("ptwiiing.wav");
                try {
                    mix = SoundUtils.getMixer(bell);
                }
                catch (Throwable t) {
                    System.out.println("[Sound Mixer] Unable to start audio mixer (" + t.getMessage() + ")");
                }
            }
        }.start();
    }
}

