/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.gui;

import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.interfaces.ServerConnection;
import com.aem.sdesktop.interfaces.ServerController;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.TechPresenceVisibilityDialog;
import com.aem.utils.NativeUtils;
import com.aem.utils.Pair;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import jwrapper.hidden.JWNativeAPI;
import utils.ostools.OS;
import utils.swing.images.ImageLoader;

public class ServerNoGUI
implements GuiConstants,
ServerUserInterface {
    protected boolean sdemoConnection = false;
    protected boolean remoteAccessConnection;
    protected ServerController controller;
    protected Customer customer = null;
    private boolean isFirstShowingOfInvitationDialog = true;
    protected SDesktopServerController.ServerOptions serverOptions;
    protected boolean expectReboot = false;
    protected boolean processedEndOfSessionActions = false;
    protected TechPresenceVisibilityDialog.TechnicianInfoPanel technicianInfoPanel;
    private ArrayList sdesktopServerInstanceList;

    public ServerNoGUI(boolean sdemoConnection, boolean remoteAccessConnection) {
        this.sdemoConnection = sdemoConnection;
        this.remoteAccessConnection = remoteAccessConnection;
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    @Override
    public void setTechnicianConnectedStatus(boolean connected, String name, String hostname, long startTime) {
    }

    private void handleError(Exception e, String message, String title) {
        this.handleError(e, message, title, null);
    }

    protected void handleError(Exception e, String message, String title, Icon icon) {
    }

    public boolean requestCallbackConnection(ConnectionSettings settings, NodeLinkStatusListener status) {
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                this.controller.backwardsConnection(settings, status);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.sdemoConnection) continue;
                if (e instanceof ConnectException) {
                    this.handleError(e, "Attempted connection to " + settings.getConnectString() + " failed, please check you have proper access", "Connection Failed");
                    continue;
                }
                if (e instanceof SocketTimeoutException || e instanceof EOFException || e instanceof SocketException) {
                    this.handleError(e, "Connection to " + settings.getConnectString() + " terminated", "Connection Failed");
                    continue;
                }
                if (e instanceof IOException) {
                    if (!this.controller.userRequestedEndSession()) {
                        this.handleError(e, "Connection to " + settings.getConnectString() + " failed: " + e.getMessage(), "Connection Failed");
                        continue;
                    }
                    this.handleError(e, Language.get("USER_CANCELLED_MSG"), Language.get("USER_CANCELLED_TITLE"), ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,48"));
                    continue;
                }
                if (e instanceof SDesktopServerController.IncorrectPasswordException) {
                    settings.queuePassword = this.getNewQueuePassword();
                    if (settings.queuePassword != null) {
                        retry = true;
                        continue;
                    }
                    retry = false;
                    continue;
                }
                if (e instanceof SDesktopServerController.BadInvitationException) {
                    settings.invitationID = this.getInvitationID(settings);
                    this.isFirstShowingOfInvitationDialog = false;
                    if (settings.invitationID != null) {
                        retry = true;
                        continue;
                    }
                    retry = false;
                    continue;
                }
                if (e instanceof SDesktopServerController.ExpiredInvitationException || e instanceof SDesktopServerController.ConnectionTerminatedException) continue;
                this.handleError(e, "Connection to " + settings.getConnectString() + " failed: " + e, "Connection Failed");
            }
        }
        this.setFinished();
        return false;
    }

    private String getInvitationID(ConnectionSettings settings) {
        return null;
    }

    protected String getNewQueuePassword() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFinished() {
        ServerNoGUI serverNoGUI = this;
        synchronized (serverNoGUI) {
            this.setEnabled(false);
            this.cleanUp();
        }
    }

    @Override
    public void setWaiting() {
        this.setEnabled(false);
    }

    @Override
    public void setConnected() {
        this.setEnabled(true);
    }

    public JComponent getParentFrame() {
        return this.getFrame();
    }

    public JComponent getParentComponent() {
        return this.getFrame();
    }

    public void updateWhiteBoard() {
    }

    public String[] getUsers() {
        return this.controller.getUsers();
    }

    public BufferedImage getUserWhiteboard(String user) {
        return this.controller.getUserWhiteboard(user);
    }

    @Override
    public JComponent getFrame() {
        return null;
    }

    @Override
    public void setCurrentConnections(ArrayList alist) {
        this.sdesktopServerInstanceList = alist;
    }

    @Override
    public void printToLog(String s) {
    }

    @Override
    public void printToConnectionLog(ServerConnection conn, long time, String text) {
    }

    @Override
    public void setLivePortRange(boolean islive, Pair range) {
    }

    @Override
    public void clearLivePorts() {
    }

    @Override
    public void setUserList(String[] users) {
    }

    public void setEnabled(boolean b) {
    }

    private void cleanUp() {
        try {
            if (NativeUtils.getInstance() != null) {
                NativeUtils.getInstance().stopBlankScreenThread();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
                JWNativeAPI.getInstance().setBlockInputHookEnabled(false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
                JWNativeAPI.getInstance().setMouseHookEnabled(false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void init(ServerController controller, String displayName) {
        this.controller = controller;
    }

    public void setNoChat() {
    }

    @Override
    public void receiveMessage(String msg, String username, String hostname) {
    }

    @Override
    public void setAvatar(byte[] bytes, String username, String displayName) {
    }

    @Override
    public void setServerOptions(SDesktopServerController.ServerOptions serverOptions) {
        System.out.println("[ServerGUI] Show technician presence is " + serverOptions.showTechPresenceDialog);
        this.serverOptions = serverOptions;
    }

    public int getChatPanelHeight() {
        return 0;
    }

    @Override
    public void alertUser() {
    }

    @Override
    public void setTechnicianIsTyping(String displayName) {
    }

    @Override
    public void expectTechnicianInitiatedReboot() {
        this.expectReboot = true;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }
}

