/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.server.controller.GrabSpec;
import com.aem.sdesktop.server.controller.MultiScreenMapper;
import com.aem.sdesktop.server.controller.ScreenChunkProcessor;
import com.aem.sdesktop.server.controller.VNCScreenUtil;
import com.aem.sdesktop.util.BoundingBox;
import com.aem.sdesktop.util.HumanInputTracker;
import com.aem.sdesktop.util.MouseMover;
import com.aem.shelp.util.MousePositionUtil;
import com.aem.shelp.util.ScreenDimension;
import com.aem.utils.FilteringUtil;
import com.aem.utils.IntArrayScreenUtil;
import com.aem.utils.LogicalArray;
import com.aem.utils.NativeFilteringUtil;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import com.aem.utils.NonNativeFilteringUtil;
import com.aem.utils.NonNativeLogicalArray;
import com.aem.utils.ScreenUtil;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import utils.ostools.OS;
import utils.progtools.Ticker;
import utils.progtools.XorShiftRandom;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;
import utils.vnc.VNC;

public class ScreenChunkGrabber
implements GC {
    MultiScreenMapper mscreens;
    NativeUtils nutils;
    HumanInputTracker inputTracker = null;
    FilteringUtil filter;
    NativeScreenUtil ngrab;
    private final Object LOCK = new Object();
    private Object NATIVE_LOCK = new Object();
    int myNativeInstance;
    boolean onVistaOrAbove = false;
    boolean onAnyWindows = false;
    boolean allowWindowsContextualNonNativeGrabs = false;
    private boolean currentStateAmDoingMMoveGrabs = false;
    Ticker simulationTicker;
    VNCScreenUtil vncUtil;
    static final Object VNC_LOCK = new Object();
    boolean lastGrabSpecValid = false;
    long lastGrabSpec = 0L;
    HashMap sentAsLowQuality = new HashMap();
    boolean die = false;
    int LINE = 0;
    XorShiftRandom random = new XorShiftRandom();
    int[] winNativeImageDat;
    long lastInfoPrintout = 0L;
    private static final int X_SCOPE = 64;
    private static final int Y_SCOPE = 32;
    private long grabberTime = 0L;
    private long grabTimeTotal = 0L;
    private int grabberCount = 0;
    private static final int GRABBER_COUNT_LIMIT = 10;
    private StringBuffer grabTimes = new StringBuffer();

    public ScreenChunkGrabber(HumanInputTracker inputTracker) throws AWTException {
        this.inputTracker = inputTracker;
        this.mscreens = new MultiScreenMapper();
        this.nutils = NativeUtils.getInstance();
        if (this.nutils == null) {
            System.out.println("[ScreenChunkGrabber] NativeUtils not loaded");
        }
        this.myNativeInstance = NativeFilteringUtil.WARNING_NEW_NATIVE_ARRAY();
        System.out.println("[ScreenChunkGrabber] Allocated new native array ID for filtering - " + this.myNativeInstance);
        this.initModes();
    }

    public void setSimulationTicker(Ticker sim) {
        this.simulationTicker = sim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCaptureViaVNC(VNC vncConnection) throws Exception {
        Object object = VNC_LOCK;
        synchronized (object) {
            try {
                this.vncUtil = vncConnection != null ? new VNCScreenUtil(vncConnection) : null;
            }
            catch (Exception e) {
                this.vncUtil = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCaptureViaVNC() {
        Object object = VNC_LOCK;
        synchronized (object) {
            this.vncUtil = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModes() {
        Object object = this.LOCK;
        synchronized (object) {
            this.filter = NativeFilteringUtil.getInstance(this.myNativeInstance);
            if (this.filter != null && !this.filter.workingOK()) {
                this.filter = null;
            }
            if (this.filter == null || CentralDebugging.SCR_FORCE_NON_NATIVE_FILTERING) {
                this.filter = new NonNativeFilteringUtil();
                System.out.println("[ScreenChunkGrabber] Using non-native filtering");
            } else {
                System.out.println("[ScreenChunkGrabber] Using native filtering");
            }
            this.ngrab = NativeScreenUtil.getInstance();
            if (this.ngrab != null && !this.ngrab.workingOK()) {
                this.ngrab = null;
            }
            if (this.ngrab == null) {
                System.out.println("[ScreenChunkGrabber] Using non-jni screen grabbing");
            } else {
                System.out.println("[ScreenChunkGrabber] Using jni screen grabbing");
                System.out.println("[ScreenChunkGrabber] Checking OS for contextual grabs");
                if (OS.isWindows()) {
                    this.onAnyWindows = true;
                }
                if (OS.isWindowsVistaOrAbove()) {
                    System.out.println("[ScreenChunkGrabber] Contextual grabs necessary, checking pointer access");
                    boolean count = false;
                    Point pp = this.getPointer();
                    if (pp == null) {
                        System.out.println("[ScreenChunkGrabber] Unable to do windows contextual non-native grabs because unable to fetch pointer");
                    } else {
                        System.out.println("[ScreenChunkGrabber] Turning on windows contextual grabs");
                        this.onVistaOrAbove = true;
                        this.allowWindowsContextualNonNativeGrabs = true;
                    }
                } else {
                    System.out.println("[ScreenChunkGrabber] Contextual grabs not necessary");
                }
            }
        }
    }

    public Point getPointer() {
        if (this.nutils != null) {
            return new Point(this.nutils.getPointerX(), this.nutils.getPointerY());
        }
        if (MousePositionUtil.get().isAvailable()) {
            return MousePositionUtil.get().getLocation();
        }
        return null;
    }

    public Point getCaret() {
        if (this.nutils != null) {
            return new Point(this.nutils.getCaretX(), this.nutils.getCaretY());
        }
        return null;
    }

    public void clearScreen() {
        this.filter.clearScreen();
    }

    public void cleanUpForShutdown() {
        this.mscreens.cleanUpForShutdown();
        this.filter.clearScreen();
        this.filter.releaseMemory();
    }

    public Dimension getPhysicalScreenSize() {
        Dimension screen_size;
        if (this.vncUtil != null) {
            return new Dimension(this.vncUtil.getSourceWidth(), this.vncUtil.getSourceHeight());
        }
        if (this.ngrab != null) {
            screen_size = this.ngrab.getPhysicalScreenSize();
            if (screen_size.width >= 0 && screen_size.height >= 0) {
                return screen_size;
            }
        }
        if (this.mscreens != null) {
            screen_size = this.mscreens.getScreenSize();
            if (screen_size.width >= 0 && screen_size.height >= 0) {
                return screen_size;
            }
        }
        screen_size = ScreenDimension.getPhysicalScreenSize();
        if (screen_size.width >= 0 && screen_size.height >= 0) {
            return screen_size;
        }
        System.out.println("[ScreenChunkGrabber] WARNING: Operating system is reporting a screen size of " + screen_size.width + " x " + screen_size.height);
        return new Dimension(0, 0);
    }

    public int[] getValidCoord() {
        if (this.mscreens != null) {
            return this.mscreens.getValidCoord();
        }
        return new int[]{0, 0};
    }

    public boolean isCoordValid(int x, int y) {
        if (this.mscreens != null) {
            return this.mscreens.isCoordValid(x, y);
        }
        return true;
    }

    public int translateReverseX(int x) {
        if (this.mscreens != null) {
            return this.mscreens.translateReverseX(x);
        }
        return x;
    }

    public int translateReverseY(int y) {
        if (this.mscreens != null) {
            return this.mscreens.translateReverseY(y);
        }
        return y;
    }

    public int translateX(int x) {
        if (this.mscreens != null) {
            return this.mscreens.translateX(x);
        }
        return x;
    }

    public int translateY(int y) {
        if (this.mscreens != null) {
            return this.mscreens.translateY(y);
        }
        return y;
    }

    private boolean isBlank(int[] data) {
        int len = data.length;
        if (len == 0) {
            return true;
        }
        int same = data[0];
        boolean blankScreen = true;
        for (int si = 0; si < len; ++si) {
            if (data[si] == same) continue;
            blankScreen = false;
            break;
        }
        return blankScreen;
    }

    private boolean contextMatch(int[] pixels, Rectangle r, ScreenUtil util, Rectangle grabRect) throws IOException {
        NonNativeLogicalArray natpixels = util.fetchArray(r.x - grabRect.x, r.y - grabRect.y, r.width, r.height);
        for (int k = 0; k < natpixels.getHeight(); ++k) {
            int OFF = k * r.width;
            for (int i = 0; i < natpixels.getWidth(); ++i) {
                try {
                    if ((0xFFFFFF & pixels[OFF + k]) == (0xFFFFFF & natpixels.getXY(i, k))) continue;
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    System.err.println("[ScreenChunkGrabber] " + x + " (2)");
                }
            }
        }
        return true;
    }

    private GrabSpec getContextualGrabSpec(GrabSpec parent, Point p, ScreenUtil util, Rectangle grabRect) throws IOException {
        int[] pixels;
        Rectangle r;
        if (CentralDebugging.SCR_NO_VISTAPLUS_CONTEXTUAL_NONNATIVE_GRABS) {
            return null;
        }
        if (!this.lastGrabSpecValid) {
            long t = System.currentTimeMillis();
            if (t - this.lastGrabSpec >= 100L) {
                this.lastGrabSpec = t;
            } else {
                return null;
            }
        }
        boolean allBlank = true;
        boolean allMatch = true;
        int H = 50;
        Point expandFrom = null;
        for (int Xoff = -50; Xoff <= 50; Xoff += 50) {
            block3: for (int Yoff = -50; Yoff <= 0; Yoff += 50) {
                int[] pixels2;
                Rectangle r2 = new Rectangle(p.x + Xoff, p.y + Yoff, 1, H);
                if (!grabRect.contains(r2) || (pixels2 = this.mscreens.getRGBPixels(r2, false)).length == 0) continue;
                try {
                    if (allBlank && !this.isBlank(pixels2)) {
                        allBlank = false;
                    }
                    if (!allMatch) continue;
                    NonNativeLogicalArray natpixels = util.fetchArray(r2.x - grabRect.x, r2.y - grabRect.y, r2.width, r2.height);
                    for (int k = 0; k < natpixels.getHeight(); ++k) {
                        if ((0xFFFFFF & pixels2[k]) == (0xFFFFFF & natpixels.getXY(0, k))) continue;
                        expandFrom = new Point(r2.x, r2.y + k);
                        allMatch = false;
                        continue block3;
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException xx) {
                    System.err.println("[ScreenChunkGrabber] " + xx + " (3)");
                }
            }
        }
        if (allBlank || allMatch) {
            this.lastGrabSpecValid = false;
            return null;
        }
        int INC = 100;
        int SCANLEN = 20;
        BoundingBox box = new BoundingBox(new Rectangle(expandFrom.x - INC, expandFrom.y - INC, INC * 2, INC * 2));
        Point pp = new Point(expandFrom);
        pp.y -= INC;
        do {
            pp.y -= INC;
            box.addPoint(pp);
        } while (grabRect.contains(r = new Rectangle(pp.x, pp.y, 1, SCANLEN)) && ((pixels = this.mscreens.getRGBPixels(r, false)).length == 0 || !this.contextMatch(pixels, r, util, grabRect)));
        pp = new Point(expandFrom);
        pp.y += INC;
        do {
            pp.y += INC;
            box.addPoint(pp);
        } while (grabRect.contains(r = new Rectangle(pp.x, pp.y - SCANLEN, 1, SCANLEN)) && ((pixels = this.mscreens.getRGBPixels(r, false)).length == 0 || !this.contextMatch(pixels, r, util, grabRect)));
        pp = new Point(expandFrom);
        pp.x -= INC;
        do {
            pp.x -= INC;
            box.addPoint(pp);
        } while (grabRect.contains(r = new Rectangle(pp.x, pp.y, SCANLEN, 1)) && ((pixels = this.mscreens.getRGBPixels(r, false)).length == 0 || !this.contextMatch(pixels, r, util, grabRect)));
        pp = new Point(expandFrom);
        pp.x += INC;
        do {
            pp.x += INC;
            box.addPoint(pp);
        } while (grabRect.contains(r = new Rectangle(pp.x - SCANLEN, pp.y, SCANLEN, 1)) && ((pixels = this.mscreens.getRGBPixels(r, false)).length == 0 || !this.contextMatch(pixels, r, util, grabRect)));
        Rectangle grab = box.getRect().intersection(grabRect);
        this.lastGrabSpecValid = true;
        return new GrabSpec(grab.x, grab.y, grab.width, grab.height, parent.enc, parent.fil, parent.comp, parent.coldepth, 0L, p, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChanges(GrabSpec spec, ScreenChunkProcessor proc) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.processChanges_synced(spec, proc, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChanges_synced(GrabSpec spec, ScreenChunkProcessor proc, boolean isWindowsContextualGrab) throws IOException {
        CentralDebugging.timerStart("ScreenChunkGrabber.processChanges");
        int grab_x = spec.x;
        int grab_y = spec.y;
        int grab_w = spec.w;
        int grab_h = spec.h;
        int fil = spec.fil;
        this.LINE = 1 - this.LINE;
        Dimension screen_size = this.getPhysicalScreenSize();
        int scr_w = screen_size.width;
        int scr_h = screen_size.height;
        if (CentralDebugging.MSG_VERBOSE) {
            System.out.println("Snapping, original = (" + grab_x + "," + grab_y + "," + grab_w + "," + grab_h + ")");
        }
        grab_x = Math.max(0, grab_x);
        grab_x = Math.min(screen_size.width, grab_x);
        grab_y = Math.max(0, grab_y);
        grab_y = Math.min(screen_size.height, grab_y);
        grab_w = Math.max(1, grab_w);
        grab_w = Math.min(screen_size.width - grab_x, grab_w);
        grab_h = Math.max(1, grab_h);
        grab_h = Math.min(screen_size.height - grab_y, grab_h);
        if (CentralDebugging.MSG_VERBOSE) {
            System.out.println("Snapping, new = (" + grab_x + "," + grab_y + "," + grab_w + "," + grab_h + ")");
        }
        ScreenUtil screenUtil = null;
        if (CentralDebugging.MSG_VERBOSE) {
            System.out.println("[ScreenChunkGrabber] Trying to get screen grab (" + grab_x + "," + grab_y + ",w" + grab_w + ",h" + grab_h + ") (" + grab_x + "," + grab_y + "," + (grab_x + grab_w) + "," + (grab_y + grab_h) + ") ");
        }
        CentralDebugging.timerStart("Preparation");
        if (!isWindowsContextualGrab) {
            proc.beginProcessingPixels(spec);
        }
        CentralDebugging.timerStop("Preparation");
        GrabSpec contextualGrabSpec = null;
        Rectangle contextualGrabRect = null;
        CentralDebugging.timerStart("Capture");
        if (LocalSwitches.DEV_acculogPipeline) {
            Acculog.log("[ScreenChunkGrabber] Capturing");
        }
        Object object = this.NATIVE_LOCK;
        synchronized (object) {
            try {
                boolean useJNI;
                IntArrayScreenUtil intScreenUtil;
                if (System.currentTimeMillis() - this.lastInfoPrintout > 300000000L) {
                    this.lastInfoPrintout = System.currentTimeMillis();
                    System.out.println("[ScreenChunkGrabber] (current grab) Capable of doing native grabs (graphics devices)");
                    if (spec.useHardwareAcceleratedScreenGrabs) {
                        System.out.println("[ScreenChunkGrabber] (current grab) Doing hardware accelerated grabs");
                    } else {
                        System.out.println("[ScreenChunkGrabber] (current grab) Doing non-native grabs");
                    }
                }
                boolean vncWorked = false;
                Object object2 = VNC_LOCK;
                synchronized (object2) {
                    if (this.vncUtil != null) {
                        CentralDebugging.timerStart("Screen Grab via VNC");
                        this.vncUtil.setGrabRectangle(grab_x, grab_y, grab_w, grab_h);
                        intScreenUtil = new IntArrayScreenUtil(grab_x, grab_y, grab_w, grab_h, this.vncUtil.getSourceWidth(), this.vncUtil.getImageInts());
                        screenUtil = intScreenUtil;
                        vncWorked = true;
                        CentralDebugging.timerStop("Screen Grab via VNC");
                    }
                }
                boolean bl = useJNI = !CentralDebugging.SCR_FORCE_NON_JNI_GRAB && this.ngrab != null && spec.useHardwareAcceleratedScreenGrabs;
                if (this.ngrab != null && this.simulationTicker != null) {
                    useJNI = true;
                }
                if (this.ngrab != null && OS.isWindows()) {
                    if (!useJNI) {
                        useJNI = true;
                    }
                    this.ngrab.useCaptureBLTGrabs(!spec.useHardwareAcceleratedScreenGrabs);
                }
                if (!vncWorked) {
                    if (useJNI) {
                        CentralDebugging.timerStart("Screen Grab via JNI");
                        screenUtil = this.ngrab;
                        this.grabberTimerStart();
                        proc.immediatelyBeforeGrab();
                        boolean didGrabWork = this.simulationTicker != null ? true : screenUtil.updateGrabArea(grab_x, grab_y, grab_w, grab_h);
                        if (didGrabWork && this.currentStateAmDoingMMoveGrabs) {
                            this.currentStateAmDoingMMoveGrabs = false;
                            System.out.println("[ScreenChunkGrabber] Grab switch - doing jni grabs again");
                        }
                        if (OS.isWindows8OrAbove() && !didGrabWork && MouseMover.getStaticMouseMover() != null) {
                            if (!this.currentStateAmDoingMMoveGrabs) {
                                this.currentStateAmDoingMMoveGrabs = true;
                                System.out.println("[ScreenChunkGrabber] Grab switch - doing mmove grabs now");
                            }
                            screenUtil = MouseMover.getStaticMouseMover();
                            screenUtil.updateGrabArea(grab_x, grab_y, grab_w, grab_h);
                        }
                        if (this.allowWindowsContextualNonNativeGrabs && !isWindowsContextualGrab && System.currentTimeMillis() - this.inputTracker.mostRecentAffectiveInput() > 750L && (contextualGrabSpec = this.getContextualGrabSpec(spec, this.getPointer(), screenUtil, new Rectangle(grab_x, grab_y, grab_w, grab_h))) != null) {
                            contextualGrabRect = contextualGrabSpec.getGrabRect();
                        }
                        this.grabberTimerStop(proc);
                        CentralDebugging.timerStop("Screen Grab via JNI");
                    } else {
                        boolean blankScreen;
                        CentralDebugging.timerStart("Screen Grab via MScreens");
                        this.grabberTimerStart();
                        proc.immediatelyBeforeGrab();
                        intScreenUtil = new IntArrayScreenUtil(grab_w, grab_h, this.mscreens.getRGBPixels(new Rectangle(grab_x, grab_y, grab_w, grab_h), false));
                        screenUtil = intScreenUtil;
                        if (!CentralDebugging.SCR_NO_CHECK_FOR_BLACK_SCREEN && (blankScreen = intScreenUtil.isBlank())) {
                            if (CentralDebugging.SCR_GRAB_DUMP_VERBOSE) {
                                System.out.println("Host returned blank screen, trying non-native grab");
                            }
                            this.mscreens.temporarilyFreeMemoryAtFutureCost();
                            CentralDebugging.timerStart("MultiScreenMapper screen grab (get RGB pixels)");
                            screenUtil = new IntArrayScreenUtil(grab_w, grab_h, this.mscreens.getRGBPixels(new Rectangle(grab_x, grab_y, grab_w, grab_h), true));
                            CentralDebugging.timerStop("MultiScreenMapper screen grab (get RGB pixels)");
                            blankScreen = intScreenUtil.isBlank();
                        }
                        this.grabberTimerStop(proc);
                        CentralDebugging.timerStop("Screen Grab via MScreens");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                screenUtil = null;
            }
            CentralDebugging.timerStop("Capture");
            if (CentralDebugging.SCR_RECORD_SCREEN) {
                // empty if block
            }
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("[ScreenChunkGrabber] Got screen grab");
            }
            CentralDebugging.timerStart("Filtering & Send");
            if (LocalSwitches.DEV_acculogPipeline) {
                Acculog.log("[ScreenChunkGrabber] Filtering and processing chunks");
            }
            if (screenUtil == null) {
                if (CentralDebugging.MSG_VERBOSE) {
                    System.out.println("[ScreenChunkGrabber] screenUtil was null");
                }
            } else {
                CentralDebugging.timerStart("Chunks Begin");
                this.filter.chunksBegin(scr_w, scr_h, grab_x, grab_y, grab_w, grab_h);
                CentralDebugging.timerStop("Chunks Begin");
                CentralDebugging.timerStart("Translation Processing");
                boolean foundTranslation = false;
                if (!isWindowsContextualGrab && CentralDebugging.DRAGS_AS_TRANSLATIONS && CentralDebugging.SCR_FORCE_NON_NATIVE_FILTERING) {
                    NonNativeFilteringUtil nnf = (NonNativeFilteringUtil)this.filter;
                    foundTranslation = proc.processEntireScreen(nnf.getEntireScreen(), screenUtil, new Rectangle(grab_x, grab_y, grab_w, grab_h), screen_size);
                }
                CentralDebugging.timerStop("Translation Processing");
                boolean new_image = this.filter.mustSendAllChunks();
                CentralDebugging.counterStart("Screen Filtering Chunks Total");
                CentralDebugging.counterStart("Screen Filtering Chunks Changed");
                if (fil == 51 || fil == 52 || fil == 53) {
                    int chunk_siz = 64;
                    if (fil == 52) {
                        chunk_siz = 32;
                    } else if (fil == 53) {
                        chunk_siz = 128;
                    }
                    if (CentralDebugging.SCR_FORCE_LARGE_CHUNKS) {
                        chunk_siz = 256;
                    }
                    int chunk_siz_half = chunk_siz / 2;
                    int chunk_cols = grab_w / chunk_siz;
                    int chunk_rows = grab_h / chunk_siz;
                    for (int cy = 0; cy < chunk_rows + 1; ++cy) {
                        for (int cx = 0; cx < chunk_cols + 1; ++cx) {
                            if (this.die) {
                                return;
                            }
                            CentralDebugging.timerStart("Screen Filtering");
                            int chunk_x = cx * chunk_siz;
                            int chunk_y = cy * chunk_siz;
                            boolean send_chunk = false;
                            NonNativeLogicalArray newChunkDataLogicalArray = screenUtil.fetchArray(chunk_x, chunk_y, Math.min(chunk_siz, grab_w - chunk_x), Math.min(chunk_siz, grab_h - chunk_y));
                            LogicalArray existingChunkDataLogicalArray = this.filter.getLogicalArrayForChunk(chunk_x, chunk_y, newChunkDataLogicalArray.getWidth(), newChunkDataLogicalArray.getHeight());
                            if (new_image) {
                                send_chunk = true;
                            } else {
                                for (int dy = this.LINE; dy < newChunkDataLogicalArray.getHeight(); dy += 2) {
                                    int dx = 0;
                                    int random_space = 16;
                                    try {
                                        for (dx = 0; dx < newChunkDataLogicalArray.getWidth(); dx += random_space) {
                                            int xoff = dx + this.random.nextInt(Math.min(random_space, newChunkDataLogicalArray.getWidth() - dx));
                                            if (newChunkDataLogicalArray.getXY(xoff, dy) == existingChunkDataLogicalArray.getXY(xoff, dy)) continue;
                                            send_chunk = true;
                                            dx = newChunkDataLogicalArray.getWidth();
                                            dy = newChunkDataLogicalArray.getHeight();
                                        }
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException xx) {
                                        System.err.println("[ScreenChunkGrabber] " + xx + " (1) (y=" + dy + ",x=" + dx + "+<=16)");
                                    }
                                }
                            }
                            CentralDebugging.timerStop("Screen Filtering");
                            CentralDebugging.counterAdd("Screen Filtering Chunks Total", 1.0);
                            boolean mustSendHqUpdate = false;
                            String TODO_chunkID = null;
                            if (CentralDebugging.LOW_COLDEPTH_ON_DRAG) {
                                int chunkID = cy * 10000 + cx;
                                TODO_chunkID = Integer.toString(chunkID);
                                if (!spec.lowQuality && this.sentAsLowQuality.remove(TODO_chunkID) != null) {
                                    mustSendHqUpdate = true;
                                }
                            }
                            if (this.simulationTicker != null) {
                                int pixels = chunk_siz * chunk_siz;
                                send_chunk = this.simulationTicker.tryClaim(pixels);
                            }
                            if (!send_chunk && !mustSendHqUpdate && !CentralDebugging.SCR_FORCE_SEND_ALL_CHUNKS || CentralDebugging.SCR_FORCE_SEND_NO_CHUNKS) continue;
                            if (CentralDebugging.LOW_COLDEPTH_ON_DRAG && spec.lowQuality) {
                                this.sentAsLowQuality.put(TODO_chunkID, TODO_chunkID);
                            }
                            boolean immediateSend = false;
                            if (contextualGrabSpec == null && !isWindowsContextualGrab) {
                                int testx = grab_x + chunk_x + chunk_siz_half;
                                int testy = grab_y + chunk_y + chunk_siz_half;
                                Point pointerPoint = this.getPointer();
                                if (pointerPoint != null) {
                                    if (this.pointNear(pointerPoint, testx, testy)) {
                                        immediateSend = true;
                                    }
                                } else if (this.pointNear(spec.lastKnownMousePos, testx, testy)) {
                                    immediateSend = true;
                                }
                                if (this.pointNear(this.getCaret(), testx, testy)) {
                                    immediateSend = true;
                                }
                            }
                            boolean ignoreChunk = false;
                            if (contextualGrabSpec != null && this.intersects(contextualGrabRect.x, contextualGrabRect.y, contextualGrabRect.width, contextualGrabRect.height, grab_x + chunk_x, grab_y + chunk_y, chunk_siz, chunk_siz)) {
                                ignoreChunk = true;
                            }
                            if (ignoreChunk) continue;
                            CentralDebugging.counterAdd("Screen Filtering Chunks Changed", 1.0);
                            CentralDebugging.timerStart("Cumulative Pixel Processing");
                            proc.processPixels(spec, newChunkDataLogicalArray, existingChunkDataLogicalArray, grab_x + chunk_x, grab_y + chunk_y, immediateSend, mustSendHqUpdate);
                            CentralDebugging.timerStop("Cumulative Pixel Processing");
                            CentralDebugging.timerStart("Screen Filter Updating");
                            this.filter.setLogicalArrayForPreviousChunk(newChunkDataLogicalArray);
                            CentralDebugging.timerStop("Screen Filter Updating");
                        }
                    }
                } else {
                    System.out.println("Unrecognised requested filtering type " + fil);
                }
                CentralDebugging.counterFinish("Screen Filtering Chunks Total");
                CentralDebugging.counterFinish("Screen Filtering Chunks Changed");
                this.filter.chunksFinished();
            }
            CentralDebugging.timerStop("Filtering & Send");
        }
        if (!isWindowsContextualGrab && contextualGrabSpec != null && contextualGrabSpec != null) {
            this.processChanges_synced(contextualGrabSpec, proc, true);
        }
        CentralDebugging.timerStop("endProcessingPixels");
        if (!isWindowsContextualGrab) {
            proc.endProcessingPixels(spec);
        }
        CentralDebugging.timerStop("endProcessingPixels");
        CentralDebugging.timerStop("ScreenChunkGrabber.processChanges");
    }

    private boolean pointNear(Point p, int testx, int testy) {
        return p != null && Math.abs(testx - p.x) < 64 && Math.abs(testy - p.y) < 32;
    }

    private void grabberTimerStart() {
        if (this.grabberCount < 10) {
            this.grabberTime = System.currentTimeMillis();
        }
    }

    private void grabberTimerStop(ScreenChunkProcessor proc) {
        if (this.grabberCount < 10) {
            long diff = System.currentTimeMillis() - this.grabberTime;
            if (this.grabberCount > 0) {
                this.grabTimeTotal += diff;
            }
            this.grabTimes.append(diff).append("ms ");
            this.grabberTime = System.currentTimeMillis();
            ++this.grabberCount;
        } else if (this.grabberCount == 10) {
            long average = this.grabTimeTotal / (long)(this.grabberCount - 1);
            ++this.grabberCount;
            System.out.println("[ScreenChunkGrabber] Initial screen grab times: " + this.grabTimes.toString() + " (avg - 1: " + average + " ms)");
            if (OS.isWindows() && Switches.notifySlowScreenGrabs && average > 300L) {
                System.out.println("[ScreenChunkGrabber] The screen capture times are very slow. Notifying technician.");
                proc.notifySlowCapture();
            }
        }
    }

    public boolean intersects(int rx, int ry, int rw, int rh, int tx, int ty, int tw, int th) {
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    static class Tester
    implements Runnable {
        Tester() {
        }

        @Override
        public void run() {
            try {
                MultiScreenMapper mscreens = new MultiScreenMapper();
                mscreens.getScreenSize();
                mscreens.getScreenSize();
                mscreens.getScreenSize();
                mscreens.getRGBPixels(new Rectangle(0, 0, 1116, 759), false);
                mscreens.getScreenSize();
                mscreens.getRGBPixels(new Rectangle(0, 0, 1116, 759), false);
                mscreens.getScreenSize();
                mscreens.getRGBPixels(new Rectangle(0, 0, 1116, 759), false);
                mscreens.getScreenSize();
                mscreens.getRGBPixels(new Rectangle(0, 0, 1116, 759), false);
                for (int i = 0; i < 100; ++i) {
                    mscreens.getScreenSize();
                    mscreens.getRGBPixels(new Rectangle(1066, 0, 100, 759), false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

