/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.sdesktop.server.controller.AsyncServer;
import com.aem.utils.CursorInfo;
import com.aem.utils.NativeScreenUtil;
import utils.ostools.OS;

public class CursorMonitorThread
extends Thread {
    private AsyncServer aServer;
    private CursorInfo.CursorInfoCache cache = new CursorInfo.CursorInfoCache();
    boolean die = false;

    public CursorMonitorThread(AsyncServer server) {
        this.aServer = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        CursorMonitorThread cursorMonitorThread = this;
        synchronized (cursorMonitorThread) {
            this.die = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.die) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                CursorMonitorThread e = this;
                synchronized (e) {
                    boolean cursorChanged;
                    if (this.die || NativeScreenUtil.getInstance() == null) {
                        return;
                    }
                    if (this.aServer != null) {
                        this.aServer.sendCurrentCursorLocation();
                    }
                    if (cursorChanged = NativeScreenUtil.getInstance().cursorHasChanged()) {
                        CursorInfo cInfo = new CursorInfo();
                        NativeScreenUtil.getInstance().getCursorInfo(cInfo);
                        if (OS.isWindows8OrAbove() || cInfo.width > 1.0 && cInfo.height > 1.0) {
                            if (this.cache.getFromCache(cInfo.signature) != null) {
                                cInfo.data = null;
                                cInfo.dataLength = 0L;
                            } else {
                                this.cache.addToCache(cInfo);
                            }
                            if (this.aServer != null) {
                                this.aServer.setCurrentCursor(cInfo);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }
}

