/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.common;

import com.aem.sdesktop.ClientBranding;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import jwrapper.jwutils.JWSystem;
import utils.swing.images.ImageHelper;

public class CachedSplashLoader {
    public static BufferedImage getSplashFromCache(int maxW, int maxH) {
        BufferedImage icon = null;
        try {
            ClientBranding.loadBrandingFromCacheDir(null);
            icon = ClientBranding.get().getSplashImage();
        }
        catch (Throwable t) {
            System.out.println("[CachedSplashLoader] Unable to load branding icon.");
            t.printStackTrace();
        }
        try {
            if (icon == null) {
                icon = ImageIO.read(new ByteArrayInputStream(JWSystem.getAppBundleSplashPNG()));
            }
        }
        catch (Exception x) {
            System.out.println("[CachedSplashLoader] Unable to load logo " + x);
            x.printStackTrace();
        }
        if (maxW != -1 && maxH != -1 && icon != null) {
            icon = ImageHelper.scaleDownToFitInside((BufferedImage)ImageHelper.toBufferedImageARGB((Image)icon), (int)maxW, (int)maxH);
        }
        return icon;
    }
}

