/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools.ui;

import com.aem.sdesktop.client.gui.tools.AudioTool;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.util.font.GlyphIconsLabel;
import com.aem.utils.sound.SoundUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.sound.sampled.Mixer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.components.JSmartPopupMenu;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AudioToolButton
extends AbstractToolButton
implements ActionListener {
    private GbPanel buttonRoot = new GbPanel();
    private JLabel text = new JLabel();
    private JLabel iconLabel = new JLabel();
    private boolean isOn = false;
    private JButton testButton;
    private ChangeListener listener;
    public boolean isEnabled = true;
    private GbPanel buttonContent;

    public AudioToolButton(Tool tool, ChangeListener listener) {
        super(tool);
        this.listener = listener;
        this.initButtonUI();
    }

    private void initButtonUI() {
        this.buttonRoot.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.text.setText(this.tool.title);
        this.text.setPreferredSize(new Dimension(-1, SimpleHelpLookAndFeel.scale((int)24)));
        GlyphIconsLabel pickOutputLabel = new GlyphIconsLabel(SimpleHelpLookAndFeel.scale((float)16.0f));
        pickOutputLabel.setText("\ue184");
        pickOutputLabel.setForeground(new Color(118, 118, 118));
        pickOutputLabel.setToolTipText(Language.get("TOOLS_AUDIO_PICK_OUTPUT"));
        pickOutputLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AudioToolButton.this.pickLineInput((Component)e.getSource());
            }
        });
        JPanel controlsPanel = new JPanel(new GridLayout(1, 2));
        controlsPanel.setOpaque(false);
        controlsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)6));
        controlsPanel.add(pickOutputLabel);
        JLabel leftIcon = new JLabel(this.tool.icon);
        leftIcon.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)3, (int)0, (int)8));
        this.buttonContent = new GbPanel();
        int X = 0;
        this.buttonContent.add((Component)leftIcon, X++, 0, 1, 1, 0, 0, 17, 3);
        this.buttonContent.add((Component)this.text, X++, 0, 1, 1, 1, 1, 17, 1);
        this.buttonContent.add((Component)controlsPanel, X++, 0, 1, 1, 0, 1, 10, 0);
        this.buttonContent.add((Component)this.iconLabel, X++, 0, 1, 1, 0, 0, 10, 3);
        this.buttonContent.setOpaque(false);
        this.buttonRoot.add((Component)this.buttonContent, 0, 0, 1, 1, 100, 0, 10, 1);
        this.buttonContent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AudioToolButton.this.buttonPressed();
            }
        });
        this.setPaused();
    }

    private void pickLineInput(Component source) {
        Mixer[] mixers = SoundUtils.getMixersWithSourceDataLine();
        String currentOption = TechProperties.INSTANCE.getProp("mxr");
        JSmartPopupMenu menu = new JSmartPopupMenu();
        AbstractButton first = null;
        boolean set = false;
        for (final Mixer mixer : mixers) {
            String mixerName = mixer.getMixerInfo().getName();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(mixerName);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioToolButton.this.setSourceDataLineMixer(mixer);
                }
            });
            if (first == null) {
                first = item;
            }
            if (currentOption != null && currentOption.equals(mixerName)) {
                set = true;
                item.setSelected(true);
            }
            menu.add(item);
        }
        if (!set && first != null) {
            first.setSelected(true);
        }
        menu.show(source, 0, 0);
    }

    private void setSourceDataLineMixer(Mixer mixer) {
        TechProperties.INSTANCE.setPropAndSaveIn("mxr", mixer.getMixerInfo().getName(), 3000);
        ((AudioTool)this.tool).setSourceDataLineMixer(mixer);
    }

    @Override
    public JComponent getRootComponent() {
        return this.buttonRoot;
    }

    public void setRecording() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioToolButton.this.iconLabel.setVisible(true);
                AudioToolButton.this.text.setEnabled(true);
                AudioToolButton.this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/switch-on.svg,24"));
                AudioToolButton.this.iconLabel.repaint();
            }
        });
        this.isOn = true;
    }

    public void setPaused() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioToolButton.this.iconLabel.setVisible(true);
                AudioToolButton.this.text.setEnabled(true);
                AudioToolButton.this.iconLabel.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/switch-on.svg,24"));
                AudioToolButton.this.iconLabel.repaint();
            }
        });
        this.isOn = false;
    }

    public void setBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioToolButton.this.iconLabel.setVisible(false);
                AudioToolButton.this.text.setEnabled(false);
                AudioToolButton.this.buttonRoot.invalidate();
            }
        });
    }

    public void setFinished(final boolean on) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (on) {
                    AudioToolButton.this.setRecording();
                } else {
                    AudioToolButton.this.setPaused();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.buttonPressed();
    }

    private void buttonPressed() {
        if (!this.isEnabled) {
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                AudioToolButton.this.setBusy();
                if (AudioToolButton.this.isOn) {
                    if (AudioToolButton.this.tool.toolActioned()) {
                        AudioToolButton.this.setPaused();
                        if (AudioToolButton.this.listener != null) {
                            AudioToolButton.this.listener.stateChanged(new ChangeEvent(AudioToolButton.this));
                        }
                    } else {
                        AudioToolButton.this.setRecording();
                    }
                } else if (AudioToolButton.this.tool.toolActioned()) {
                    AudioToolButton.this.setRecording();
                    if (AudioToolButton.this.listener != null) {
                        AudioToolButton.this.listener.stateChanged(new ChangeEvent(AudioToolButton.this));
                    }
                } else {
                    AudioToolButton.this.setPaused();
                }
            }
        };
        runner.start();
    }

    @Override
    public void setEnabled(boolean b) {
        this.isEnabled = b;
        if (this.isEnabled) {
            this.buttonContent.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.buttonContent.setCursor(null);
        }
        if (this.testButton != null) {
            this.testButton.setEnabled(b);
        }
        this.text.setEnabled(b);
        this.iconLabel.setEnabled(b);
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.getRootComponent().setVisible(isVisible);
    }
}

