/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools;

import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class BlankMonitorGlassDialog
extends ScaledGlassDialog
implements ActionListener,
KeyListener {
    private JTextField titleField = new JTextField();
    private JTextArea messageArea = new JTextArea();
    private JPanel main = new JPanel();
    private GbPanel panel = new GbPanel();
    private JButton bok;
    private JButton bcancel;
    private String returnTitle;
    private String returnMessage;

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(550, 330);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        new BlankMonitorGlassDialog((RootPaneContainer)frame, Language.get("BLANK_DISPLAY_DEFAULT_TITLE"), Language.get("BLANK_DISPLAY_DEFAULT_MESSAGE"));
    }

    public BlankMonitorGlassDialog(RootPaneContainer frame, String defaultTitle, String defaultMessage) {
        super(frame, 550, 230, true, true, false);
        this.setModal(true);
        this.initUI(defaultTitle, defaultMessage);
        this.initFocus();
        this.setVisible(true);
    }

    private void initFocus() {
        this.setFocusComponent(this.bok);
    }

    private void initUI(String title, String message) {
        this.bok = new JButton(Language.get("BLANK_SCREEN_OK"), ImageLoader.getImageIcon((String)"images/svg/arrows/right-moving.svg,16"));
        SHButtonUI.makeButtonBlue((JButton)this.bok);
        this.bcancel = new JButton(Language.get("CANCEL"), ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"));
        JLabel titleLabel = new JLabel(Language.get("TITLE"));
        JLabel messageLabel = new JLabel(Language.get("MESSAGE"));
        JLabel descLabel = new JLabel("<html>" + Language.get("BLANK_DISPLAY_DIALOG_DESC"));
        this.messageArea.setText(message);
        this.titleField.setText(title);
        GbPanel buttonsPanel = new GbPanel();
        JPanel buttonWrapperPanel = new JPanel(new GridLayout(1, 2, SimpleHelpLookAndFeel.scale((int)20), SimpleHelpLookAndFeel.scale((int)20)));
        buttonWrapperPanel.add(this.bcancel);
        buttonWrapperPanel.add(this.bok);
        buttonsPanel.add((Component)buttonWrapperPanel, 0, 0, 1, 1, 100, 1, 13, 0, (Insets)new ScaledInsets(7, 7, 7, 7));
        this.bok.addActionListener(this);
        this.bcancel.addActionListener(this);
        JScrollPane pane = new JScrollPane(this.messageArea);
        pane.setHorizontalScrollBarPolicy(31);
        this.messageArea.setFont(this.titleField.getFont());
        this.panel.add((Component)titleLabel, 0, 0, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.panel.add((Component)messageLabel, 0, 1, 1, 1, 0, 0, 12, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.panel.add((Component)this.titleField, 1, 0, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.panel.add((Component)pane, 1, 1, 1, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(3, 3, 3, 3));
        RoundBorderPanel borderPanel = new RoundBorderPanel();
        borderPanel.setLayout(new GridLayout(1, 1));
        borderPanel.add((Component)this.panel);
        this.panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.getContentPane().add(this.main);
        this.main.setLayout(new BorderLayout());
        this.main.add((Component)descLabel, "North");
        this.main.add((Component)borderPanel, "Center");
        this.main.add((Component)buttonsPanel, "South");
        descLabel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        this.setTitle(Language.get("BLANK_SCREEN_DIALOG_TITLE"));
    }

    public String getReturnTitle() {
        return this.returnTitle;
    }

    public String getReturnMessage() {
        return this.returnMessage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    public void actionPerformed(Object o) {
        if (o == this.bok) {
            this.returnMessage = this.messageArea.getText();
            this.returnTitle = this.titleField.getText();
        } else if (o == this.bcancel) {
            this.returnMessage = null;
            this.returnTitle = null;
        }
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionPerformed(this.bok);
        } else if (e.getKeyCode() == 27) {
            this.actionPerformed(this.bcancel);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

