/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.ftp;

import com.aem.sdesktop.client.gui.ftp.BlockTransfer;
import com.aem.sdesktop.client.gui.ftp.FileTransferJob;
import java.util.LinkedList;

public class JobStatus {
    public static final int WAITING = 0;
    public static final int TRANSFERRING = 1;
    public static final int DONE = 2;
    public static final int STOPPED = 3;
    public static final int MIRRORING = 4;
    public LinkedList<BlockTransfer> btransfers = new LinkedList();
    public LinkedList<ErrorMessage> failures = new LinkedList();
    public int files;
    public String previousFile;
    public long transferredBytes;
    public long totalBytes = -1L;
    public int status = 0;

    public long getBytesLeftToGo() {
        if (this.totalBytes == -1L) {
            return -1L;
        }
        return this.totalBytes - this.transferredBytes;
    }

    public long getEstimatedTimeRemaining() {
        double bytesPerSecond = this.getBytesPerSecond();
        long total = this.getBytesLeftToGo();
        if (bytesPerSecond == 0.0 || total == -1L) {
            return -1L;
        }
        if (total == 0L) {
            return 0L;
        }
        return Math.max((long)((double)(1000L * total) / bytesPerSecond), 1000L);
    }

    public double getKBsec() {
        return this.getBytesPerSecond() / 1024.0;
    }

    public double getBytesPerSecond() {
        double bytes = 0.0;
        double ms = 0.0;
        for (BlockTransfer bt : this.btransfers) {
            if (bt.msTaken == 99999999L) continue;
            bytes += (double)bt.bytesTransferred;
            ms += (double)bt.msTaken;
        }
        if (bytes == 0.0 || ms == 0.0) {
            return 0.0;
        }
        return bytes / (ms / 1000.0);
    }

    public ErrorMessage addFailure(FileTransferJob parent, String message) {
        ErrorMessage eMessage = new ErrorMessage(parent, message);
        this.failures.add(eMessage);
        return eMessage;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public boolean isDone() {
        return this.status == 2;
    }

    public class ErrorMessage {
        private FileTransferJob parent;
        private String message;

        public ErrorMessage(FileTransferJob parent, String message) {
            this.message = message;
            this.parent = parent;
        }

        public FileTransferJob getFileTransferJob() {
            return this.parent;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

