/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.ftp;

import com.aem.sdesktop.client.gui.ftp.JobStatus;
import java.io.File;
import utils.files.FileUtil;

public class FileTransferJob {
    private static int JOB_TYPE_MIRROR = 0;
    private static int JOB_TYPE_GET = 1;
    private static int JOB_TYPE_PUT = 2;
    private int ID;
    private JobStatus jobStatus;
    private int jobType;
    private String ldir;
    private String rdir;
    private String fileOrDirectoryName;

    private FileTransferJob(int ID, String ldir, String rdir, String fileOrDirectoryName) {
        this.ID = ID;
        this.ldir = ldir;
        this.rdir = rdir;
        this.fileOrDirectoryName = fileOrDirectoryName;
        this.jobStatus = new JobStatus();
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public int getID() {
        return this.ID;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public String getLdir() {
        return this.ldir;
    }

    public String getRdir() {
        return this.rdir;
    }

    public String getFileOrDirectoryName() {
        return this.fileOrDirectoryName;
    }

    public boolean isPutJob() {
        return this.jobType == JOB_TYPE_PUT;
    }

    public boolean isGetJob() {
        return this.jobType == JOB_TYPE_GET;
    }

    public boolean isMirrorJob() {
        return this.jobType == JOB_TYPE_MIRROR;
    }

    public static FileTransferJob newPutJob(int ID, String ldir, String rdir, String fileOrDirectoryName) {
        FileTransferJob fileTransferJob = new FileTransferJob(ID, ldir, rdir, fileOrDirectoryName);
        fileTransferJob.jobType = JOB_TYPE_PUT;
        return fileTransferJob;
    }

    public static FileTransferJob newGetJob(int ID, String ldir, String rdir, String fileOrDirectoryName) {
        FileTransferJob fileTransferJob = new FileTransferJob(ID, ldir, rdir, fileOrDirectoryName);
        fileTransferJob.jobType = JOB_TYPE_GET;
        return fileTransferJob;
    }

    public static FileTransferJob newMirrorJob(int ID, String ldir, String rdir, String fileOrDirectoryName) {
        FileTransferJob fileTransferJob = new FileTransferJob(ID, ldir, rdir, fileOrDirectoryName);
        fileTransferJob.jobType = JOB_TYPE_MIRROR;
        return fileTransferJob;
    }

    public void computeSizeToSend() {
        if (this.isPutJob()) {
            File sourceFile = new File(this.getLdir(), this.getFileOrDirectoryName());
            System.out.println("[FileTransferJob] Checking size of " + sourceFile);
            this.jobStatus.totalBytes = FileUtil.recursiveSize((File)sourceFile);
            System.out.println("[FileTransferJob] Computed total size of put to be " + this.jobStatus.totalBytes);
        }
    }

    public boolean isTransferring() {
        return this.jobStatus.status == 1;
    }

    public boolean isDone() {
        return this.jobStatus.status == 2;
    }
}

