/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.util.WReg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import utils.message.Message;
import utils.swing.components.SHJTable;
import utils.swing.components.SHSplitPane;
import utils.swing.components.virtualtree.VirtualTree;
import utils.swing.components.virtualtree.VirtualTreeInterface;
import utils.swing.components.virtualtree.VirtualTreeNode;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;

public class RegistryTree
implements MSG {
    private SimpleList simpleList;
    private SortWrapper wrapper;
    private JPanel contentPanel;
    private VirtualTree registryTree;
    private JTable table;
    private TreeChoiceListener choiceListener = new TreeChoiceListener();
    private TableSelectionListener tableSelectionListener = new TableSelectionListener();
    private RegistryActionListener registryActionListener = new RegistryActionListener();
    private JButton createKey;
    private JButton createValue;
    private JButton deleteKey;
    private JButton deleteValue;
    private ClientController con;
    private AsyncResponseListener responseListener = new AsyncResponseListener();
    private boolean controlEnabled;

    public JPanel getRootComponent() {
        return this.contentPanel;
    }

    public RegistryTree(ClientController con2) {
        this.con = con2;
        this.initUI();
    }

    private RegistryKey getCurrentlySelectedKey() {
        TreePath path = this.registryTree.getRootComponent().getSelectionPath();
        if (path == null) {
            return null;
        }
        RegistryKey selectedKey = (RegistryKey)((VirtualTreeNode)path.getLastPathComponent()).getUserObject();
        return selectedKey;
    }

    private RegistryValue getCurrentlySelectedValue() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        RegistryValue value = (RegistryValue)this.wrapper.get(row);
        return value;
    }

    public void setControlEnabled(boolean controlEnabled) {
        this.controlEnabled = controlEnabled;
    }

    private RegistryKey getKeyFromName(String keyName) {
        VirtualTreeNode node = this.getNodeFromName(keyName);
        return (RegistryKey)node.getUserObject();
    }

    private VirtualTreeNode getNodeFromName(String keyName) {
        String[] keyNames = keyName.split("\\\\");
        VirtualTreeNode currentNode = (VirtualTreeNode)this.registryTree.getModel().getRoot();
        block0: for (int i = 0; i < keyNames.length; ++i) {
            String keyNameToFind = keyNames[i];
            for (int j = 0; j < currentNode.getChildCount(); ++j) {
                VirtualTreeNode childJ = (VirtualTreeNode)currentNode.getChildAt(j);
                RegistryKey childJKey = (RegistryKey)childJ.getUserObject();
                if (!childJKey.getLastKeyName().equals(keyNameToFind)) continue;
                currentNode = childJ;
                continue block0;
            }
        }
        return currentNode;
    }

    public void connected() {
        this.registryTree.connected();
    }

    private void initUI() {
        this.createKey = new JButton(ImageLoader.getImageIcon((String)Icons.REGISTRY_KEY_FOLDER_ADD));
        this.deleteKey = new JButton(ImageLoader.getImageIcon((String)Icons.REGISTRY_KEY_FOLDER_REMOVE));
        this.createValue = new JButton(ImageLoader.getImageIcon((String)Icons.REGISTRY_KEY_ADD));
        this.deleteValue = new JButton(ImageLoader.getImageIcon((String)Icons.REGISTRY_KEY_REMOVE));
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.createKey, this.deleteKey});
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.createValue, this.deleteValue});
        this.createKey.setEnabled(false);
        this.createValue.setEnabled(false);
        this.deleteKey.setEnabled(false);
        this.deleteValue.setEnabled(false);
        this.createKey.addActionListener(this.registryActionListener);
        this.createValue.addActionListener(this.registryActionListener);
        this.deleteKey.addActionListener(this.registryActionListener);
        this.deleteValue.addActionListener(this.registryActionListener);
        TableStructure ts = TableStructure.createTableStructure(RegistryValue.class, new String[]{"name", "value", "type"}, new String[]{"Name", "Value", "Type"});
        ts.setWidths(new int[]{100, 200, 0});
        this.simpleList = new SimpleList();
        this.wrapper = new SortWrapper(this.simpleList, SortWrapper.LEXICAL_COMPARATOR);
        SimpleTableModel slm = new SimpleTableModel(this.wrapper, ts);
        this.table = new SHJTable();
        this.table.setModel(slm);
        this.table.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        this.table.addMouseListener(new DoubleClickListener());
        ts.initTableDimensions(this.table);
        JScrollPane sp = new JScrollPane(this.table);
        VirtualTreeNode[] rootChildren = new VirtualTreeNode[]{new VirtualTreeNode(new RegistryKey("HKEY_CLASSES_ROOT")), new VirtualTreeNode(new RegistryKey("HKEY_CURRENT_CONFIG")), new VirtualTreeNode(new RegistryKey("HKEY_CURRENT_USER")), new VirtualTreeNode(new RegistryKey("HKEY_CURRENT_USER_LOCAL_SETTINGS")), new VirtualTreeNode(new RegistryKey("HKEY_LOCAL_MACHINE")), new VirtualTreeNode(new RegistryKey("HKEY_PERFORMANCE_DATA")), new VirtualTreeNode(new RegistryKey("HKEY_USERS"))};
        this.registryTree = new VirtualTree(new RegistryTreeInterface(), rootChildren);
        this.registryTree.getRootComponent().setRootVisible(false);
        this.registryTree.getRootComponent().setShowsRootHandles(true);
        this.registryTree.getRootComponent().setCellRenderer(new RegistryCellRenderer());
        this.registryTree.getRootComponent().getSelectionModel().addTreeSelectionListener(this.choiceListener);
        JScrollPane treeSp = new JScrollPane(this.registryTree.getRootComponent());
        JPanel leftButtonsPanel = new JPanel((LayoutManager)new ScaledFlowLayout(0, 0, SimpleHelpLookAndFeel.scale((int)5)));
        leftButtonsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)0));
        leftButtonsPanel.add(this.createKey);
        leftButtonsPanel.add(this.deleteKey);
        JPanel rightButtonsPanel = new JPanel((LayoutManager)new ScaledFlowLayout(0, 0, SimpleHelpLookAndFeel.scale((int)5)));
        rightButtonsPanel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)UIManager.getColor("controlShadow")), (Border)SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)0)));
        rightButtonsPanel.add(this.createValue);
        rightButtonsPanel.add(this.deleteValue);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)treeSp, "Center");
        leftPanel.add((Component)leftButtonsPanel, "North");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)sp, "Center");
        rightPanel.add((Component)rightButtonsPanel, "North");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.registryTree.getRootComponent().setBorder(SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)UIManager.getColor("controlShadow")));
        treeSp.setBorder(SHBorderFactory.createEmptyBorder());
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        SHSplitPane pane = new SHSplitPane(1);
        ((JSplitPane)pane).setDividerLocation(0.5);
        pane.setLeftComponent(leftPanel);
        pane.setRightComponent(rightPanel);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.contentPanel.add((Component)pane, "Center");
    }

    public void setEnabled(boolean enabled) {
        this.createKey.setEnabled(this.controlEnabled && enabled);
        this.createValue.setEnabled(this.controlEnabled && enabled);
        this.deleteKey.setEnabled(this.controlEnabled && enabled);
        this.deleteValue.setEnabled(this.controlEnabled && enabled);
        this.registryTree.getRootComponent().setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    class AsyncResponseListener
    implements CommandResponseListener {
        AsyncResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            if (m.getType() == -1061158844) {
                int index = 0;
                boolean success = m.getAsBoolean(index++);
                String keyName = m.getAsString(index++);
                String valueName = m.getAsString(index++);
                String valueValue = m.getAsString(index++);
                String valueType = m.getAsString(index++);
                if (success) {
                    RegistryKey registryKey = RegistryTree.this.getKeyFromName(keyName);
                    RegistryValue existingValue = registryKey.getValueByName(valueName);
                    RegistryValue newValue = new RegistryValue(valueName, valueValue, valueType);
                    registryKey.addOrOverwriteValue(newValue);
                    if (RegistryTree.this.getCurrentlySelectedKey() == registryKey) {
                        RegistryTree.this.simpleList.startBatch();
                        try {
                            if (existingValue != null) {
                                RegistryTree.this.simpleList.remove(existingValue);
                            }
                            RegistryTree.this.simpleList.add(newValue);
                        }
                        finally {
                            RegistryTree.this.simpleList.endBatch();
                        }
                    }
                }
            } else if (m.getType() == -1061158846) {
                int index = 0;
                boolean success = m.getAsBoolean(index++);
                String keyName = m.getAsString(index++);
                if (success) {
                    RegistryKey key = new RegistryKey(keyName);
                    String parentKeyName = key.getParentKeyName();
                    final VirtualTreeNode parentNode = RegistryTree.this.getNodeFromName(parentKeyName);
                    final VirtualTreeNode newNode = new VirtualTreeNode(key);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            newNode.removeAllChildren();
                            newNode.setQueried(true);
                            RegistryTree.this.registryTree.getModel().addChildNodeInOrder(parentNode, newNode);
                        }
                    });
                }
            } else if (m.getType() == -1061158845) {
                int index = 0;
                boolean success = m.getAsBoolean(index++);
                String keyName = m.getAsString(index++);
                String valueName = m.getAsString(index++);
                if (success) {
                    RegistryKey registryKey = RegistryTree.this.getKeyFromName(keyName);
                    RegistryValue deletedValue = registryKey.getValueByName(valueName);
                    if (RegistryTree.this.simpleList.contains(deletedValue)) {
                        RegistryTree.this.simpleList.remove(deletedValue);
                    }
                    registryKey.removeValueByName(valueName);
                } else {
                    System.out.println("[RegistryTree] Unable to delete " + keyName + "!" + valueName + ".");
                }
            } else if (m.getType() == -1061158847) {
                int index = 0;
                boolean success = m.getAsBoolean(index++);
                String keyName = m.getAsString(index++);
                if (success) {
                    final VirtualTreeNode node = RegistryTree.this.getNodeFromName(keyName);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RegistryTree.this.registryTree.getModel().removeNodeFromParent(node);
                        }
                    });
                } else {
                    System.out.println("[RegistryTree] Unable to delete " + keyName + ".");
                }
            } else if (m.getType() == -1061158848) {
                int index = 0;
                boolean success = m.getAsBoolean(index++);
                String keyName = m.getAsString(index++);
                RegistryKey entry = RegistryTree.this.getKeyFromName(keyName);
                int keyChildrenCount = m.getAsInt(index++);
                RegistryKey[] children = new RegistryKey[keyChildrenCount];
                for (int i = 0; i < keyChildrenCount; ++i) {
                    children[i] = new RegistryKey(keyName + "\\" + m.getAsString(index++));
                }
                RegistryKey.access$1302(entry, children);
                int valueCount = m.getAsInt(index++);
                for (int i = 0; i < valueCount; ++i) {
                    entry.addValue(new RegistryValue(m.getAsString(index++)));
                }
                RegistryKey registryKey = entry;
                synchronized (registryKey) {
                    entry.notifyAll();
                }
            }
        }
    }

    static class CannotEditValueException
    extends Exception {
        CannotEditValueException() {
        }
    }

    class DebugTreeInterface
    implements VirtualTreeInterface {
        int count = 0;

        DebugTreeInterface() {
        }

        @Override
        public Object[] getChildrenOf(Object parent) {
            int i;
            RegistryKey entry = (RegistryKey)parent;
            System.out.println("[RegistryTree] Requested chidren of " + entry.getKeyName());
            String[][] children = WReg.getChildren(entry.getKeyName());
            if (children == null || children.length == 0) {
                return new Object[0];
            }
            String[] keys = children[0];
            String[] values = children[1];
            Object[] objects = new RegistryKey[keys.length];
            int index = 0;
            for (i = 0; i < keys.length; ++i) {
                objects[index++] = new RegistryKey(entry.keyName + "\\" + keys[i]);
            }
            for (i = 0; i < values.length; ++i) {
                entry.addValue(new RegistryValue(values[i]));
            }
            return objects;
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (!RegistryTree.this.controlEnabled) {
                return;
            }
            if (evt.getClickCount() == 2) {
                RegistryKey currentlySelectedKey = RegistryTree.this.getCurrentlySelectedKey();
                RegistryValue currentValue = RegistryTree.this.getCurrentlySelectedValue();
                if (currentValue != null) {
                    try {
                        RegistryKeyDialog registryKeyDialog = new RegistryKeyDialog((RootPaneContainer)((Object)RegistryTree.this.table.getRootPane().getParent()), currentValue);
                        RegistryValue returnedValue = registryKeyDialog.getReturnedValue();
                        if (returnedValue != null) {
                            Message m = new Message(-1061158844);
                            m.append(currentlySelectedKey.getKeyName());
                            m.append(returnedValue.name);
                            m.append(returnedValue.value);
                            m.append(returnedValue.type);
                            RegistryTree.this.con.doAsyncRemoteCommand(RegistryTree.this.responseListener, m);
                        }
                    }
                    catch (CannotEditValueException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class RegistryActionListener
    implements ActionListener {
        RegistryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RegistryTree.this.controlEnabled) {
                return;
            }
            if (e.getSource() == RegistryTree.this.deleteKey) {
                String currentKey = RegistryTree.this.getCurrentlySelectedKey().getKeyName();
                Message m = new Message(-1061158847);
                m.append(currentKey);
                RegistryTree.this.con.doAsyncRemoteCommand(RegistryTree.this.responseListener, m);
            } else if (e.getSource() == RegistryTree.this.deleteValue) {
                RegistryKey currentlySelectedKey = RegistryTree.this.getCurrentlySelectedKey();
                RegistryValue currentlySelectedValue = RegistryTree.this.getCurrentlySelectedValue();
                Message m = new Message(-1061158845);
                m.append(currentlySelectedKey.getKeyName());
                m.append(currentlySelectedValue.name);
                RegistryTree.this.con.doAsyncRemoteCommand(RegistryTree.this.responseListener, m);
            } else if (e.getSource() == RegistryTree.this.createKey) {
                String newKeyName = SHGlassOptionPane.showInputDialog((RootPaneContainer)((RootPaneContainer)((Object)RegistryTree.this.table.getRootPane().getParent())), (String)"Enter the name of the key to be created:", (String)"Create a new registry key", (Icon)ImageLoader.getImageIcon((String)"images/svg/security/key.svg,48"), (String)"Create Key", (String)"");
                if (newKeyName != null && newKeyName.length() > 0) {
                    String parentKey = RegistryTree.this.getCurrentlySelectedKey().getKeyName();
                    String newKey = parentKey + "\\" + newKeyName;
                    Message m = new Message(-1061158846);
                    m.append(newKey);
                    RegistryTree.this.con.doAsyncRemoteCommand(RegistryTree.this.responseListener, m);
                }
            } else if (e.getSource() == RegistryTree.this.createValue) {
                RegistryKey currentlySelectedKey = RegistryTree.this.getCurrentlySelectedKey();
                try {
                    RegistryKeyDialog registryKeyDialog = new RegistryKeyDialog((RootPaneContainer)((Object)RegistryTree.this.table.getRootPane().getParent()));
                    RegistryValue returnedValue = registryKeyDialog.getReturnedValue();
                    if (returnedValue != null) {
                        System.out.println("[RegistryTree] Sending set registry key request: " + returnedValue);
                        Message m = new Message(-1061158844);
                        m.append(currentlySelectedKey.getKeyName());
                        m.append(returnedValue.name);
                        m.append(returnedValue.value);
                        m.append(returnedValue.type);
                        RegistryTree.this.con.doAsyncRemoteCommand(RegistryTree.this.responseListener, m);
                    }
                }
                catch (CannotEditValueException cannotEditValueException) {
                    // empty catch block
                }
            }
        }
    }

    class RegistryCellRenderer
    extends DefaultTreeCellRenderer {
        public RegistryCellRenderer() {
            this.setBorderSelectionColor(null);
            this.setBackgroundSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                if (!(value instanceof VirtualTreeNode) && value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    c.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
                    label.setIcon(null);
                } else {
                    label.setIcon(ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
                }
            }
            return c;
        }
    }

    class RegistryKey {
        private String keyName;
        private ArrayList registryValues = new ArrayList();
        private RegistryKey[] children;

        public RegistryKey(String keyName) {
            this.keyName = keyName;
        }

        public void removeValueByName(String valueName) {
            RegistryValue existingValue = this.getValueByName(valueName);
            this.registryValues.remove(existingValue);
        }

        public void addOrOverwriteValue(RegistryValue newValue) {
            RegistryValue existingValue = this.getValueByName(newValue.name);
            if (existingValue == null) {
                this.registryValues.add(newValue);
            } else {
                this.registryValues.remove(existingValue);
                this.registryValues.add(newValue);
            }
        }

        public RegistryValue getValueByName(String valueName) {
            for (int i = 0; i < this.registryValues.size(); ++i) {
                RegistryValue value = (RegistryValue)this.registryValues.get(i);
                if (value == null || value.name == null || !value.name.equals(valueName)) continue;
                return value;
            }
            return null;
        }

        public String getLastKeyName() {
            if (this.keyName == null) {
                return null;
            }
            if (this.keyName.indexOf(92) == -1) {
                return this.keyName;
            }
            return this.keyName.substring(this.keyName.lastIndexOf(92) + 1);
        }

        public String getParentKeyName() {
            if (this.keyName == null) {
                return null;
            }
            if (this.keyName.indexOf(92) == -1) {
                return null;
            }
            return this.keyName.substring(0, this.keyName.lastIndexOf(92));
        }

        public void setChildren(RegistryKey[] children) {
            this.children = children;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void addValue(RegistryValue value) {
            this.registryValues.add(value);
        }

        public String toString() {
            int index = this.keyName.lastIndexOf(92);
            if (index == -1) {
                return this.keyName;
            }
            return this.keyName.substring(index + 1);
        }

        static /* synthetic */ RegistryKey[] access$1302(RegistryKey x0, RegistryKey[] x1) {
            x0.children = x1;
            return x1;
        }
    }

    public static class RegistryKeyDialog
    extends ScaledGlassDialog
    implements ActionListener {
        JLabel nameLabel = new JLabel(Language.get("NAME"));
        JLabel typeLabel = new JLabel(Language.get("TYPE"));
        JLabel valueLabel = new JLabel(Language.get("VALUE"));
        JTextField nameField = new JTextField();
        JComboBox typeBox;
        JScrollPane valueAreaSp = new JScrollPane();
        JTextArea valueArea = new JTextArea();
        JTextField valueField = new JTextField();
        JButton okButton;
        JButton cancelButton;
        GbPanel valuePanel = new GbPanel();
        int oldHeight = -1;
        private RegistryValue registryValue;

        public RegistryKeyDialog(RootPaneContainer rootPane) throws CannotEditValueException {
            this(rootPane, null);
        }

        public RegistryKeyDialog(RootPaneContainer rootPaneContainer, RegistryValue currentValue) throws CannotEditValueException {
            super(rootPaneContainer, 350, 340, true, false, false);
            this.createUI(currentValue);
            this.init(false);
            this.setVisible(true);
        }

        private void createUI(RegistryValue currentValue) throws CannotEditValueException {
            this.typeBox = new JComboBox<String>(new String[]{Language.get("REG_SZ") + " (REG_SZ)", Language.get("REG_EXPAND_SZ") + " (REG_EXPAND_SZ)", Language.get("REG_MULTI_SZ") + " (REG_MULTI_SZ)", Language.get("REG_DWORD") + " (REG_DWORD)", Language.get("REG_QWORD") + " (REG_QWORD)"});
            this.typeBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RegistryKeyDialog.this.setValuePanelContents();
                    RegistryKeyDialog.this.valuePanel.repaint();
                }
            });
            this.okButton = new JButton(Language.get("CREATE_VALUE_OK"));
            SHButtonUI.makeButtonBlue((JButton)this.okButton);
            this.cancelButton = new JButton(Language.get("CANCEL"));
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, SimpleHelpLookAndFeel.scale((int)5), 0));
            buttonsPanel.add(this.cancelButton);
            buttonsPanel.add(this.okButton);
            this.valueAreaSp = new JScrollPane(this.valueArea);
            this.valueArea.setBackground(this.nameField.getBackground());
            this.valueArea.setFont(this.nameField.getFont());
            this.setValuePanelContents();
            GbPanel panel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
            panel.add((Component)this.nameLabel, 0, 0, 1, 1, 0, 1, 13, 0);
            panel.add((Component)this.nameField, 1, 0, 1, 1, 100, 1, 17, 2);
            panel.add((Component)this.typeLabel, 0, 1, 1, 1, 0, 1, 13, 0);
            panel.add((Component)this.typeBox, 1, 1, 1, 1, 0, 1, 17, 2);
            panel.add((Component)this.valueLabel, 0, 2, 1, 1, 0, 1000, 12, 0, (Insets)new ScaledInsets(6, 3, 3, 3));
            panel.add((Component)this.valuePanel, 1, 2, 1, 1, 100, 1000, 17, 1);
            panel.add((Component)buttonsPanel, 0, 3, 2, 1, 1, 1, 13, 0);
            panel.setBorder(SHBorderFactory.createEmptyBorder((int)7, (int)7, (int)7, (int)7));
            this.internalFrame.add((Component)panel);
            if (currentValue != null) {
                this.nameField.setText(currentValue.name);
                int type = RegistryKeyDialog.getTypeFromText(currentValue.type);
                if (type == -1) {
                    throw new CannotEditValueException();
                }
                this.typeBox.setSelectedIndex(type);
                this.valueArea.setText(currentValue.value);
            }
        }

        private static String getTextTypeFrom(int type) {
            switch (type) {
                case 0: {
                    return "REG_SZ";
                }
                case 1: {
                    return "REG_EXPAND_SZ";
                }
                case 2: {
                    return "REG_MULTI_SZ";
                }
                case 3: {
                    return "REG_DWORD";
                }
                case 4: {
                    return "REG_QWORD";
                }
            }
            return "REG_NONE";
        }

        private static int getTypeFromText(String type) {
            if (type.equals("REG_SZ")) {
                return 0;
            }
            if (type.equals("REG_EXPAND_SZ")) {
                return 1;
            }
            if (type.equals("REG_MULTI_SZ")) {
                return 2;
            }
            if (type.equals("REG_DWORD")) {
                return 3;
            }
            if (type.equals("REG_QWORD")) {
                return 4;
            }
            return -1;
        }

        private void setValuePanelContents() {
            this.valuePanel.removeAll();
            this.valuePanel.resetLayout();
            int selectedType = this.typeBox.getSelectedIndex();
            if (selectedType >= 3) {
                this.valuePanel.add((Component)this.valueField, 0, 0, 1, 1, 1, 1, 11, 2);
                this.oldHeight = this.getHeight();
                this.setHeight(SimpleHelpLookAndFeel.scale((int)200));
            } else {
                this.valuePanel.add((Component)this.valueAreaSp, 0, 0, 1, 1, 1, 1, 11, 1);
                if (this.oldHeight > 0) {
                    this.setHeight(this.oldHeight);
                }
            }
            this.valuePanel.revalidate();
            this.updateBoundsForCenteredOnScreen();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButton) {
                String name = this.nameField.getText();
                int selectedType = this.typeBox.getSelectedIndex();
                String value = selectedType >= 3 ? this.valueField.getText() : this.valueArea.getText();
                String type = RegistryKeyDialog.getTextTypeFrom(selectedType);
                this.registryValue = new RegistryValue(name, value, type);
            } else {
                this.registryValue = null;
            }
            this.setVisible(false);
        }

        public RegistryValue getReturnedValue() {
            return this.registryValue;
        }
    }

    class RegistryTreeInterface
    implements VirtualTreeInterface {
        int count = 0;

        RegistryTreeInterface() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getChildrenOf(Object parent) {
            RegistryKey entry = (RegistryKey)parent;
            System.out.println("[RegistryTree] Requested chidren of " + entry.getKeyName());
            RegistryKey registryKey = entry;
            synchronized (registryKey) {
                Message m = new Message(-1061158848);
                m.append(entry.getKeyName());
                RegistryTree.this.con.doAsyncRemoteCommand(RegistryTree.this.responseListener, m);
                try {
                    entry.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (entry.children == null) {
                    RegistryKey.access$1302(entry, new RegistryKey[0]);
                }
                System.out.println("[RegistryTree] " + entry.getKeyName() + " -> " + entry.children.length + " children");
                return entry.children;
            }
        }
    }

    static class RegistryValue {
        private String name = "name";
        private String value = "";
        private String type = "type";

        public RegistryValue(String name, String value, String type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public RegistryValue(String data) {
            String[] dataSplit = data.split("\\-\\|\\-\\|\\-\\|");
            this.name = dataSplit[0];
            this.type = dataSplit[1];
            if (dataSplit.length > 2) {
                this.value = dataSplit[2];
            }
            this.type = this.convertTypeToString(this.type);
        }

        private String convertTypeToString(String type) {
            int intType = Integer.parseInt(type);
            switch (intType) {
                case 0: {
                    return "REG_NONE";
                }
                case 1: {
                    return "REG_SZ";
                }
                case 2: {
                    return "REG_EXPAND_SZ";
                }
                case 3: {
                    return "REG_BINARY";
                }
                case 4: {
                    return "REG_DWORD";
                }
                case 5: {
                    return "REG_DWORD_BIG_ENDIAN";
                }
                case 6: {
                    return "REG_LINK";
                }
                case 7: {
                    return "REG_MULTI_SZ";
                }
                case 8: {
                    return "REG_RESOURCE_LIST";
                }
                case 9: {
                    return "REG_FULL_RESOURCE_DESCRIPTOR";
                }
                case 10: {
                    return "REG_RESOURCE_REQUIREMENTS_LIST";
                }
                case 11: {
                    return "REG_QWORD";
                }
            }
            return "";
        }

        public String toString() {
            return this.name;
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RegistryTree.this.table.getSelectedRow() != -1) {
                RegistryTree.this.deleteValue.setEnabled(RegistryTree.this.controlEnabled);
            } else {
                RegistryTree.this.deleteValue.setEnabled(false);
            }
        }
    }

    class TreeChoiceListener
    implements TreeSelectionListener {
        TreeChoiceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath selectedNode = RegistryTree.this.registryTree.getRootComponent().getSelectionPath();
            if (selectedNode != null) {
                RegistryKey selectedKey = (RegistryKey)((VirtualTreeNode)selectedNode.getLastPathComponent()).getUserObject();
                RegistryTree.this.simpleList.startBatch();
                try {
                    RegistryTree.this.simpleList.clear();
                    RegistryTree.this.simpleList.addAll(selectedKey.registryValues);
                }
                finally {
                    RegistryTree.this.simpleList.endBatch();
                }
                RegistryTree.this.createKey.setEnabled(RegistryTree.this.controlEnabled);
                RegistryTree.this.createValue.setEnabled(RegistryTree.this.controlEnabled);
                if (((VirtualTreeNode)selectedNode.getLastPathComponent()).getChildCount() == 0) {
                    RegistryTree.this.deleteKey.setEnabled(RegistryTree.this.controlEnabled);
                } else {
                    RegistryTree.this.deleteKey.setEnabled(false);
                }
                RegistryTree.this.table.repaint();
            } else {
                RegistryTree.this.createKey.setEnabled(false);
                RegistryTree.this.createValue.setEnabled(false);
                RegistryTree.this.deleteKey.setEnabled(false);
            }
        }
    }
}

