/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.diag.PortForward;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.util.PortRedirector;
import com.aem.shelp.common.Language;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;

public class PortProxyPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
KeyListener {
    private static final int RULE_LIMIT = 6;
    PortRedirector prot;
    private SimpleList<PortForward> portList = new SimpleList();
    private SimpleListModel listModel = new SimpleListModel<PortForward>(this.portList);
    private JList list = new JList(this.listModel);
    JButton direction;
    Icon right;
    Icon left;
    JLabel locallabel;
    JLabel remotelabel;
    JTextField localport = new JTextField();
    JTextField remoteport = new JTextField();
    JButton add = new JButton(Language.get("ADD"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
    JButton save = new JButton(Language.get("SAVE"), ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
    JButton delete = new JButton(Language.get("DELETE"), ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
    JPanel main;
    JPanel buttons;
    GbPanelWrapper south;
    GUI gui;
    private RoundBorderPanel southPanel;
    private ClientController con;

    public PortProxyPanel(GUI gui, ClientController con, PortRedirector prot) {
        this.prot = prot;
        this.gui = gui;
        this.con = con;
        this.setLayout(new BorderLayout());
        this.list.setCellRenderer(new PortRenderer());
        this.main = new RoundBorderPanel(Language.get("REDIRECTED_PORTS"));
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        this.southPanel = new RoundBorderPanel(Language.get("REDIRECTED_PORT_CONFIG"));
        this.south = new GbPanelWrapper((Container)this.southPanel, (Insets)new ScaledInsets(5, 5, 5, 5));
        this.buttons = new JPanel();
        controls.add("Center", this.southPanel);
        controls.add("South", this.buttons);
        this.add("Center", this.main);
        this.add("North", controls);
        this.right = ImageLoader.getImageIcon((String)"images/svg/arrows/right.svg,24");
        this.left = ImageLoader.getImageIcon((String)"images/svg/arrows/left.svg,24");
        this.direction = new JButton(this.right);
        this.locallabel = new JLabel(Language.get("EXAMPLE_PORT_ONLY"));
        this.remotelabel = new JLabel(Language.get("EXAMPLE_PORT_AND_HOST"));
        this.locallabel.setHorizontalAlignment(0);
        this.remotelabel.setHorizontalAlignment(0);
        Font oldFont = this.locallabel.getFont();
        float size = oldFont.getSize();
        Font newFont = oldFont.deriveFont(size -= 2.0f);
        this.locallabel.setFont(newFont);
        this.locallabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.remotelabel.setFont(newFont);
        this.remotelabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.locallabel.setPreferredSize(this.remotelabel.getPreferredSize());
        this.main.setLayout(new GridLayout(1, 1));
        this.main.add(new JScrollPane(this.list));
        this.south.add((Component)new JLabel(Language.get("LOCAL_MACHINE"), ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,24"), 0), 0, 0, 1, 1, 10, 10, 10, 2);
        this.south.add((Component)this.direction, 1, 0, 1, 3, 11, 10, 10, 0);
        this.south.add((Component)new JLabel(Language.get("REMOTE_MACHINE"), ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,24 | images/svg/general/world.svg,16]"), 0), 2, 0, 1, 1, 10, 10, 10, 2);
        this.south.add((Component)this.localport, 0, 1, 1, 1, 10, 10, 17, 2);
        this.south.add((Component)this.remoteport, 2, 1, 1, 1, 10, 10, 17, 2);
        this.south.add((Component)this.locallabel, 0, 2, 1, 1, 0, 10, 10, 0);
        this.south.add((Component)this.remotelabel, 2, 2, 1, 1, 0, 10, 10, 0);
        this.localport.setDocument(new DigitDocument(false));
        this.buttons.setLayout((LayoutManager)new ScaledFlowLayout(1));
        this.buttons.add(this.add);
        this.buttons.add(this.delete);
        this.list.addListSelectionListener(this);
        this.add.addActionListener(this);
        this.save.addActionListener(this);
        this.direction.addActionListener(this);
        this.delete.addActionListener(this);
        this.localport.addKeyListener(this);
        this.remoteport.addKeyListener(this);
        this.updateEnabled();
    }

    private void saveToPrefs() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<PortFowards>\n");
        for (PortForward pf : this.portList) {
            buffer.append("\t").append(pf.toXML()).append("\n");
        }
        buffer.append("</PortFowards>\n");
        this.con.getConnectedMachinePrefs().setPortForwards(buffer.toString());
    }

    private void loadFromPrefs() {
        this.portList.clear();
        if (this.con == null) {
            return;
        }
        String xml = this.con.getConnectedMachinePrefs().getPortForwards();
        if (xml == null) {
            return;
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(new InputSource(new StringReader(xml)));
            NodeList elementsByTagName = dom.getElementsByTagName("PortForward");
            for (int i = 0; i < elementsByTagName.getLength(); ++i) {
                Element e = (Element)elementsByTagName.item(i);
                PortForward pf = PortForward.fromXMLElement(e);
                pf.switchedOn = !pf.switchedOn;
                this.addPortForward(pf);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.loadFromPrefs();
        }
        this.setEnabled(connected);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PortForward pf = (PortForward)this.list.getSelectedValue();
        if (pf != null) {
            if (pf.toremote) {
                this.direction.setIcon(this.right);
            } else {
                this.direction.setIcon(this.left);
            }
            this.localport.setText(pf.localport);
            this.remoteport.setText(pf.remoteport);
            this.direction.repaint();
            this.localport.repaint();
            this.remoteport.repaint();
            this.updateEnabled();
        }
    }

    private void on(PortForward pf) {
        if (!pf.switchedOn) {
            pf.switchedOn = true;
            if (pf.toremote) {
                this.prot.addRedirection(pf.getClientFwdPort(), pf.getTargetFwdHost(), pf.getTargetFwdPort(), pf.UID);
            } else {
                this.prot.addRemoteRedirection(pf.getClientFwdPort(), pf.getTargetFwdHost(), pf.getTargetFwdPort(), pf.UID);
            }
        }
    }

    private void off(PortForward pf) {
        if (pf.switchedOn) {
            pf.switchedOn = false;
            this.prot.removeRedirection(pf.UID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.direction) {
            if (this.direction.getIcon() == this.right) {
                this.direction.setIcon(this.left);
            } else {
                this.direction.setIcon(this.right);
            }
            this.direction.repaint();
            this.updateEnabled();
        } else if (o == this.add) {
            if (this.portList.size() == 6) {
                SHGlassOptionPane.showMessageDialog((RootPaneContainer)this.gui.getParentFrame(), (String)Language.get("PORT_PANEL_LIMIT_REACHED_MSG"), (String)Language.get("PORT_PANEL_LIMIT_REACHED_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                return;
            }
            PortForward pf = new PortForward();
            pf.toremote = this.direction.getIcon() == this.right;
            pf.localport = this.localport.getText();
            pf.remoteport = this.remoteport.getText();
            this.addPortForward(pf);
            this.saveToPrefs();
        } else if (o == this.delete) {
            this.portList.startBatch();
            try {
                List<PortForward> values = this.getSelectedValuesList();
                for (PortForward pf : values) {
                    this.off(pf);
                    this.portList.remove(pf);
                }
            }
            finally {
                this.portList.endBatch();
            }
            this.saveToPrefs();
        } else if (o == this.save) {
            PortForward pf = (PortForward)this.list.getSelectedValue();
            if (pf != null) {
                pf.toremote = this.direction.getIcon() == this.right;
                pf.localport = this.localport.getText();
                pf.remoteport = this.remoteport.getText();
                this.portList.notifyElementUpdate(pf);
            }
            this.saveToPrefs();
        }
    }

    private List<PortForward> getSelectedValuesList() {
        int[] indices = this.list.getSelectedIndices();
        ArrayList<PortForward> newList = new ArrayList<PortForward>();
        for (int i = 0; i < indices.length; ++i) {
            newList.add(this.portList.get(indices[i]));
        }
        return newList;
    }

    private void addPortForward(PortForward pf) {
        boolean conflict = false;
        for (PortForward pfc : this.portList) {
            if (!pfc.getUniqueID().equals(pf.getUniqueID())) continue;
            conflict = true;
        }
        this.on(pf);
        if (!conflict) {
            this.portList.add(pf);
        } else {
            this.portList.notifyElementUpdate(pf);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean enabled;
        JTextField toport;
        JTextField fromport;
        if (this.direction.getIcon() == this.right) {
            this.locallabel.setText(Language.get("EXAMPLE_PORT_ONLY"));
            this.remotelabel.setText(Language.get("EXAMPLE_PORT_AND_HOST"));
            this.locallabel.setPreferredSize(this.remotelabel.getPreferredSize());
        } else {
            this.remotelabel.setText(Language.get("EXAMPLE_PORT_ONLY"));
            this.locallabel.setText(Language.get("EXAMPLE_PORT_AND_HOST"));
            this.remotelabel.setPreferredSize(this.locallabel.getPreferredSize());
        }
        if (this.localport.getText().length() > this.remoteport.getText().length()) {
            this.remoteport.setPreferredSize(this.localport.getPreferredSize());
        } else {
            this.localport.setPreferredSize(this.remoteport.getPreferredSize());
        }
        if (this.direction.getIcon() == this.right) {
            fromport = this.localport;
            toport = this.remoteport;
        } else {
            fromport = this.remoteport;
            toport = this.localport;
        }
        boolean addEnabled = enabled = this.isEnabled();
        String s = fromport.getText();
        if (s.trim().length() == 0) {
            addEnabled = false;
        }
        try {
            Integer.parseInt(s.trim());
        }
        catch (Exception x) {
            addEnabled = false;
        }
        s = toport.getText();
        if (s.trim().length() == 0) {
            addEnabled = false;
        }
        this.direction.setEnabled(enabled);
        this.localport.setEnabled(enabled);
        this.remoteport.setEnabled(enabled);
        this.locallabel.setEnabled(enabled);
        this.remotelabel.setEnabled(enabled);
        this.add.setEnabled(addEnabled);
        this.save.setEnabled(addEnabled && this.list.getSelectedIndices().length == 1);
        this.delete.setEnabled(this.list.getSelectedIndices().length > 0);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.updateEnabled();
    }

    class PortRenderer
    extends DefaultListCellRenderer {
        JPanel tmp = new JPanel(new BorderLayout());
        JLabel from = new JLabel();
        JLabel dir = new JLabel();
        JLabel to = new JLabel();
        JLabel ison = new JLabel();
        private GbPanel labels = new GbPanel(new ScaledInsets(0, 5, 0, 5));
        private JPanel isOnPanel;

        public PortRenderer() {
            this.tmp.add("Center", (Component)this.labels);
            this.from.setIcon(ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
            this.dir.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/right.svg,16"));
            this.to.setIcon(ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,16 | images/svg/general/world.svg,12]"));
            this.ison.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/world.svg,16"));
            this.labels.add((Component)this.from, 0, 0, 1, 1, 1000, 10, 17, 2);
            this.labels.add((Component)this.dir, 1, 0, 1, 1, 10, 10, 17, 0);
            this.labels.add((Component)this.to, 2, 0, 1, 1, 1000, 10, 17, 2);
            this.from.setOpaque(true);
            this.to.setOpaque(true);
            this.dir.setOpaque(true);
            this.tmp.setOpaque(true);
            this.ison.setOpaque(true);
            this.isOnPanel = new JPanel();
            this.tmp.add("East", this.isOnPanel);
            this.isOnPanel.add(this.ison);
            JLabel siz = new JLabel("------------------------");
            this.from.setPreferredSize(siz.getPreferredSize());
            this.to.setPreferredSize(siz.getPreferredSize());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color c;
            Color fg;
            PortForward pf = (PortForward)value;
            if (isSelected) {
                fg = list.getSelectionForeground();
                c = list.getSelectionBackground();
            } else {
                fg = list.getForeground();
                c = list.getBackground();
            }
            this.isOnPanel.setBackground(c);
            this.labels.setBackground(c);
            this.tmp.setBackground(c);
            this.from.setBackground(c);
            this.dir.setBackground(c);
            this.to.setBackground(c);
            this.ison.setBackground(c);
            this.tmp.setForeground(fg);
            this.from.setForeground(fg);
            this.dir.setForeground(fg);
            this.to.setForeground(fg);
            this.ison.setForeground(fg);
            if (pf.isSwitchedOn()) {
                this.ison.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/world.svg,16"));
            } else {
                this.ison.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"));
            }
            if (pf.toremote) {
                this.from.setIcon(ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
                this.to.setIcon(ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,16 | images/svg/general/world.svg,12]"));
                this.from.setText(pf.localport);
                this.to.setText(pf.remoteport);
            } else {
                this.from.setIcon(ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,16 | images/svg/general/world.svg,12]"));
                this.to.setIcon(ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
                this.from.setText(pf.remoteport);
                this.to.setText(pf.localport);
            }
            return this.tmp;
        }
    }
}

