/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLinkStats;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.ConnectionSwitch;
import com.aem.sdesktop.client.gui.ConnectionSwitchListener;
import com.aem.sdesktop.client.gui.FPSSlider;
import com.aem.sdesktop.client.gui.FramerateLabel;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.util.ColourDepthIcon;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.NStarsIcon;
import com.aem.shelp.util.notifications.NotificationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.message.Message;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.switches.Switches;

public class TuneDialog
extends ScaledGlassDialog
implements ConnectionSwitchListener,
GuiConstants,
ActionListener,
KeyListener,
ChangeListener,
NotificationPanel.NotificationPanelListener,
ListSelectionListener,
CommandResponseListener {
    private static final boolean ALLOW_FIXED_BW = false;
    private final JPanel main_panel = new JPanel();
    private final JPanel button_panel = new JPanel();
    private final JButton button_ok = new JButton(" " + Language.get("CLOSE") + " ");
    private final FPSSlider fpsSlider = new FPSSlider();
    private final JTabbedPane tabs = new JTabbedPane();
    private final GbPanel session = new GbPanel(new ScaledInsets(2, 3, 1, 3));
    private final long fpsDelay;
    private JLabel allConnection;
    private JLabel allFailures;
    private JLabel techConnection;
    private JLabel techFailures;
    private JLabel custConnection;
    private JLabel custFailures;
    private JLabel clabel;
    private ConnectionSwitch cswitch;
    private JButton more;
    private JList sessionTypes;
    private String[] sessionHeaders;
    private Icon[] sessionIcons;
    private String[] sessionDetails;
    private JLabel sessionHeader;
    private JLabel sessionDetail;
    private GbPanel sessionSwitches;
    private JButton switchLocal;
    private JButton switchRemote;
    private JButton switchBoth;
    private final GbPanel advanced = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private final JCheckBox useHighPriority = new JCheckBox(Language.get("USE_HIGH_PRIORITY"), true);
    private NotificationPanel np;
    private final GbPanel main = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private final GbPanel fpanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private final JLabel lab_large = new JLabel(Language.get("FAST_NETWORK"), 2);
    private final JToggleButton fil_large = new JToggleButton();
    private final JLabel lab_small = new JLabel(Language.get("SLOW_NETWORK"), 2);
    private final JToggleButton fil_small = new JToggleButton();
    private final JLabel lab_col = new JLabel(Language.get("COLOR"), 2);
    private final JToggleButton col = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/colours.svg,32"));
    private final JLabel lab_bw = new JLabel(Language.get("BLACK_AND_WHITE"), 2);
    private final JToggleButton bw = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/black-and-white.svg,32"));
    private final JSlider slid = new JSlider(4, 21, 10);
    private final JLabel shades = new JLabel(this.slid.getValue() + " " + Language.get("COLOR_SHADES"), 0);
    private final ColourDepthIcon ic_img = new ColourDepthIcon(ImageLoader.getImageIcon((String)"images/examples/img.png"));
    private final ColourDepthIcon ic_ui = new ColourDepthIcon(ImageLoader.getImageIcon((String)"images/examples/ui.png"));
    private final ColourDepthIcon ic_text = new ColourDepthIcon(ImageLoader.getImageIcon((String)"images/examples/text.png"));
    private final JLabel ex_img = new JLabel(this.ic_img);
    private final JLabel ex_ui = new JLabel(this.ic_ui);
    private final JLabel ex_text = new JLabel(this.ic_text);
    private JPanel frpanel;
    private JPanel cpanel;
    private JPanel udppanel;
    private JPanel switchpanel;
    private JCheckBox usekbs;
    private JTextField kbs;
    private final FramerateLabel fricon = new FramerateLabel();
    private final GUI gui;
    private final ClientController con;
    private final boolean sdemoControls;
    private AbstractButton saveDefaults;
    private final boolean canUseUDP;
    private static final int WIDTH = 620;
    private static final int HEIGHT = 450;
    private NodeLinkStats lstat;
    private NodeLinkStats rstat;
    private final ElapsedTimeFormatter etf = new ElapsedTimeFormatter();
    private int selectedType = -1;

    public TuneDialog(GUI gui, RootPaneContainer parent, ClientController con, boolean canUseUDP, long fpsDelay) {
        this(gui, parent, con, false, canUseUDP, fpsDelay);
    }

    private TuneDialog(GUI gui, RootPaneContainer parent, ClientController con, boolean sdemoControls, boolean canUseUDP, long fpsDelay) {
        super(parent, 620, 450, true, false, false);
        this.canUseUDP = canUseUDP;
        this.gui = gui;
        this.con = con;
        this.sdemoControls = sdemoControls;
        this.fpsDelay = fpsDelay;
        this.setTitle(Language.get("CONNECTION_TUNING_TITLE"));
        this.initGraphics();
        this.initEventHandling();
        this.setEnabled(true);
        this.setFocusComponent(this.slid);
        super.initAndPack();
    }

    public void showSessionInfo() {
        Component[] all = this.tabs.getComponents();
        for (int i = 0; i < all.length; ++i) {
            if (all[i] != this.session) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
    }

    public void setVisible(boolean vis) {
        if (vis) {
            this.setEnabled(true);
            try {
                this.loadSettings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.updateEnabled();
        }
        super.setVisible(vis);
    }

    private void initGraphics() {
        SHButtonUI.makeButtonBlue((JButton)this.button_ok);
        this.frpanel = new RoundBorderPanel(Language.get("SCREEN_UPDATES"));
        this.cpanel = new RoundBorderPanel(Language.get("COLOR_COMPLEXITY"));
        this.udppanel = new RoundBorderPanel(Language.get("UDP_BANDWIDTH_FIXING"));
        this.switchpanel = new RoundBorderPanel(Language.get("TUNE_SWITCH"));
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.main_panel);
        GbPanel checkboxes = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        if (!this.sdemoControls && CentralDebugging.ALLOW_CHANGE_FILTERING_SIZE) {
            this.main.add((Component)this.fpanel, 0, 0, 1, 1, 100, 10, 11, 2);
        }
        this.main.add((Component)this.cpanel, 0, 2, 1, 1, 100, 10, 11, 2);
        this.main.add((Component)this.frpanel, 0, 3, 1, 1, 100, 10, 11, 2);
        if (Switches.SH_1563_singlePaneTuneDialog) {
            this.main.add((Component)this.switchpanel, 0, 4, 1, 1, 100, 10, 11, 2);
        }
        this.main.add((Component)new JPanel(), 0, 4, 1, 1, 100, 1000, 11, 1);
        this.fpanel.add((Component)this.fil_large, 0, 0, 1, 1, 10, 10, 17, 0);
        this.fpanel.add((Component)this.lab_large, 1, 0, 1, 1, 100, 10, 17, 2);
        this.fpanel.add((Component)this.fil_small, 2, 0, 1, 1, 10, 10, 17, 0);
        this.fpanel.add((Component)this.lab_small, 3, 0, 1, 1, 100, 10, 17, 2);
        this.fpanel.add((Component)this.col, 0, 1, 1, 1, 10, 10, 17, 0);
        this.fpanel.add((Component)this.lab_col, 1, 1, 1, 1, 100, 10, 17, 2);
        this.fpanel.add((Component)this.bw, 2, 1, 1, 1, 10, 10, 17, 0);
        this.fpanel.add((Component)this.lab_bw, 3, 1, 1, 1, 100, 10, 17, 2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fil_large);
        bg.add(this.fil_small);
        bg = new ButtonGroup();
        bg.add(this.col);
        bg.add(this.bw);
        this.col.addActionListener(this);
        this.bw.addActionListener(this);
        GbPanelWrapper cPanelWrapper = new GbPanelWrapper((Container)this.cpanel, (Insets)new ScaledInsets(3, 3, 3, 3));
        cPanelWrapper.add((Component)new JLabel(Language.get("FASTER"), 2), 0, 0, 1, 1, 100, 10, 17, 2);
        cPanelWrapper.add((Component)new JLabel(Language.get("SLOWER"), 4), 1, 0, 1, 1, 100, 10, 13, 2);
        cPanelWrapper.add((Component)this.slid, 0, 1, 2, 1, 100, 10, 17, 2);
        cPanelWrapper.add((Component)this.shades, 0, 2, 2, 1, 100, 10, 11, 2);
        cPanelWrapper.add((Component)RoundBorderPanel.getPaddyPanel(true), 0, 3, 2, 1, 1, 1000, 10, 3);
        this.slid.setOpaque(false);
        this.slid.addChangeListener(this);
        this.ex_img.setBorder(new LineBorder(Color.GRAY));
        this.ex_ui.setBorder(new LineBorder(Color.GRAY));
        this.ex_text.setBorder(new LineBorder(Color.GRAY));
        cPanelWrapper.add((Component)this.ex_img, 2, 0, 1, 4, 1, 10, 10, 0);
        cPanelWrapper.add((Component)this.ex_ui, 3, 0, 1, 4, 1, 10, 10, 0);
        GbPanelWrapper fPanelWrapper = new GbPanelWrapper((Container)this.frpanel, (Insets)new ScaledInsets(3, 3, 3, 3));
        fPanelWrapper.add((Component)this.fpsSlider.getRootComponent(), 0, 1, 2, 1, 100, 10, 17, 2);
        this.fpsSlider.setMinDelay(this.fpsDelay);
        this.fpsSlider.addChangeListener(this);
        this.fpsSlider.getRootComponent().setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.fricon.setBorder(new LineBorder(Color.black));
        fPanelWrapper.add((Component)this.fricon, 2, 0, 1, 4, 1, 10, 10, 0);
        GbPanelWrapper gbp = new GbPanelWrapper((Container)this.udppanel, (Insets)new ScaledInsets(3, 3, 3, 3));
        JLabel label = new JLabel("Use fixed UDP bandwidth on lossy networks");
        this.usekbs = new JCheckBox("", false);
        this.kbs = new JTextField("50", 6);
        gbp.add((Component)this.usekbs, 0, 0, 1, 1, 1, 1, 17, 0);
        gbp.add((Component)label, 1, 0, 1, 1, 1, 1, 17, 0);
        gbp.add((Component)this.kbs, 2, 0, 1, 1, 1, 1, 17, 0);
        gbp.add((Component)new JLabel("KB/s"), 3, 0, 1, 1, 100, 1, 17, 2);
        gbp.add((Component)new JLabel("Learn More"), 4, 0, 1, 1, 1, 1, 13, 0);
        gbp = new GbPanelWrapper((Container)this.switchpanel, (Insets)new ScaledInsets(3, 3, 3, 3));
        JLabel allConnectionL = new JLabel(Language.get("TUNE_SWITCH") + ": ", 4);
        this.allConnection = new JLabel("", 2);
        gbp.add((Component)allConnectionL, 0, 0, 1, 1, 10, 1, 13, 2);
        gbp.add((Component)this.allConnection, 1, 0, 1, 1, 100, 1, 17, 2);
        JLabel allFailuresL = new JLabel(Language.get("CONNECTION_FAILURES") + ": ", 4);
        this.allFailures = new JLabel("", 2);
        gbp.add((Component)allFailuresL, 0, 1, 1, 1, 10, 1, 13, 2);
        gbp.add((Component)this.allFailures, 1, 1, 1, 1, 100, 1, 17, 2);
        this.clabel = new JLabel(Language.get("TUNE_HOVER"), 0);
        this.cswitch = new ConnectionSwitch(this.canUseUDP, this.gui, this.con);
        this.cswitch.setListener(this);
        gbp.add((Component)this.clabel, 2, 0, 1, 1, 10000, 1, 10, 2);
        gbp.add((Component)this.cswitch.getLabel(), 2, 1, 1, 1, 10000, 1, 10, 0);
        this.more = new JButton(ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,24"));
        if (OemBranding.OEM_IS_SH) {
            gbp.add((Component)this.more, 3, 0, 1, 2, 1, 1, 10, 0);
        }
        this.more.addActionListener(this);
        this.button_panel.setLayout((LayoutManager)new ScaledFlowLayout());
        this.button_panel.add(this.button_ok);
        checkboxes.add((Component)this.useHighPriority, 0, 4, 1, 1, 10, 10, 17, 0);
        this.advanced.add((Component)checkboxes, 0, 0, 1, 1, 100, 10, 11, 2);
        this.np = new NotificationPanel((JComponent)this.advanced);
        GbPanel connectionsPanel = new GbPanel();
        int Y = 0;
        JLabel techHeader = new JLabel(Language.get("LOCAL_MACHINE"), ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,24"), 2);
        connectionsPanel.add((Component)techHeader, 0, Y++, 2, 1, 10, 1, 17, 0);
        JLabel techConnectionL = new JLabel(Language.get("CONNECTION_TYPE") + ": ", 4);
        this.techConnection = new JLabel("-", ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,24"), 2);
        connectionsPanel.add((Component)techConnectionL, 0, Y, 1, 1, 10, 1, 13, 0, (Insets)new ScaledInsets(0, 15, 0, 0));
        connectionsPanel.add((Component)this.techConnection, 1, Y++, 1, 1, 1000, 1, 17, 2);
        JLabel techFailuresL = new JLabel(Language.get("CONNECTION_FAILURES") + ": ", 4);
        this.techFailures = new JLabel("-", ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,24"), 2);
        connectionsPanel.add((Component)techFailuresL, 0, Y, 1, 1, 10, 1, 13, 0, (Insets)new ScaledInsets(0, 15, 0, 0));
        connectionsPanel.add((Component)this.techFailures, 1, Y++, 1, 1, 1000, 1, 17, 2);
        if (!this.sdemoControls) {
            JLabel custHeader = new JLabel(Language.get("REMOTE_MACHINE"), ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,24 | images/svg/general/world.svg,16]"), 2);
            connectionsPanel.add((Component)custHeader, 0, Y++, 2, 1, 10, 1, 17, 0);
            JLabel custConnectionL = new JLabel(Language.get("CONNECTION_TYPE") + ": ", 4);
            this.custConnection = new JLabel("-", ImageLoader.getImageIcon((String)"images/svg/bulbs/bulb-grey.svg,32"), 2);
            connectionsPanel.add((Component)custConnectionL, 0, Y, 1, 1, 10, 1, 13, 0, (Insets)new ScaledInsets(0, 15, 0, 0));
            connectionsPanel.add((Component)this.custConnection, 1, Y++, 1, 1, 1000, 1, 17, 2);
            JLabel custFailuresL = new JLabel(Language.get("CONNECTION_FAILURES") + ": ", 4);
            this.custFailures = new JLabel("-", ImageLoader.getImageIcon((String)"images/svg/bulbs/bulb-grey.svg,32"), 2);
            connectionsPanel.add((Component)custFailuresL, 0, Y, 1, 1, 10, 1, 13, 0, (Insets)new ScaledInsets(0, 15, 0, 0));
            connectionsPanel.add((Component)this.custFailures, 1, Y++, 1, 1, 1000, 1, 17, 2);
        }
        this.session.add((Component)connectionsPanel, 0, Y++, 1, 1, 1000, 0, 10, 1);
        String[] keys = new String[]{Language.get("SESSION_UDP_DIRECT") + " ", Language.get("SESSION_UDP_VIA_SERVER") + " ", "TCP ", "SSL ", "HTTP "};
        this.sessionHeaders = new String[]{Language.get("SESSION_UDP_DIRECT") + " (" + Language.get("EXCELLENT") + ")", Language.get("SESSION_UDP_VIA_SERVER") + " (" + Language.get("GOOD") + ")", "TCP (" + Language.get("ACCEPTABLE") + ")", "SSL (" + Language.get("ACCEPTABLE") + ")", "HTTP (" + Language.get("POOR") + ")"};
        this.sessionIcons = new Icon[]{new NStarsIcon(5, 5), new NStarsIcon(4, 5), new NStarsIcon(3, 5), new NStarsIcon(3, 5), new NStarsIcon(1, 5)};
        this.sessionDetails = new String[]{"<html>" + Language.get("REQUIREMENTS_FOR_UDP_DIRECT") + "\n" + Language.get("REQUIREMENTS_FOR_UDP_DIRECT_2"), Language.get("REQUIREMENTS_FOR_UDP_VIA_SERVER"), Language.get("REQUIREMENTS_FOR_TCP"), "<html>" + Language.get("REQUIREMENTS_FOR_SSL") + "\n" + Language.get("REQUIREMENTS_FOR_SSL_2"), Language.get("REQUIREMENTS_FOR_HTTP")};
        GbPanel info = new GbPanel(new ScaledInsets(2, 0, 1, 3));
        info.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        RoundBorderPanel parent = new RoundBorderPanel(Language.get("SESSION_CONNECTION_TYPES"));
        parent.setLayout(new GridLayout(1, 1));
        parent.add((Component)info);
        JPanel paddy = new JPanel();
        this.session.add((Component)parent, 0, Y++, 2, 1, 1000, 0, 10, 2);
        this.session.add((Component)paddy, 0, Y++, 2, 1, 1000, 1000, 10, 1);
        this.sessionTypes = new JList<String>(keys);
        this.sessionHeader = new JLabel();
        this.sessionDetail = new JWrapLabel();
        this.sessionSwitches = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.sessionSwitches.setOpaque(false);
        this.switchLocal = new JButton(Language.get("SWITCH_LOCAL"));
        this.switchRemote = new JButton(Language.get("SWITCH_REMOTE"));
        this.switchBoth = new JButton(Language.get("SWITCH_BOTH"));
        this.saveDefaults = new JButton(Language.get("SAVE_DEFAULTS_MACHINE"));
        this.sessionSwitches.add((Component)this.saveDefaults, 0, 0, 1, 1, 10, 10, 17, 0);
        this.sessionSwitches.add((Component)this.switchBoth, 3, 0, 1, 1, 0, 10, 10, 0);
        this.switchLocal.addActionListener(this);
        this.switchRemote.addActionListener(this);
        this.switchBoth.addActionListener(this);
        this.saveDefaults.addActionListener(this);
        info.add((Component)new JScrollPane(this.sessionTypes), 0, 0, 1, 3, 1, 1, 17, 3);
        info.add((Component)this.sessionHeader, 1, 0, 1, 1, 333, 0, 17, 1);
        info.add((Component)this.sessionDetail, 1, 1, 1, 1, 1000, 1, 18, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        if (!this.sdemoControls) {
            info.add((Component)this.sessionSwitches, 1, 2, 1, 1, 1, 0, 13, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        }
        this.sessionTypes.addListSelectionListener(this);
        this.sessionTypeSelected(0);
        this.main_panel.setLayout(new BorderLayout());
        if (!Switches.SH_1563_singlePaneTuneDialog) {
            this.tabs.addTab(Language.get("BASIC"), ImageLoader.getImageIcon((String)"images/svg/general/preferences.svg,16"), (Component)this.main);
            this.tabs.addTab(Language.get("SESSION"), ImageLoader.getImageIcon((String)"images/svg/general/link.svg,16"), (Component)this.session);
            this.main_panel.add("Center", this.tabs);
        } else {
            this.main_panel.add("Center", (Component)this.main);
        }
        this.main_panel.add("South", this.button_panel);
        this.fil_large.setSelected(true);
        this.col.setSelected(true);
        try {
            this.loadSettings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateEnabled();
    }

    @Override
    public void switchHover(int type) {
        if (type == 0) {
            this.clabel.setText("HTTP");
        } else if (type == 1) {
            this.clabel.setText("SSL");
        } else if (type == 2) {
            this.clabel.setText("TCP");
        } else if (type == 3) {
            this.clabel.setText("UDP");
        } else if (type == 4) {
            this.clabel.setText("Direct UDP");
        }
    }

    @Override
    public void switchReset() {
        this.clabel.setText(Language.get("TUNE_HOVER"));
    }

    private void loadSettings() {
        System.out.println("Loading tuning settings");
        if (this.con.getFiltering() == 52) {
            this.fil_small.setSelected(true);
            this.fil_large.setSelected(false);
        } else {
            this.fil_large.setSelected(true);
            this.fil_small.setSelected(false);
        }
        if (this.con.isColour()) {
            this.col.setSelected(true);
            this.bw.setSelected(false);
        } else {
            this.bw.setSelected(true);
            this.col.setSelected(false);
        }
        int depth = this.con.getColourDepth();
        if (depth < 4) {
            this.slid.setValue(4);
        } else if (depth > 21) {
            this.slid.setValue(21);
        } else {
            this.slid.setValue(depth);
        }
        this.fpsSlider.setAppropriateDelay(this.con.getUpdateDelay(true));
        this.lstat = this.con.getLocalSessionStats();
        this.rstat = null;
        if (!this.sdemoControls) {
            this.loadStats(null, this.custConnection, this.custFailures);
        }
        new ConnectionStatsThread().start();
        System.out.println("Local NL Stats: " + this.lstat);
        this.loadStats(this.lstat, this.techConnection, this.techFailures);
    }

    private void updateStats() {
        this.lstat = this.con.getLocalSessionStats();
        new ConnectionStatsThread().start();
        System.out.println("Local NL Stats: " + this.lstat);
        this.loadStats(this.lstat, this.techConnection, this.techFailures);
        this.sessionTypeSelected(this.sessionTypes.getSelectedIndex());
        this.gui.upgradeComplete();
    }

    public void upgradeComplete() {
        new ConnectionStatsThread().start();
    }

    private void loadAllStats(NodeLinkStats local, NodeLinkStats remote) {
        if (remote == null) {
            remote = local;
        }
        if (local == null) {
            this.allConnection.setText("");
            this.allFailures.setText("");
        } else {
            if (local.type == 0) {
                this.allConnection.setText("HTTP");
            } else if (local.type == 1) {
                this.allConnection.setText("SSL");
            } else if (local.type == 2) {
                this.allConnection.setText("TCP");
            } else if (local.type == 3) {
                this.allConnection.setText("UDP");
            } else if (local.type == 4) {
                this.allConnection.setText("Direct UDP");
            }
            long max = Math.max(local.diedTimes, remote.diedTimes);
            if (max < 3L) {
                this.allFailures.setForeground(this.allConnection.getForeground());
                this.allFailures.setText(Language.get("OK"));
            } else {
                this.allFailures.setForeground(SHStyle.ERROR_TEXT_COLOR);
                this.allFailures.setText("x" + max);
            }
            int connStarsMin = Math.min(ConnectionSwitch.getStarsForNLStats(local), ConnectionSwitch.getStarsForNLStats(remote));
            this.cswitch.setStars(connStarsMin);
        }
    }

    private void loadStats(NodeLinkStats stat, JLabel connection, JLabel failures) {
        System.out.println("[TuneDialog] Loading stats...");
        if (stat == null) {
            failures.setText("-");
            failures.setIcon(ImageLoader.getImageIcon((String)"images/svg/bulbs/bulb-grey.svg,32"));
            connection.setIcon(new NStarsIcon(0, 5));
            connection.setText("-");
            this.repaint();
            return;
        }
        failures.setText(stat.diedTimes + " (" + Language.get("RUNNING_FOR") + " " + this.etf.getFormattedTime(stat.currentTime - stat.sessionStarted) + ")");
        if (stat.diedTimes < 4L) {
            failures.setIcon(ImageLoader.getImageIcon((String)"images/svg/bulbs/bulb-green.svg,32"));
        } else if (stat.diedTimes < 8L) {
            failures.setIcon(ImageLoader.getImageIcon((String)"images/svg/bulbs/bulb-yellow.svg,32"));
        } else {
            failures.setIcon(ImageLoader.getImageIcon((String)"images/svg/bulbs/bulb-red.svg,32"));
        }
        if (stat.type == 0) {
            connection.setIcon(new NStarsIcon(1, 5));
            connection.setText("HTTP (" + Language.get("POOR") + ")");
        } else if (stat.type == 1) {
            connection.setIcon(new NStarsIcon(3, 5));
            connection.setText("TCP/SSL (" + Language.get("ACCEPTABLE") + ")");
        } else if (stat.type == 2) {
            connection.setIcon(new NStarsIcon(3, 5));
            connection.setText("TCP (" + Language.get("ACCEPTABLE") + ")");
        } else if (stat.type == 5) {
            connection.setIcon(new NStarsIcon(3, 5));
            connection.setText("TCP/" + Language.get("PROXIED") + " (" + Language.get("ACCEPTABLE") + ")");
        } else if (stat.type == 3) {
            connection.setIcon(new NStarsIcon(4, 5));
            connection.setText(Language.get("SESSION_UDP_VIA_SERVER") + " (" + Language.get("GOOD") + ")");
        } else if (stat.type == 4) {
            connection.setIcon(new NStarsIcon(5, 5));
            connection.setText(Language.get("SESSION_UDP_DIRECT") + " (" + Language.get("EXCELLENT") + ")");
        } else {
            connection.setIcon(new NStarsIcon(0, 5));
            connection.setText(Language.get("UNKNOWN") + " (" + stat.type + ")");
        }
        this.repaint();
    }

    private void saveSettings() {
        System.out.println("Saving tuning settings");
        this.con.sendSessionPerformanceSlice();
        if (this.fil_large.isSelected()) {
            SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_FILTERING, "large");
            this.con.setFiltering(51);
        } else {
            SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_FILTERING, "small");
            this.con.setFiltering(52);
        }
        if (this.col.isSelected()) {
            SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_COLOUR, "on");
        } else {
            SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_COLOUR, "off");
        }
        int depth = this.slid.getValue();
        if (depth == 21) {
            SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_COLDEPTH, "255");
            this.con.setColourDepth(255);
        } else {
            SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_COLDEPTH, "" + depth);
            this.con.setColourDepth(depth);
        }
        SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_UPDATEDELAY, "" + this.fpsSlider.getAppropriateDelay());
        this.con.setUpdateDelay(this.fpsSlider.getAppropriateDelay());
        SessionProperties.INSTANCE.save();
    }

    private void initEventHandling() {
        this.button_ok.addActionListener(this);
        this.button_ok.addKeyListener(this);
    }

    private void updateEnabled() {
        int depth = this.slid.getValue();
        if (depth == 21) {
            this.shades.setText(Language.get("FULL_COLOUR"));
        } else {
            this.shades.setText(depth + " " + Language.get("COLOR_SHADES"));
        }
        this.ic_img.setColour(this.col.isSelected());
        this.ic_ui.setColour(this.col.isSelected());
        this.ic_text.setColour(this.col.isSelected());
        int shades = this.slid.getValue();
        if (shades == 21) {
            shades = 256;
        }
        this.ic_img.setShades(shades);
        this.ic_ui.setShades(shades);
        this.ic_text.setShades(shades);
        this.shades.repaint();
        this.ex_img.updateUI();
        this.ex_img.repaint();
        this.ex_ui.updateUI();
        this.ex_ui.repaint();
        this.ex_text.repaint();
        this.fricon.update(this.fpsSlider.getAppropriateDelay());
    }

    private void setEnabled(boolean b) {
        this.button_ok.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.more) {
            SHWebsiteURLUtil.launchConnInfoPage();
        } else if (o == this.button_ok) {
            this.setVisible(false);
            this.setVisible(false);
            this.saveSettings();
        } else if (o == this.col || o == this.bw) {
            this.updateEnabled();
        } else if (o == this.switchLocal) {
            if (this.selectedType != -1) {
                int local = this.getSelectedTransport();
                int remote = this.getTransportForStats(this.rstat);
                System.out.println("Attempting to upgrade local transport (" + local + "/" + remote + ")");
                new TransportSwitchThread(local, remote);
            }
        } else if (o == this.saveDefaults) {
            int local = this.getTransportForStats(this.lstat);
            int remote = this.getTransportForStats(this.rstat);
            this.con.getConnectedMachinePrefs().setDesiredTransports(local, remote);
            this.saveDefaults.setEnabled(false);
        } else if (o == this.switchRemote) {
            if (this.selectedType != -1) {
                int local = this.getTransportForStats(this.lstat);
                int remote = this.getSelectedTransport();
                System.out.println("Attempting to upgrade remote transport (" + local + "/" + remote + ")");
                new TransportSwitchThread(local, remote);
            }
        } else if (o == this.switchBoth && this.selectedType != -1) {
            int local;
            int remote = local = this.getSelectedTransport();
            System.out.println("Attempting to upgrade both transports (" + local + "/" + remote + ")");
            new TransportSwitchThread(local, remote);
        }
    }

    private int getTransportForStats(NodeLinkStats stats) {
        if (stats.type == 0) {
            return 4;
        }
        if (stats.type == 1) {
            return 3;
        }
        if (stats.type == 2) {
            return 2;
        }
        return -1;
    }

    private int getSelectedTransport() {
        if (this.selectedType == 0) {
            return 0;
        }
        if (this.selectedType == 1) {
            return 1;
        }
        if (this.selectedType == 2) {
            return 2;
        }
        if (this.selectedType == 3) {
            return 3;
        }
        if (this.selectedType == 4) {
            return 4;
        }
        return -1;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.updateEnabled();
    }

    @Override
    public void notificationClosed(int returnCode) {
    }

    @Override
    public void response(Message m) {
        this.rstat = NodeLinkStats.fromBytes((byte[])m.get(0));
        if (this.sdemoControls) {
            System.out.println("NL Stats: " + this.rstat);
            this.loadStats(this.rstat, this.techConnection, this.techFailures);
        } else {
            System.out.println("Remote NL Stats: " + this.rstat);
            this.loadStats(this.rstat, this.custConnection, this.custFailures);
        }
        if (Switches.SH_1563_singlePaneTuneDialog) {
            this.loadAllStats(this.con.getLocalSessionStats(), this.rstat);
        }
        this.sessionTypeSelected(this.sessionTypes.getSelectedIndex());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.sessionTypes) {
            this.sessionTypeSelected(this.sessionTypes.getSelectedIndex());
        }
    }

    private void sessionTypeSelected(int index) {
        if (index < 0) {
            return;
        }
        this.selectedType = index;
        this.sessionHeader.setText(this.sessionHeaders[index]);
        this.sessionHeader.setIcon(this.sessionIcons[index]);
        this.sessionDetail.setText(this.sessionDetails[index]);
        if (index == 0 || index == 1) {
            if (this.canUseUDP) {
                this.switchBoth.setEnabled(true);
                this.switchLocal.setEnabled(false);
                this.switchRemote.setEnabled(false);
            } else {
                this.switchBoth.setEnabled(false);
                this.switchLocal.setEnabled(false);
                this.switchRemote.setEnabled(false);
            }
        } else {
            this.switchBoth.setEnabled(true);
            this.switchLocal.setEnabled(true);
            this.switchRemote.setEnabled(true);
        }
        this.sessionHeader.repaint();
        this.sessionDetail.repaint();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame((boolean)true);
        Language.loadTranslations();
        frame.setSize(700, 600);
        frame.setVisible(true);
        TuneDialog dialog = new TuneDialog(null, (RootPaneContainer)frame, null, false, 500L);
        dialog.techConnection.setIcon(new NStarsIcon(4, 5));
        dialog.techConnection.setText(Language.get("SESSION_UDP_VIA_SERVER") + " (" + Language.get("GOOD") + ")");
        dialog.techConnection.repaint();
        dialog.setVisible(true);
        Thread.sleep(1000L);
    }

    private class ConnectionStatsThread
    extends Thread {
        private ConnectionStatsThread() {
        }

        @Override
        public void run() {
            TuneDialog.this.con.getRemoteSessionStats(TuneDialog.this);
        }
    }

    class TransportSwitchThread
    extends Thread {
        final int local;
        final int remote;

        public TransportSwitchThread(int local, int remote) {
            this.local = local;
            this.remote = remote;
            this.start();
        }

        @Override
        public void run() {
            boolean worked = false;
            TuneDialog.this.setVisible(false);
            TuneDialog.this.gui.upgradeStarted(this.local, this.remote);
            if (TuneDialog.this.con.switchTransports(this.local, this.remote)) {
                TuneDialog.this.gui.upgradeComplete();
                worked = true;
            } else {
                TuneDialog.this.gui.upgradeFailed(false);
            }
            TuneDialog.this.updateStats();
            TuneDialog.this.updateEnabled();
            if (worked) {
                TuneDialog.this.saveDefaults.setEnabled(true);
            }
        }
    }
}

