/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.nodelink.NodeLinkStats;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.message.Message;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.SHNakedComboBox;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHComboBoxUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.listeners.SystemExitWindowListener;

public class SimpleTunePanel
extends ColorPropagatingGBPanel
implements ActionListener {
    private static final int FPS_1 = 1000;
    private static final int FPS_7 = 142;
    private static final int FPS_22 = 45;
    private static final int FPS_MAX = 0;
    private static final String[] CONNECTION_TYPES = new String[]{Language.get("CONNTYPE_HTTP"), Language.get("CONNTYPE_TCP"), Language.get("CONNTYPE_SUDP"), Language.get("CONNTYPE_DTCP"), Language.get("CONNTYPE_DUDP")};
    GUI gui;
    ClientController con;
    boolean hideType;
    CircularProgressLabel colors_work;
    CircularProgressLabel updates_work;
    CircularProgressLabel types_work;
    JToggleButton pintype;
    SHNakedComboBox colors = new SHNakedComboBox();
    SHNakedComboBox updates = new SHNakedComboBox();
    SHNakedComboBox types = new SHNakedComboBox();
    boolean disableControls = false;

    public SHNakedComboBox getTypes() {
        return this.types;
    }

    public SimpleTunePanel(ClientController con, GUI gui, boolean hideType) {
        this.con = con;
        this.gui = gui;
        this.hideType = hideType;
        this.init();
    }

    public void setTechGroupPermissions(TechGroupPermissions permissions) {
        if (permissions != null && !permissions.canUseUDP()) {
            this.types.removeItem(CONNECTION_TYPES[2]);
            this.types.removeItem(CONNECTION_TYPES[4]);
        }
    }

    public void setEnabled(boolean b) {
        this.colors.setEnabled(b);
        this.pintype.setEnabled(b);
        this.updates.setEnabled(b);
        this.types.setEnabled(b);
    }

    public void init() {
        this.colors.setRenderer(new ComboRenderer());
        this.updates.setRenderer(new ComboRenderer());
        this.types.setRenderer(new ComboRenderer());
        this.colors_work = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.colors_work.getInfinite().switchOff();
        this.updates_work = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.updates_work.getInfinite().switchOff();
        this.types_work = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.types_work.getInfinite().switchOff();
        this.colors_work.setVisible(false);
        this.updates_work.setVisible(false);
        this.types_work.setVisible(false);
        this.colors.addItem(Language.get("COL_LOW"));
        this.colors.addItem(Language.get("COL_MEDIUM"));
        this.colors.addItem(Language.get("COL_HIGH"));
        this.colors.addItem(Language.get("COL_FULL"));
        this.updates.addItem(Language.get("UPDATES_MINIMAL"));
        this.updates.addItem(Language.get("UPDATES_LOW"));
        this.updates.addItem(Language.get("UPDATES_HIGH"));
        this.updates.addItem(Language.get("UPDATES_MAX"));
        for (String item : CONNECTION_TYPES) {
            this.types.addItem(item);
        }
        this.colors.setSelectedIndex(3);
        this.updates.setSelectedIndex(3);
        this.types.setSelectedIndex(1);
        JLabel l_colors = new JLabel(Language.get("COLOR_FIDELITY"));
        JLabel l_updates = new JLabel(Language.get("UPDATE_RATE"));
        JLabel l_types = new JLabel(Language.get("CONNECTION_TYPE"));
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.colors, this.updates, this.types});
        ScaledInsets noindent = new ScaledInsets(5, 0, 5, 0);
        ScaledInsets indent = new ScaledInsets(2, 2, 0, 0);
        SwingUtil.setHeight((JComponent)this.colors, (int)SimpleHelpLookAndFeel.scale((int)24));
        SwingUtil.setHeight((JComponent)this.types, (int)SimpleHelpLookAndFeel.scale((int)24));
        SwingUtil.setHeight((JComponent)this.updates, (int)SimpleHelpLookAndFeel.scale((int)24));
        this.pintype = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/pin.svg,16"), false);
        int N = 0;
        this.add(l_colors, 0, N, 1, 1, 1, 0, 17, 0, (Insets)noindent);
        this.add((Component)this.colors_work, 1, N++, 1, 1, 0, 0, 13, 0, (Insets)indent);
        this.add(this.colors, 0, N++, 2, 1, 1, 0, 17, 1);
        this.add(l_updates, 0, N, 1, 1, 1, 0, 17, 0, (Insets)noindent);
        this.add((Component)this.updates_work, 1, N++, 1, 1, 0, 0, 13, 0, (Insets)indent);
        this.add(this.updates, 0, N++, 2, 1, 1, 0, 17, 1);
        if (!this.hideType) {
            this.add(l_types, 0, N, 1, 1, 1, 0, 17, 0, (Insets)noindent);
            this.add((Component)this.types_work, 1, N++, 1, 1, 0, 0, 13, 0, (Insets)indent);
            this.add(this.types, 0, N, 1, 1, 1, 0, 17, 1);
            this.add(this.pintype, 1, N++, 1, 1, 0, 0, 17, 0);
        }
        SHComboBoxUI.makeComboSegmentedCenter((JComboBox)this.types);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.pintype);
        SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.colors, this.updates, this.types, this.pintype, this.colors_work, this.updates_work, this.types_work});
        this.colors.addActionListener(this);
        this.updates.addActionListener(this);
        this.types.addActionListener(this);
        this.pintype.addActionListener(this);
    }

    private int getTransportForStats(NodeLinkStats stats) {
        if (stats.type == 0) {
            return 4;
        }
        if (stats.type == 1) {
            return 3;
        }
        if (stats.type == 2) {
            return 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            int transport;
            this.disableControls = true;
            this.colors_work.getCircular().switchOff();
            this.updates_work.getCircular().switchOff();
            this.types_work.getCircular().switchOff();
            this.colors_work.setVisible(false);
            this.updates_work.setVisible(false);
            this.types_work.setVisible(false);
            if (this.con == null) {
                return;
            }
            int depth = this.con.getColourDepth();
            if (depth > 254) {
                this.colors.setSelectedIndex(3);
            } else if (depth > 9) {
                this.colors.setSelectedIndex(2);
            } else if (depth > 5) {
                this.colors.setSelectedIndex(1);
            } else {
                this.colors.setSelectedIndex(0);
            }
            int ms = this.con.getUpdateDelay(false);
            if (ms >= 1000) {
                this.updates.setSelectedIndex(0);
            } else if (ms < 5) {
                this.updates.setSelectedIndex(3);
            } else if (ms >= 142) {
                this.updates.setSelectedIndex(1);
            } else {
                this.updates.setSelectedIndex(2);
            }
            NodeLinkStats stats = this.con.getLocalSessionStats();
            if (stats != null) {
                if (stats.type == 0) {
                    this.types.setSelectedItem(CONNECTION_TYPES[0]);
                } else if (stats.type == 1 || stats.type == 2) {
                    this.types.setSelectedItem(CONNECTION_TYPES[1]);
                } else if (stats.type == 3) {
                    this.types.setSelectedItem(CONNECTION_TYPES[2]);
                } else if (stats.type == 7) {
                    this.types.setSelectedItem(CONNECTION_TYPES[3]);
                } else if (stats.type == 4) {
                    this.types.setSelectedItem(CONNECTION_TYPES[4]);
                } else {
                    this.types.setSelectedItem(CONNECTION_TYPES[1]);
                }
            }
            if ((transport = SessionProperties.INSTANCE.getIntProp(SessionProperties.PROP_PINNED_CONN, -1, -99, 99)) == -1) {
                this.pintype.setSelected(false);
            } else {
                this.pintype.removeActionListener(this);
                this.pintype.setSelected(true);
                this.pintype.addActionListener(this);
            }
        }
        finally {
            this.disableControls = false;
        }
    }

    public static void showDialog(RootPaneContainer rpc, ClientController con, GUI gui) {
        SimpleTunePanel stp = new SimpleTunePanel(con, gui, false);
        AbstractGlassDialog dialog = SHGlassOptionPane.showBorderlessDialog((RootPaneContainer)rpc, (JComponent)((Object)stp), (String)Language.get("CONNECTION_TUNING_TITLE"), (int)500);
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setBounds(0, 0, 800, 800);
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new SystemExitWindowListener());
        SimpleTunePanel.showDialog((RootPaneContainer)frame, null, null);
        TechGroupPermissions permissions = new TechGroupPermissions();
        permissions.setCanUseUDP(false);
        SimpleTunePanel stp = new SimpleTunePanel(null, null, false);
        stp.setTechGroupPermissions(permissions);
        AbstractGlassDialog dialog = SHGlassOptionPane.showBorderlessDialog((RootPaneContainer)frame, (JComponent)((Object)stp), (String)Language.get("CONNECTION_TUNING_TITLE"), (int)500);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.disableControls) {
            return;
        }
        Object o = e.getSource();
        if (o == this.colors) {
            new ColorUpdateThread().start();
        } else if (o == this.updates) {
            new UpdatesUpdateThread().start();
        } else if (o == this.types) {
            this.pintype.removeActionListener(this);
            this.pintype.setSelected(false);
            this.pintype.addActionListener(this);
            new TypesUpdateThread().start();
        } else if (o == this.pintype) {
            String selectedItem;
            int transport = -1;
            if (this.pintype.isSelected() && (selectedItem = (String)this.types.getSelectedItem()) != null) {
                if (selectedItem.equals(CONNECTION_TYPES[0])) {
                    transport = 4;
                } else if (selectedItem.equals(CONNECTION_TYPES[1])) {
                    transport = 2;
                } else if (selectedItem.equals(CONNECTION_TYPES[2])) {
                    transport = 1;
                } else if (selectedItem.equals(CONNECTION_TYPES[3])) {
                    transport = 5;
                } else if (selectedItem.equals(CONNECTION_TYPES[4])) {
                    transport = 0;
                }
            }
            new ConnectionPinThread(transport).start();
        }
    }

    private class ColorUpdateThread
    extends Thread
    implements CommandResponseListener {
        private ColorUpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTunePanel.this.colors_work.getCircular().switchOn();
                    SimpleTunePanel.this.colors_work.setVisible(true);
                }
            });
            try {
                SimpleTunePanel.this.con.sendSessionPerformanceSlice();
                int index = SimpleTunePanel.this.colors.getSelectedIndex();
                int coldepth = 16;
                if (index == 0) {
                    coldepth = 5;
                } else if (index == 1) {
                    coldepth = 9;
                } else if (index == 2) {
                    coldepth = 16;
                } else if (index == 3) {
                    coldepth = 255;
                }
                SimpleTunePanel.this.con.setColourDepth(coldepth);
                SessionProperties.INSTANCE.setPropAndSave(SessionProperties.PROP_COLDEPTH, "" + coldepth);
                Message m = new Message(-1061158894);
                SimpleTunePanel.this.con.doAsyncRemoteCommand(this, m);
                SimpleTunePanel.this.con.sendSessionPerformanceSlice();
            }
            finally {
                this.response(null);
            }
        }

        @Override
        public void response(Message mayBeNull) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTunePanel.this.colors_work.getCircular().switchOff();
                    SimpleTunePanel.this.colors_work.setVisible(false);
                    if (SimpleTunePanel.this.gui != null) {
                        SimpleTunePanel.this.gui.updateSessionStats();
                    }
                }
            });
        }
    }

    class ComboRenderer
    extends DefaultListCellRenderer {
        private JLabel label1 = new JLabel();
        private JLabel label2 = new JLabel();
        private BorderPanel panel = new BorderPanel();

        public ComboRenderer() {
            this.panel.addCenter((JComponent)this.label1);
            this.panel.addEast((JComponent)this.label2);
            this.panel.setOpaque(false);
            this.label2.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
            SwingUtil.setHeight((JComponent)this.panel, (int)SimpleHelpLookAndFeel.scale((int)20));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            SwingUtil.setHeight((JComponent)label, (int)SimpleHelpLookAndFeel.scale((int)20));
            label.setFont(SHStyle.normalFont);
            String text = label.getText();
            int stop = text.indexOf(40);
            if (stop == -1) {
                label.setOpaque(isSelected);
                return label;
            }
            String begin = text.substring(0, stop).trim();
            String end = text.substring(stop + 1, text.lastIndexOf(41)).trim();
            this.label1.setText(begin);
            this.label1.setFont(label.getFont());
            this.label1.setBackground(label.getBackground());
            this.label1.setOpaque(isSelected);
            this.label1.setForeground(label.getForeground());
            this.label2.setText(end + " ");
            this.label2.setFont(label.getFont());
            this.label2.setBackground(label.getBackground());
            this.label2.setOpaque(isSelected);
            if (isSelected) {
                this.label2.setForeground(Color.WHITE);
            } else {
                this.label2.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
            }
            return this.panel;
        }
    }

    private class ConnectionPinThread
    extends Thread {
        int type;

        public ConnectionPinThread(int type) {
            this.type = type;
        }

        @Override
        public void run() {
            SessionProperties.INSTANCE.setPropAndSave(SessionProperties.PROP_PINNED_CONN, this.type + "");
        }
    }

    private class TypesUpdateThread
    extends Thread
    implements CommandResponseListener {
        int transport;
        boolean success = true;

        private TypesUpdateThread() {
        }

        @Override
        public void run() {
            if (SimpleTunePanel.this.con != null) {
                SimpleTunePanel.this.con.sendSessionPerformanceSlice();
            }
            this.transport = 2;
            String item = (String)SimpleTunePanel.this.types.getSelectedItem();
            if (item == null) {
                this.transport = 2;
            } else if (item.equals(CONNECTION_TYPES[0])) {
                this.transport = 4;
            } else if (item.equals(CONNECTION_TYPES[1])) {
                this.transport = 2;
            } else if (item.equals(CONNECTION_TYPES[2])) {
                this.transport = 1;
            } else if (item.equals(CONNECTION_TYPES[3])) {
                this.transport = 5;
            } else if (item.equals(CONNECTION_TYPES[4])) {
                this.transport = 0;
            }
            System.out.println("[SimpleTunePanel] Requesting transport switch to " + this.transport);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTunePanel.this.types_work.getCircular().switchOn();
                    SimpleTunePanel.this.types_work.setVisible(true);
                    if (SimpleTunePanel.this.gui != null) {
                        SimpleTunePanel.this.gui.upgradeStarted(TypesUpdateThread.this.transport, TypesUpdateThread.this.transport);
                    }
                }
            });
            try {
                this.success = SimpleTunePanel.this.con.switchTransports(this.transport, this.transport);
                Message m = new Message(-1061158894);
                SimpleTunePanel.this.con.doAsyncRemoteCommand(this, m);
                SimpleTunePanel.this.con.sendSessionPerformanceSlice();
            }
            finally {
                this.response(null);
            }
        }

        @Override
        public void response(Message mayBeNull) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTunePanel.this.types_work.getCircular().switchOff();
                    SimpleTunePanel.this.types_work.setVisible(false);
                    if (SimpleTunePanel.this.gui != null) {
                        if (TypesUpdateThread.this.success) {
                            SimpleTunePanel.this.gui.upgradeComplete();
                        } else {
                            SimpleTunePanel.this.gui.upgradeFailed(false);
                        }
                        SimpleTunePanel.this.gui.updateSessionStats();
                    }
                }
            });
        }
    }

    private class UpdatesUpdateThread
    extends Thread
    implements CommandResponseListener {
        private UpdatesUpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTunePanel.this.updates_work.getCircular().switchOn();
                    SimpleTunePanel.this.updates_work.setVisible(true);
                }
            });
            try {
                SimpleTunePanel.this.con.sendSessionPerformanceSlice();
                int index = SimpleTunePanel.this.updates.getSelectedIndex();
                int delay = 45;
                if (index == 0) {
                    delay = 1000;
                } else if (index == 1) {
                    delay = 142;
                } else if (index == 2) {
                    delay = 45;
                } else if (index == 3) {
                    delay = 0;
                }
                SessionProperties.INSTANCE.setPropAndSave(SessionProperties.PROP_UPDATEDELAY, "" + delay);
                SimpleTunePanel.this.con.setUpdateDelay(delay);
                Message m = new Message(-1061158894);
                SimpleTunePanel.this.con.doAsyncRemoteCommand(this, m);
                SimpleTunePanel.this.con.sendSessionPerformanceSlice();
            }
            finally {
                this.response(null);
            }
        }

        @Override
        public void response(Message mayBeNull) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTunePanel.this.updates_work.getCircular().switchOff();
                    SimpleTunePanel.this.updates_work.setVisible(false);
                    if (SimpleTunePanel.this.gui != null) {
                        SimpleTunePanel.this.gui.updateSessionStats();
                    }
                }
            });
        }
    }
}

