/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.shelp.common.Language;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.RootPaneContainer;
import utils.ostools.OSDirs;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.FileChooserField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class ShortcutUI
extends OKCancelDialogPanel
implements AbstractField.ChangeListener {
    private String cardName = null;
    private String saveToDir = null;
    private FileChooserField fileChooserField;
    private FixedWidthCUIPanel cuiPanel;

    public ShortcutUI() {
        super(Language.get("SHORTCUT_OK"), Language.get("CANCEL"));
        this.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/star.svg,48"));
        this.setTitle(Language.get("SHORTCUT_DESCRIPTION"), false);
    }

    public void showDialog(RootPaneContainer rootPane) {
        this.cuiPanel = new FixedWidthCUIPanel();
        this.addFields();
        this.setContent((FixedWidthComponent)this.cuiPanel);
        AbstractGlassDialog dialog = new AbstractGlassDialog(rootPane, 450, (AbstractDialogPanel)this);
        dialog.setTitle(Language.get("SHORTCUT_TITLE"));
        dialog.showDialog();
        ResultPair[] filledOutResults = this.cuiPanel.getResults((ResourceBundle)Language.DEFLANG);
        this.cardName = filledOutResults[0].getValue();
        this.saveToDir = filledOutResults[1].getValue();
    }

    protected void addFields() {
        TextField cardName = new TextField(Language.get("SHORTCUT_NAME"), (AbstractField.ChangeListener)this);
        cardName.setRequired(true);
        this.fileChooserField = new FileChooserField(Language.get("SHORTCUT_LOCATION"), null, null);
        this.fileChooserField.setDefaultFile(OSDirs.getDesktopDir().getAbsolutePath());
        this.fileChooserField.setTransientButtonImage(ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
        this.cuiPanel.setFields(new CUIField[]{cardName, this.fileChooserField});
    }

    public String getCardName() {
        return this.cardName;
    }

    public String getSaveToDir() {
        return this.saveToDir;
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(550, 330);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        ShortcutUI ui = new ShortcutUI();
        ui.showDialog((RootPaneContainer)frame);
        System.out.println(ui.isOK());
        System.out.println(ui.getCardName());
        System.out.println(ui.getSaveToDir());
    }

    protected boolean isValid() {
        return this.cuiPanel.isValid();
    }

    public void changed(AbstractField source) {
        this.setOkEnabled(this.isValid());
    }
}

