/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.client.gui.FileTransferPanel;
import com.aem.sdesktop.client.gui.ftp.FileTransferJob;
import com.aem.sdesktop.client.gui.ftp.JobStatus;
import com.aem.sdesktop.interfaces.ClientController;
import java.io.File;
import java.util.ArrayList;

public class ModifiedUpdater
extends Thread {
    FileTransferPanel ftp;
    ClientController con;
    String ldir;
    String rdir;
    String[] lfiles;
    long[] lastsynced;
    boolean[] mustsend;
    ArrayList status;
    JobStatus mystatus;

    public ModifiedUpdater(FileTransferPanel ftp, ClientController con, JobStatus mystatus, String ldir, String rdir, String[] lfiles, ArrayList status) {
        this.ftp = ftp;
        this.con = con;
        this.mystatus = mystatus;
        this.ldir = ldir;
        this.rdir = rdir;
        this.lfiles = lfiles;
        this.status = status;
        this.lastsynced = new long[lfiles.length];
        this.mustsend = new boolean[lfiles.length];
        this.start();
    }

    @Override
    public void run() {
        int done;
        this.mystatus.status = 0;
        this.ftp.updateJobsTable();
        while (true) {
            done = 0;
            for (int i = 0; i < this.status.size(); ++i) {
                FileTransferJob js = (FileTransferJob)this.status.get(i);
                if (js.getJobStatus().status != 2) continue;
                ++done;
            }
            if (done == this.status.size()) break;
            System.out.println("Mirror Updater: " + done + "/" + this.status.size() + " jobs done, still waiting");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception i) {}
        }
        System.out.println("Mirror Updater: " + done + "/" + this.status.size() + " jobs done, mirroring now");
        for (int i = 0; i < this.lastsynced.length; ++i) {
            this.lastsynced[i] = System.currentTimeMillis();
            this.mustsend[i] = false;
        }
        this.mystatus.status = 1;
        this.ftp.updateJobsTable();
        while (this.mystatus.status != 2) {
            if (this.mystatus.status != 3 && this.mystatus.status != 2) {
                System.out.println("Mirror Updater: mystatus transferring, checking modtimes");
                for (int i = 0; i < this.lfiles.length; ++i) {
                    long time = this.getMostRecentModTime(new File(this.ldir + "/" + this.lfiles[i]));
                    if (time > this.lastsynced[i]) {
                        this.lastsynced[i] = time;
                        this.mustsend[i] = true;
                        continue;
                    }
                    if (!this.mustsend[i]) continue;
                    this.mustsend[i] = false;
                    System.out.println("Mirror Updater: Mirroring " + this.lfiles[i]);
                    this.ftp.doPut(this.ldir, this.rdir, this.lfiles[i]);
                    ++this.mystatus.files;
                    this.ftp.updateJobsTable();
                }
            } else {
                System.out.println("Mirror Updater: mystatus not transferring, skipping checks");
            }
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {}
        }
        System.out.println("Mirror Updater: mystatus set to DONE, finishing");
    }

    private long getMostRecentModTime(File f) {
        try {
            if (f.isDirectory()) {
                long modmax = 0L;
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    modmax = Math.max(modmax, this.getMostRecentModTime(files[i]));
                }
                return modmax;
            }
            return f.lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

