/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.nodelink.NodeLinkStats;
import com.aem.sdesktop.client.gui.ConnectionSwitchListener;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.shelp.util.NStarsIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import utils.switches.Switches;

public class ConnectionSwitch
implements MouseListener,
MouseMotionListener {
    ClientUserInterface gui;
    ClientController controller;
    ConnectionSwitchListener listener;
    NStarsIcon stars = new NStarsIcon(0, 5);
    JLabel connRating;
    boolean canUseUDP;

    public ConnectionSwitch(boolean canUseUDP, ClientUserInterface gui, ClientController controller) {
        this.canUseUDP = canUseUDP;
        this.gui = gui;
        this.controller = controller;
        this.connRating = new JLabel(this.stars);
        this.connRating.addMouseListener(this);
        this.connRating.addMouseMotionListener(this);
    }

    public void setListener(ConnectionSwitchListener listener) {
        this.listener = listener;
    }

    public JLabel getLabel() {
        return this.connRating;
    }

    public void repaint() {
        this.connRating.repaint();
    }

    public void setEnabled(boolean b) {
        this.connRating.setEnabled(b);
    }

    public static int getStarsForNLStats(NodeLinkStats stat) {
        if (stat.type == 0) {
            if (Switches.SH_1566_prioritiseTransportHttpOverSsl) {
                return 2;
            }
            if (Switches.SH_1566_disableSslTransport) {
                return 2;
            }
            return 1;
        }
        if (stat.type == 1) {
            if (Switches.SH_1566_prioritiseTransportHttpOverSsl) {
                return 1;
            }
            return 2;
        }
        if (stat.type == 2) {
            return 3;
        }
        if (stat.type == 5) {
            return 3;
        }
        if (stat.type == 3) {
            return 4;
        }
        if (stat.type == 4) {
            return 5;
        }
        return 0;
    }

    public void setStars(int connStarsMin) {
        boolean isEnabled = this.connRating.isEnabled();
        NStarsIcon nStarsIcon = isEnabled ? new NStarsIcon(connStarsMin, 5) : new NStarsIcon(0, 5);
        this.stars = nStarsIcon;
        this.connRating.setIcon(this.stars);
        this.connRating.setDisabledIcon(this.stars);
        this.connRating.setToolTipText(null);
    }

    public void setCanUseUDP(boolean b) {
        this.canUseUDP = b;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.stars.highlightStar(-1);
        this.connRating.repaint();
        if (this.listener != null) {
            this.listener.switchReset();
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.stars.highlightStar(-1);
        this.connRating.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double x = e.getX();
        double width = this.connRating.getWidth();
        int index = (int)(x / (width / 5.0));
        this.stars.dimStar(index);
        this.connRating.repaint();
        if (Switches.SH_1566_disableSslTransport && index == 1) {
            index = 0;
        } else if (Switches.SH_1566_prioritiseTransportHttpOverSsl) {
            if (index == 0) {
                index = 1;
            } else if (index == 1) {
                index = 0;
            }
        }
        if (index == 0) {
            System.out.println("HTTP");
            new TransportSwitchThread(4, 4);
        } else if (index == 1) {
            System.out.println("SSL");
            new TransportSwitchThread(3, 3);
        } else if (index == 2) {
            System.out.println("TCP");
            new TransportSwitchThread(2, 2);
        } else if (index == 3 && this.canUseUDP) {
            System.out.println("PX UDP");
            new TransportSwitchThread(1, 1);
        } else if (index == 4 && this.canUseUDP) {
            System.out.println("DX UDP");
            new TransportSwitchThread(0, 0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        double x = e.getX();
        double width = this.connRating.getWidth();
        int index = (int)(x / (width / 5.0));
        this.stars.highlightStar(index);
        if (Switches.SH_1566_prioritiseTransportHttpOverSsl) {
            if (index == 0) {
                index = 1;
            } else if (index == 1) {
                index = 0;
            }
        }
        if (this.listener != null) {
            int type = 0;
            if (index == 0) {
                type = Switches.SH_1566_prioritiseTransportHttpOverSsl ? 1 : 0;
            } else if (index == 1) {
                type = Switches.SH_1566_prioritiseTransportHttpOverSsl ? 0 : (Switches.SH_1566_disableSslTransport ? 0 : 1);
            } else if (index == 2) {
                type = 2;
            } else if (index == 3) {
                type = 3;
            } else if (index == 4) {
                type = 4;
            }
            this.listener.switchHover(type);
        }
        this.connRating.repaint();
    }

    class TransportSwitchThread
    extends Thread {
        int local;
        int remote;

        public TransportSwitchThread(int local, int remote) {
            this.local = local;
            this.remote = remote;
            this.start();
        }

        @Override
        public void run() {
            ConnectionSwitch.this.gui.switchTransports(this.local, this.remote);
        }
    }
}

