/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import utils.swing.SafeDialogIcon;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.jdialog.AbstractDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.images.ImageLoader;

public class CloseSessionDialog
implements ActionListener {
    private final AbstractDialog dialog;
    private boolean okPressed = false;
    private boolean lockPressed = false;
    private static final int width = 370;
    private static final String okButton = Language.get("CLOSE_SESSION");
    private static final String cancelButton = Language.get("CANCEL");
    private static final String lockButton = Language.get("CLOSE_SESSION_LOCK");

    public CloseSessionDialog(JFrame owner, boolean showLockOption) {
        AbstractDialogPanel adp = new AbstractDialogPanel();
        adp.addRightButton(okButton, true, (ActionListener)this);
        if (showLockOption) {
            adp.addRightButton(lockButton, false, (ActionListener)this);
        }
        adp.addLeftButton(cancelButton, false, (ActionListener)this);
        adp.setTitle(Language.get("CONFIRM_CLOSE_TITLE"), true);
        FixedWidthLabel label = new FixedWidthLabel(Language.get("CONFIRM_CLOSE"));
        adp.setContent((FixedWidthComponent)label);
        if (!showLockOption) {
            this.lockPressed = true;
        }
        adp.setIcon(ImageLoader.getImageIcon((String)Icons.TECHHELPUI_CLOSE_WARNING));
        this.dialog = new AbstractDialog((Frame)owner, 370, adp);
        SafeDialogIcon.setDialogIcon((Dialog)this.dialog, ClientBranding.get().getLogo32(true));
        this.dialog.setTitle(Language.get("CONFIRM_CLOSE_TITLE"));
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.setModal(true);
        this.dialog.showDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (((JButton)e.getSource()).getText().equals(okButton)) {
            this.okPressed();
        }
        if (((JButton)e.getSource()).getText().equals(lockButton)) {
            this.lockPressed();
        } else {
            this.cancelPressed();
        }
    }

    private void okPressed() {
        this.okPressed = true;
        this.dialog.setVisible(false);
    }

    private void lockPressed() {
        this.lockPressed = true;
        this.dialog.setVisible(false);
    }

    protected void cancelPressed() {
        this.dialog.setVisible(false);
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    public boolean isLockPressed() {
        return this.lockPressed;
    }
}

