/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.aem.utils.CompressionUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.swing.Icon;
import javax.swing.RootPaneContainer;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public class ClipboardController
extends Thread
implements GC,
MSG {
    Controller controller;
    ClientUserInterface gui;
    MessageReader min;
    MessageWriter mout;
    List lastFilesSent = null;
    boolean filesWereSent = true;
    String lastStringSent = null;

    public void log(String msg, String details) {
    }

    public ClipboardController(Controller controller, ClientUserInterface gui, MessageReader min, MessageWriter mout) {
        this.controller = controller;
        this.gui = gui;
        this.min = min;
        this.mout = mout;
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            this.log("Connection terminated", "The connection to the remote machine has been terminated.");
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Clipboard Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[ClipboardController] " + e);
            }
        }
        catch (Throwable e) {
            System.out.println("(Clipboard Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    private void newClipboardFolder(String folder, String s) throws IOException {
        String orig = s;
        File f = new File(folder + s);
        f.mkdirs();
    }

    private OutputStream getClipboardStream(String folder, String s) throws IOException {
        String orig = s;
        File f = new File(folder + s);
        int n = 1;
        while (f.exists()) {
            s = n == 1 ? "Copy of " + orig : "Copy (" + n + ") of " + orig;
            f = new File(folder + s);
            ++n;
        }
        return new BufferedOutputStream(new FileOutputStream(f));
    }

    public void sendFilesAndPaste(List files) {
        try {
            this.sendFilesAndPaste(files, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendFilesAndPaste(List files, boolean paste) throws Exception {
        String[] rfiles = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            String localfile = file.getName();
            String localdir = file.getCanonicalPath();
            String remotedir = this.controller.getRemoteTempDir();
            rfiles[i] = remotedir + "/" + localfile;
            localdir = localdir.substring(0, localdir.length() - localfile.length());
            if (i == files.size() - 1) {
                if (paste) {
                    this.controller.addPutThenPasteRequest(-1, localdir, remotedir, localfile, rfiles);
                    continue;
                }
                this.controller.addPutThenClipRequest(-1, localdir, remotedir, localfile, rfiles);
                continue;
            }
            this.controller.addPutRequest(-1, localdir, remotedir, localfile);
        }
    }

    public void ignoreCurrentClipboard() {
        try {
            List files;
            this.lastFilesSent = files = ClipboardUtil.getClipboardAsFiles();
            this.filesWereSent = true;
        }
        catch (Exception x) {
            try {
                String data;
                this.lastStringSent = data = ClipboardUtil.getClipboardAsText();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean sendClipboardAndPaste() {
        return this.sendClipboard(true);
    }

    public boolean sendClipboard() {
        return this.sendClipboard(false);
    }

    private boolean sendClipboard(boolean paste) {
        try {
            List files = ClipboardUtil.getClipboardAsFiles();
            if (this.lastFilesSent != null && files.size() == this.lastFilesSent.size()) {
                boolean miss = false;
                for (int i = 0; i < files.size(); ++i) {
                    File f1 = (File)files.get(i);
                    File f2 = (File)this.lastFilesSent.get(i);
                    if (f1.getCanonicalPath().equals(f2.getCanonicalPath())) continue;
                    miss = true;
                }
                if (!miss && (this.filesWereSent || paste)) {
                    return false;
                }
            }
            this.lastFilesSent = files;
            this.lastStringSent = null;
            if (SHGlassOptionPane.showConfirmDialog((RootPaneContainer)this.gui.getParentFrame(), (String)Language.get("SEND_CLIPFILES_TO_REMOTE_MACHINE"), (String)Language.get("SEND_CLIPFILES_TO_REMOTE_MACHINE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("YES"))) {
                this.filesWereSent = true;
                this.sendFilesAndPaste(files, paste);
            } else {
                this.filesWereSent = false;
            }
        }
        catch (Exception x) {
            try {
                Message m = new Message(262160);
                if (paste) {
                    m = new Message(262161);
                }
                String data = ClipboardUtil.getClipboardAsText();
                byte[] compressedData = CompressionUtil.compressString(data, "UTF-8");
                if (this.lastStringSent != null && this.lastStringSent.equals(data)) {
                    data = null;
                }
                this.lastStringSent = null;
                m.append(compressedData);
                this.mout.write(m);
                this.gui.setTopLeftGreyOverlay(Language.get("CLIPBOARD_SENT"), 2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void fetchClipboard(boolean textOnly) {
        try {
            System.out.println("[ClipboardController] Fetch remote clipboard requested: " + textOnly);
            String[] files = new String[]{};
            if (!textOnly) {
                files = this.controller.getRemoteClipboardFiles();
            }
            if (files.length == 0) {
                System.out.println("[ClipboardController] Sending GetString request");
                Message m = new Message(262153);
                this.mout.write(m);
            } else {
                String tmpdir = System.getProperty("java.io.tmpdir");
                if (!tmpdir.endsWith(File.separator)) {
                    tmpdir = tmpdir + File.separator;
                }
                String[] localfiles = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    int end = Math.max(files[i].lastIndexOf(47), files[i].lastIndexOf(92));
                    String dir = files[i].substring(0, end + 1);
                    String file = files[i].substring(end + 1);
                    localfiles[i] = tmpdir + file;
                    if (i == files.length - 1) {
                        this.controller.addGetThenClipRequest(-1, tmpdir, dir, file, localfiles);
                        continue;
                    }
                    this.controller.addGetRequest(-1, tmpdir, dir, file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleMessage(Message m) throws IOException {
        int type = m.getType();
        if (type == 262160) {
            byte[] bytes;
            System.out.println("[ClipboardController] Handling putstring from remote machine.");
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_PUTSTRING " + m);
            }
            if ((bytes = (byte[])m.get(0)) != null) {
                System.out.println("[ClipboardServer] Got " + bytes.length + " data from the clipboard");
            } else {
                System.out.println("[ClipboardServer] Got no (null) data from the clipboard");
            }
            String data = CompressionUtil.decompressString(bytes, "UTF-8");
            if (data != null) {
                System.out.println("[ClipboardServer] Decompressed to " + data.length() + " bytes of text data.");
            } else {
                System.out.println("[ClipboardServer] Error decompressing text data from clipboard.");
            }
            ClipboardUtil.setClipboardAsText(data);
            this.gui.setTopLeftGreyOverlay(Language.get("CLIPBOARD_RECEIVED"), 2000L);
        } else if (type == 262153) {
            System.out.println("[ClipboardController] Handling getstring from remote machine.");
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_GETSTRING " + m);
            }
            try {
                String data = ClipboardUtil.getClipboardAsText();
                byte[] compressedData = CompressionUtil.compressString(data, "UTF-8");
                m = new Message(262160);
                m.append(compressedData);
                this.mout.write(m);
            }
            catch (Exception data) {}
        } else if (type == 262146) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_PACKETS_START " + m);
            }
            File savedir = new File((String)m.get(0));
            System.out.println("clipboard packets start - " + savedir);
            while (m.getType() != 262149) {
                if (m.getType() == 262147) {
                    boolean dir = false;
                    String fname = (String)m.get(0);
                    long length = (Long)m.get(1);
                    if (m.length() > 2) {
                        dir = true;
                    }
                    long written = 0L;
                    fname = fname.replace('/', File.separatorChar);
                    fname = fname.replace('\\', File.separatorChar);
                    if (dir) {
                        System.out.println("Receiving clipboard file - " + fname + " (dir)");
                    } else {
                        System.out.println("Receiving clipboard file - " + fname + " (" + length / 1024L + "k)");
                    }
                    if (dir) {
                        this.newClipboardFolder(savedir.getAbsolutePath() + File.separatorChar, fname);
                        m = this.min.read();
                        continue;
                    }
                    OutputStream fout = this.getClipboardStream(savedir.getAbsolutePath() + File.separatorChar, fname);
                    m = this.min.read();
                    long t = System.currentTimeMillis() + 300L;
                    long ct = 0L;
                    while (m.getType() == 262148) {
                        byte[] dat = (byte[])m.get(0);
                        fout.write(dat);
                        written += (long)dat.length;
                        m = this.min.read();
                        ct = System.currentTimeMillis();
                        if (ct <= t) continue;
                        t = ct + 300L;
                    }
                    fout.close();
                    continue;
                }
                if (m.getType() == 262151) {
                    String s = (String)m.get(0);
                    OutputStream fout = this.getClipboardStream(savedir.getAbsolutePath() + File.separatorChar, "remote_clipboard_data.txt");
                    fout.write(s.getBytes());
                    fout.close();
                }
                m = this.min.read();
            }
            System.out.println("clipboard packets end");
        }
    }
}

