/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import com.aem.sdesktop.VersionFiles;
import com.aem.shelp.common.AbstractBranding;
import com.aem.utils.StreamUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jwrapper.jwutils.JWSystem;
import utils.files.FileUtil;
import utils.progtools.AutoFetchURL;

public class ClientBranding
extends AbstractBranding {
    private static Future<?> brandingFuture;
    private static ExecutorService brandingExecutor;
    private static boolean brandingLoaded;
    private static ClientBranding INSTANCE;
    private static final Object LOCK;
    private static long lastModified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientBranding get() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new ClientBranding();
            }
        }
        return INSTANCE;
    }

    private static void cleanup(File tosave) {
        if (tosave.exists() && !tosave.delete()) {
            try {
                FileUtil.writeFile((File)tosave, (byte[])new byte[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFromServer(File brandingFolder, String url, String targetName, long requiredFileSize) {
        brandingFolder.mkdirs();
        File tosave = new File(brandingFolder, targetName);
        long currentLength = 0L;
        if (tosave.exists()) {
            currentLength = tosave.length();
        }
        if (currentLength == requiredFileSize) {
            return;
        }
        if (requiredFileSize == 0L) {
            tosave.delete();
            return;
        }
        try {
            URL urlobj = new URL(url);
            URLConnectionLengthInitialiser connectionLengthInitialiser = new URLConnectionLengthInitialiser(currentLength);
            InputStream urlin = AutoFetchURL.getInputStreamAndHandleTLSDowngrade((URL)urlobj, (AutoFetchURL.URLConnectionInitialiser)connectionLengthInitialiser);
            if (urlin == null) {
                if (!connectionLengthInitialiser.alreadyCached) {
                    ClientBranding.cleanup(tosave);
                }
                return;
            }
            byte[] tmp = StreamUtils.readAll(urlin);
            urlin.close();
            System.out.println("[Branding] Loading '" + targetName + "'... [" + tmp.length + " bytes] -> " + tosave.getPath());
            if (tmp.length == 0) {
                return;
            }
            try (BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(tosave));){
                ((OutputStream)fout).write(tmp);
            }
        }
        catch (Throwable t) {
            ClientBranding.cleanup(tosave);
        }
    }

    private static void loadBrandingFromServer(String codebase) throws IOException {
        VersionFiles.FileInfo[] parseBrandingFiles;
        File brandingFolder = ClientBranding.getCodebaseSpecificBrandingFolder(codebase);
        if (brandingFolder == null) {
            return;
        }
        System.out.println("[Branding] Loading branding options from " + codebase + "...");
        if (!codebase.endsWith("/")) {
            codebase = codebase + "/";
        }
        for (VersionFiles.FileInfo parseBrandingFile : parseBrandingFiles = VersionFiles.parseVersionFiles(codebase + "branding/brandingfiles")) {
            ClientBranding.downloadFromServer(brandingFolder, codebase + "branding/" + parseBrandingFile.filename, parseBrandingFile.filename, parseBrandingFile.requiredFileSize);
        }
        ClientBranding.loadBrandingFromCacheDir(codebase);
    }

    public static void loadBrandingFromCacheDir(String codebase) {
        File brandingFolder = ClientBranding.getCodebaseSpecificBrandingFolder(codebase);
        if (brandingFolder == null) {
            return;
        }
        long lastModifiedOnDisk = ClientBranding.getMostRecentlyModifiedResource(brandingFolder);
        if (lastModifiedOnDisk == lastModified) {
            System.out.println("[ClientBranding] Skipping reload.");
        } else {
            ClientBranding.get().loadBrandingFrom(brandingFolder);
            lastModified = ClientBranding.get().getMostRecentLoadedImageLastModified();
        }
    }

    private static File getCodebaseSpecificBrandingFolder(String codebase) {
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        File brandingFolder = new File(parent, "branding");
        if (codebase == null) {
            File[] files = brandingFolder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    return file;
                }
            }
            return null;
        }
        return ClientBranding.getBrandingFolderForServer(brandingFolder, codebase);
    }

    public static void startBrandingDownload(final String codebase) {
        if (brandingLoaded) {
            return;
        }
        brandingExecutor = Executors.newSingleThreadExecutor();
        brandingFuture = brandingExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientBranding.loadBrandingFromServer(codebase);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void waitForBrandingToComplete() {
        if (brandingLoaded) {
            return;
        }
        try {
            brandingFuture.get(10L, TimeUnit.SECONDS);
            brandingLoaded = true;
            System.out.println("[ClientBranding] Complete.");
        }
        catch (TimeoutException e) {
            System.out.println("[ClientBranding] Downloading the branding failed! Timeout reached!");
        }
        catch (Throwable t) {
            System.out.println("[ClientBranding] Failed to download branding...");
            t.printStackTrace();
        }
        finally {
            brandingExecutor.shutdownNow();
        }
    }

    static {
        brandingLoaded = false;
        INSTANCE = null;
        LOCK = new Object();
        lastModified = 0L;
    }

    public static class URLConnectionLengthInitialiser
    implements AutoFetchURL.URLConnectionInitialiser {
        private long localLength;
        private boolean alreadyCached = false;

        URLConnectionLengthInitialiser(long localLength) {
            this.localLength = localLength;
        }

        public boolean initialiseURLConnection(URLConnection connection) {
            this.alreadyCached = false;
            connection.setUseCaches(false);
            int length = connection.getContentLength();
            if ((long)length == this.localLength) {
                this.alreadyCached = true;
                return false;
            }
            return length != -1;
        }
    }
}

