/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.stream.GZIPer;
import utils.stream.StreamUtils;

public class ArrayToMessage {
    public static byte[] toCompressed(long[] array) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamUtils.writeInt((OutputStream)bout, (int)array.length);
            for (long a : array) {
                StreamUtils.writeLong((OutputStream)bout, (long)a);
            }
            return GZIPer.compress(bout.toByteArray(), 1.0);
        }
        catch (IOException x) {
            return null;
        }
    }

    public static long[] fromCompressed(byte[] dat) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(GZIPer.decompress(dat, 1.0));
            int N = StreamUtils.readInt((InputStream)bin);
            long[] tmp = new long[N];
            for (int i = 0; i < N; ++i) {
                tmp[i] = StreamUtils.readLong((InputStream)bin);
            }
            return tmp;
        }
        catch (IOException x) {
            return null;
        }
    }

    public static Message toMessage(long[] array) {
        Message m = new Message();
        for (long l : array) {
            m.append(l);
        }
        return m;
    }

    public static long[] fromMessage(Message m) {
        long[] array = new long[m.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = m.getAsLong(i);
        }
        return array;
    }
}

