/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.utils.VerboseSocket;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import utils.progtools.SocketCloseTimeoutMap;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.stream.SocketLeaks;
import utils.switches.Switches;

public class WorkingNioSocket
extends VerboseSocket {
    boolean DEBUG = false;
    private static TimeoutMap<TimeoutByteChannel, TimeoutByteChannel> timeouts = new TimeoutMap(1000);
    static SocketCloseTimeoutMap socketCloseTimeoutMap = new SocketCloseTimeoutMap();
    private final Object in_LOCK = new Object();
    private final Object out_LOCK = new Object();
    private InputStream fixedin;
    private OutputStream fixedout;

    public WorkingNioSocket(Socket s) {
        super(s);
    }

    public static Socket fixNIO(Socket sock) {
        if (sock instanceof WorkingNioSocket) {
            return sock;
        }
        WorkingNioSocket newsock = new WorkingNioSocket(sock);
        SocketLeaks.replace(sock, newsock);
        return newsock;
    }

    @Override
    protected void toot() {
    }

    private ByteChannel wrapChannel(final ByteChannel channel) {
        if (Switches.SH_artificiallyTimeoutBlockingNioSocketReads) {
            return new TimeoutByteChannel(channel);
        }
        ByteChannel ret = new ByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return channel.read(dst);
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        InputStream ret;
        SocketChannel channel = this.getChannel();
        if (channel != null) {
            Object object = this.in_LOCK;
            synchronized (object) {
                if (this.fixedin == null) {
                    this.fixedin = Channels.newInputStream(this.wrapChannel(channel));
                }
                ret = this.fixedin;
            }
        } else {
            ret = this.s.getInputStream();
        }
        if (Switches.SH_XXXX_monitorAllPxSocketsForInactivityAndClose) {
            ret = new TrackingInputStream(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream ret;
        SocketChannel channel = this.getChannel();
        if (channel != null) {
            Object object = this.out_LOCK;
            synchronized (object) {
                if (this.fixedout == null) {
                    this.fixedout = Channels.newOutputStream(this.wrapChannel(channel));
                }
                ret = this.fixedout;
            }
        } else {
            ret = this.s.getOutputStream();
        }
        if (Switches.SH_XXXX_monitorAllPxSocketsForInactivityAndClose) {
            ret = new TrackingOutputStream(ret);
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (Switches.SH_1778_nioSocketCloseChannelsWithSockClose) {
            try {
                if (this.fixedin != null) {
                    this.fixedin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.fixedout != null) {
                    this.fixedout.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.s.close();
    }

    private class TimeoutByteChannel
    implements ByteChannel,
    TimeoutMapListener<TimeoutByteChannel, TimeoutByteChannel> {
        ByteChannel channel;
        long lastTimeoutAdd = 0L;
        long lastTimeoutValue = 0L;
        Thread readThread = null;
        boolean timedOut = false;

        public TimeoutByteChannel(ByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            long timeout = WorkingNioSocket.this.getSoTimeout();
            long T = System.currentTimeMillis();
            if (T - this.lastTimeoutAdd > 500L || this.lastTimeoutValue != timeout) {
                this.lastTimeoutAdd = T;
                this.lastTimeoutValue = timeout;
                if (timeout > 0L) {
                    timeouts.put(this, this, WorkingNioSocket.this.getSoTimeout(), this);
                } else {
                    timeouts.remove(this);
                }
            }
            this.readThread = timeout > 0L ? Thread.currentThread() : null;
            long lastRead = T;
            try {
                int n = this.channel.read(dst);
                return n;
            }
            finally {
                this.readThread = null;
                if (this.timedOut) {
                    this.timedOut = false;
                    if (Switches.SH_terminateSocketsOnReadTimeout) {
                        this.channel.close();
                        WorkingNioSocket.this.close();
                    }
                    SocketTimeoutException timeoutException = new SocketTimeoutException("Timed out while reading from socket " + WorkingNioSocket.this.s + " (" + (System.currentTimeMillis() - T) + " > " + WorkingNioSocket.this.s.getSoTimeout() + ")");
                    if (WorkingNioSocket.this.DEBUG) {
                        timeoutException.printStackTrace();
                    }
                    throw timeoutException;
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        @Override
        public void objectTimedOut(TimeoutByteChannel key, TimeoutByteChannel val) {
            Thread target = this.readThread;
            if (target != null) {
                this.timedOut = true;
                target.interrupt();
            }
        }
    }

    private class TrackingInputStream
    extends FilterInputStream {
        Socket mysock;

        public TrackingInputStream(InputStream out) {
            super(out);
            this.mysock = WorkingNioSocket.this;
        }

        @Override
        public int read() throws IOException {
            socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            return this.in.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    private class TrackingOutputStream
    extends FilterOutputStream {
        Socket mysock;

        public TrackingOutputStream(OutputStream out) {
            super(out);
            this.mysock = WorkingNioSocket.this;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }
}

