/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.BlockingObjectInputStream;
import java.io.IOException;
import java.util.ArrayList;
import utils.switches.Switches;

public class ThreadPool {
    public static final int NO_MAX_BUFFER = -1;
    boolean die = false;
    int max = -1;
    ArrayList all = new ArrayList();
    Object bin_read_LOCK = new Object();
    BlockingObjectInputStream bin = new BlockingObjectInputStream();

    public ThreadPool(String name, int threads, int maxBuffered, int priority) {
        this.max = maxBuffered;
        for (int i = 0; i < threads; ++i) {
            this.all.add(new Worker(name, i, priority));
        }
    }

    public ArrayList getAllThreads() {
        return (ArrayList)this.all.clone();
    }

    public boolean isFull() {
        return this.bin.size() >= this.max;
    }

    public boolean runAsync(Runnable r) {
        if (this.max != -1 && this.bin.size() >= this.max) {
            return false;
        }
        this.bin.add(r);
        return true;
    }

    public static void main(String[] args) throws Exception {
        ThreadPool tp = new ThreadPool("TEST", 10, 100, 10);
        TestRun run = new TestRun();
        for (int i = 0; i < 100000000; ++i) {
            tp.runAsync(run);
        }
        System.out.println("DONE!");
    }

    static class TestRun
    implements Runnable {
        int N = 0;
        long QUIT = System.currentTimeMillis() + 1000L;

        TestRun() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TestRun testRun = this;
            synchronized (testRun) {
                ++this.N;
            }
            if (System.currentTimeMillis() > this.QUIT) {
                System.out.println(this.N);
                System.exit(0);
            }
        }
    }

    private class Worker
    extends Thread {
        public Worker(String name, int index, int priority) {
            super("ThreadPool-" + name + "-Worker-" + (1 + index));
            this.setPriority(priority);
            this.start();
        }

        @Override
        public void run() {
            block5: while (true) {
                try {
                    while (!ThreadPool.this.die) {
                        Runnable r = (Runnable)ThreadPool.this.bin.next();
                        try {
                            r.run();
                            continue block5;
                        }
                        catch (Throwable x) {
                            Exception xx = new Exception("ThreadPool run failed: " + x);
                            xx.initCause(x);
                            if (!Switches.SH_2041_threadPoolCatchExceptions) break block5;
                            xx.printStackTrace();
                        }
                    }
                    break;
                }
                catch (InterruptedException x) {
                    x.printStackTrace();
                    break;
                }
                catch (IOException x) {
                    x.printStackTrace();
                    break;
                }
            }
        }
    }
}

