/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

public class SafeClock
extends Thread {
    static long lastWarn = 0L;
    private static Object LOCK = new Object();
    private static SafeClock INSTANCE;
    private static long unchangingT;
    private static long driftingT;
    private static long drift;
    private static long FREQ;
    private static long FREQdiv2;

    public static void main(String[] args) throws Exception {
        while (true) {
            Thread.sleep(1000L);
            System.out.println(SafeClock.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startup() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new SafeClock();
                INSTANCE.start();
            }
        }
    }

    private SafeClock() {
        super("SafeClock");
        this.setDaemon(true);
    }

    public static long currentTimeMillis() {
        SafeClock.startup();
        return SafeClock.checkAndUpdateTime(FREQdiv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long checkAndUpdateTime(long assumedWait) {
        Object object = LOCK;
        synchronized (object) {
            long T = System.currentTimeMillis();
            if (T - driftingT > 10000L || T < driftingT) {
                if (System.currentTimeMillis() > lastWarn + 20000L) {
                    lastWarn = System.currentTimeMillis();
                    new WarningThread(T - driftingT).start();
                }
                drift = T - (unchangingT += assumedWait);
                driftingT = T;
            } else {
                driftingT = T;
                unchangingT = driftingT - drift;
            }
            return T - drift;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(FREQ);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SafeClock.checkAndUpdateTime(FREQ);
        }
    }

    static {
        unchangingT = System.currentTimeMillis();
        driftingT = System.currentTimeMillis();
        drift = 0L;
        FREQ = 100L;
        FREQdiv2 = FREQ / 2L;
    }

    static class WarningThread
    extends Thread {
        long amount;

        public WarningThread(long amount) {
            this.amount = amount;
        }

        @Override
        public void run() {
            System.out.println("*******************************************");
            System.out.println("* System Clock Changed - " + this.amount + "ms");
            System.out.println("*");
            System.out.println("* WARNING: It appears that your server is losing time. ");
            System.out.println("* Time loss > 10000ms will cause session instability and dropped connections.");
            System.out.println("*******************************************");
        }
    }
}

