/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.SafeClock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import utils.switches.Switches;

public abstract class IterableWeakReferenceListThread<T>
extends Thread {
    private boolean die = false;
    private int pollSleep = 0;
    private int logSleep = 0;
    private String name = null;
    protected LinkedList<WeakReference<T>> weakReferenceList = new LinkedList();
    private long nextLogTime = 0L;

    protected IterableWeakReferenceListThread(String name, int pollSleep, int logSleep) {
        super(name);
        this.name = name;
        this.pollSleep = pollSleep;
        this.logSleep = logSleep;
        System.out.println("[" + name + "] Starting...");
        this.start();
    }

    public void die() {
        System.out.println("[" + this.name + "] Dying...");
        this.die = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> getAll() {
        ArrayList list = new ArrayList();
        LinkedList<WeakReference<T>> linkedList = this.weakReferenceList;
        synchronized (linkedList) {
            for (WeakReference weakReference : this.weakReferenceList) {
                Object node = weakReference.get();
                if (node == null) continue;
                list.add(node);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsElement(T element) {
        LinkedList<WeakReference<T>> linkedList = this.weakReferenceList;
        synchronized (linkedList) {
            Iterator iterator = this.weakReferenceList.iterator();
            while (iterator.hasNext()) {
                WeakReference nodeRef = (WeakReference)iterator.next();
                Object node = nodeRef.get();
                if (node == null) {
                    iterator.remove();
                    continue;
                }
                if (!node.equals(element)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToList(T element) {
        LinkedList<WeakReference<T>> linkedList = this.weakReferenceList;
        synchronized (linkedList) {
            if (!this.containsElement(element)) {
                this.weakReferenceList.add(new WeakReference<T>(element));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromList(T element) {
        LinkedList<WeakReference<T>> linkedList = this.weakReferenceList;
        synchronized (linkedList) {
            Iterator it = this.weakReferenceList.iterator();
            while (it.hasNext()) {
                WeakReference nodeRef = (WeakReference)it.next();
                Object node = nodeRef.get();
                if (node != null && !node.equals(element)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.nextLogTime = SafeClock.currentTimeMillis() + (long)this.logSleep;
        while (!this.die) {
            try {
                Thread.sleep(this.pollSleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ArrayList toProcess = new ArrayList();
            LinkedList<WeakReference<T>> linkedList = this.weakReferenceList;
            synchronized (linkedList) {
                for (WeakReference nodeRef : (LinkedList)this.weakReferenceList.clone()) {
                    Object node = nodeRef.get();
                    if (node == null) {
                        this.weakReferenceList.remove(nodeRef);
                        continue;
                    }
                    if (Switches.SH_2003_iterableWeakReferenceListThreadProcesOutsideSyncBlock) {
                        toProcess.add(node);
                        continue;
                    }
                    try {
                        this.process(node);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (SafeClock.currentTimeMillis() > this.nextLogTime) {
                    this.nextLogTime = SafeClock.currentTimeMillis() + (long)this.logSleep;
                    System.out.println("[" + this.name + "] Listener size is " + this.weakReferenceList.size());
                }
            }
            if (!Switches.SH_2003_iterableWeakReferenceListThreadProcesOutsideSyncBlock) continue;
            for (Object node : toProcess) {
                try {
                    this.process(node);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    protected abstract void process(T var1);
}

