/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.ui;

import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class NodeLinkStatusPanel
extends JPanel
implements NodeLinkStatusListener,
Runnable {
    boolean quit = false;
    boolean square = true;
    public boolean dead = false;
    public boolean ok = false;
    public boolean established = false;
    Object LOCK = new Object();
    boolean state = true;
    ResourceBundle lang;

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(4, 4);
    }

    public NodeLinkStatusPanel() {
        this(true);
    }

    public NodeLinkStatusPanel(ResourceBundle bundle) {
        this(true, bundle);
    }

    public NodeLinkStatusPanel(boolean square) {
        this.square = square;
        this.setToolTipText("");
        Thread t = new Thread((Runnable)this, "NodeLinkStatusPanel");
        t.setName("NodeLinkStatusPanel");
        t.setDaemon(true);
        t.start();
    }

    public NodeLinkStatusPanel(boolean square, ResourceBundle lang) {
        this(square);
        this.lang = lang;
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        if (this.dead) {
            return;
        }
        try {
            this.ok = false;
            if (this.lang == null) {
                this.setToolTipText("Network link broken, trying to reconnect");
            } else {
                this.setToolTipText(this.lang.getString("NLNK_RECONNECTING"));
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void linkOK(NodeLink link) {
        if (this.ok) {
            return;
        }
        if (this.dead) {
            return;
        }
        try {
            this.established = true;
            this.ok = true;
            this.dead = false;
            if (this.lang == null) {
                this.setToolTipText("Connected OK");
            } else {
                this.setToolTipText(this.lang.getString("NLNK_CONNECTED"));
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void linkDead(NodeLink link, String msg) {
        try {
            this.ok = false;
            this.dead = true;
            if (msg == null) {
                msg = "";
            }
            if (msg.length() > 0) {
                if (this.lang == null) {
                    this.setToolTipText("Connection finished, " + msg);
                } else {
                    this.setToolTipText(this.lang.getString("NLNK_FINISHED") + ", " + msg);
                }
            } else if (this.lang == null) {
                this.setToolTipText("Connection finished");
            } else {
                this.setToolTipText(this.lang.getString("NLNK_FINISHED"));
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        Graphics2D g = (Graphics2D)g2;
        Color outline = new Color(0, 0, 0, 200);
        g.setColor(this.getBackground());
        g.fill(g.getClip());
        if (this.dead) {
            g.setColor(new Color(90, 10, 10));
        } else if (!this.established) {
            g.setColor(this.getBackground());
            outline = this.getBackground();
        } else if (this.ok) {
            g.setColor(new Color(70, 190, 70));
        } else if (this.state) {
            g.setColor(new Color(200, 140, 40));
        } else {
            g.setColor(new Color(235, 220, 30));
        }
        Rectangle r = g.getClipBounds();
        if (this.square) {
            if (r.width > r.height) {
                int off = (r.width - r.height + 1) / 2;
                r.width = r.height;
                r.x = off;
            } else if (r.height > r.width) {
                int off = (r.height - r.width + 1) / 2;
                r.height = r.width;
                r.y = off;
            }
            --r.width;
            --r.height;
        }
        g.fill(r);
        if (this.square) {
            g.setColor(outline);
            g.draw(r);
            g.setColor(new Color(0, 0, 0, 100));
            g.draw(new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2));
            g.setColor(new Color(255, 255, 255, 100));
            g.draw(new Rectangle(r.x + 2, r.y + 2, 1, 1));
        } else {
            g.setColor(new Color(0, 0, 0, 100));
            g.draw(r);
            g.setColor(new Color(255, 255, 255, 100));
            g.draw(new Rectangle(r.x + 1, r.y + 1, 1, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InfiniteLoop il = new InfiniteLoop();
        while (!this.quit) {
            il.LOOP();
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    this.state = !this.state;
                }
                Thread.sleep(750L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.repaint();
            }
            catch (Exception exception) {}
        }
    }
}

