/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.tcp;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.Transport;
import com.aem.nodelink.tcp.CachingSslProxyAuthProvider;
import com.aem.nodelink.tcp.SslProxyAuthProvider;
import com.aem.nodelink.tcp.TcpSocketHandler;
import com.aem.nodelink.tcp.TcpTransport;
import com.aem.nodelink.utils.SocketRestrictor;

public class TcpEndpoint
implements Endpoint {
    String host;
    int port;
    String stringval;
    String proxyhost;
    int proxyport;
    SslProxyAuthProvider auth;
    boolean ssl;
    boolean isServerEndpoint = false;
    long tcpConnectTimeout = 10000L;
    long lastReceivedData = 0L;
    String bindIp = null;
    TcpSocketHandler alt;
    boolean aggressiveReconnect = false;
    SocketRestrictor sres = new SocketRestrictor();

    public TcpEndpoint(String host, int port) {
        this.host = host;
        this.port = port;
        this.stringval = host + ":" + port;
    }

    public TcpEndpoint(String host, int port, boolean SSL) {
        this(host, port);
        this.ssl = SSL;
    }

    public TcpEndpoint(String host, int port, String sslproxy, int sslproxyport) {
        this(host, port);
        this.proxyhost = sslproxy;
        this.proxyport = sslproxyport;
        this.auth = null;
        this.stringval = host + ":" + port + " via " + sslproxy + ":" + sslproxyport;
    }

    public TcpEndpoint(String host, int port, String sslproxy, int sslproxyport, SslProxyAuthProvider auth) {
        this(host, port);
        this.proxyhost = sslproxy;
        this.proxyport = sslproxyport;
        this.auth = new CachingSslProxyAuthProvider(auth);
        this.stringval = host + ":" + port + " via ?@" + sslproxy + ":" + sslproxyport;
    }

    public void setTcpConnectTimeout(long millis) {
        this.tcpConnectTimeout = millis;
    }

    public void setBindIp(String ip) {
        this.bindIp = ip;
    }

    public String toString() {
        return this.stringval;
    }

    @Override
    public Transport newTransport(Node n) {
        return new TcpTransport(n, this.tcpConnectTimeout);
    }

    public void setIsServerEndpoint(boolean b) {
        this.isServerEndpoint = b;
    }

    public boolean isServerEndpoint() {
        return this.isServerEndpoint;
    }

    public void setAlternateSocketHandler(TcpSocketHandler handler) {
        this.alt = handler;
    }

    public TcpSocketHandler getAlternateSocketHandler() {
        return this.alt;
    }
}

