/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.http;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.Robustness;
import com.aem.nodelink.Transport;
import com.aem.nodelink.http.DestinedPacket;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.http.extend.HttpRequestPoster;
import com.aem.nodelink.http.extend.HttpRequestProcessor;
import com.aem.nodelink.utils.BlockingObjectHandler;
import com.aem.nodelink.utils.BlockingObjectInputStream;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.SocketRestrictor;
import com.aem.nodelink.utils.SslToTcp;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import utils.progtools.SocketCloseTimeoutMap;
import utils.switches.Switches;

public class FullDuplexHttpTransport
implements Transport,
HttpRequestProcessor {
    public static boolean VERBOSE_OPS = true;
    static int MB = 1000000;
    static int STREAM_LEN_NORMAL = (845 + (int)(Math.random() * 45.0)) * MB;
    static int STREAM_LEN_TESTING = 20 * MB;
    static int STREAM_LEN = STREAM_LEN_NORMAL;
    static boolean DEBUG = false;
    static boolean DEBUG_FIRST_CONTACT = false;
    static boolean DEBUG_SIMULATE_POLLER_QUITS = false;
    static boolean VERSBOSE_ENTRY_EXIT = false;
    static boolean VERBOSE = false;
    public static int PUSHER_COUNT = 1;
    public static int PULLER_COUNT = 1;
    String CLIENT_PUSHING = "clientout";
    String CLIENT_PULLING = "clientin";
    volatile long lastData;
    boolean dead = false;
    String deadReason = "";
    HttpEndpoint server;
    Node mynode;
    Node alsoFetch;
    Object pollers_LOCK = new Object();
    HashMap pollers = new HashMap();
    Object buffers_LOCK = new Object();
    HashMap buffers = new HashMap();
    InetAddress from;
    static SocketCloseTimeoutMap closemap = new SocketCloseTimeoutMap();
    private Node lastSentFrom;
    private int consecutiveQueryFails = 0;
    Cache fromAddresses = new Cache("HttpTransport", 1000);
    boolean dropAll = false;
    Transport fwdTransport;
    Node fwdNode;
    Endpoint fwdEndpoint;

    private void die(String reason) {
        this.dead = true;
        this.deadReason = reason;
        this.closeAllBuffers(this.deadReason);
    }

    @Override
    public String getHumanReadableTransportIdentifierFor(Node target) throws Exception {
        InetAddress addr = (InetAddress)this.fromAddresses.getFromCache(target.toString());
        if (addr == null) {
            return "127.0.0.1";
        }
        return addr.getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllBuffers(String reason) {
        Object object = this.buffers_LOCK;
        synchronized (object) {
            Object[] keys;
            for (Object key : keys = this.buffers.keySet().toArray()) {
                BlockingObjectInputStream bin = (BlockingObjectInputStream)this.buffers.get(key);
                try {
                    bin.setClosed(new IOException("FDHTTP shut down " + reason));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldBuffers() {
        if (Switches.SH_1468_clearHttpBuffersOnTimeouts) {
            Object object = this.buffers_LOCK;
            synchronized (object) {
                Object[] keys;
                for (Object key : keys = this.buffers.keySet().toArray()) {
                    BlockingObjectInputStream bin = (BlockingObjectInputStream)this.buffers.get(key);
                    if (SafeClock.currentTimeMillis() - bin.getLastUsedSC() <= (long)NodeLink.DEFAULT_ERROR_TIMEOUT) continue;
                    long age = SafeClock.currentTimeMillis() - bin.getLastUsedSC();
                    if (Switches.SH_1468_debugging) {
                        System.out.println("[SH-1468] Closing FullDuplexHttp buffer now, should terminate thread");
                    }
                    bin.setClosed(new IOException("FullDuplexHttpStream (" + key + ") shut down >" + NodeLink.DEFAULT_ERROR_TIMEOUT / 60000 + "m (" + age + "ms)"));
                    this.buffers.remove(key);
                    if (!Switches.SH_1468_beepOnHttpShutdown) continue;
                    try {
                        Runtime.getRuntime().exec("say 'HTTP Duplex Shutdown'");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingObjectInputStream getBufferToServer(String end, boolean canCreate) {
        BlockingObjectInputStream list;
        Object object = this.buffers_LOCK;
        synchronized (object) {
            this.clearOldBuffers();
            list = (BlockingObjectInputStream)this.buffers.get(end);
            if (list == null && canCreate) {
                list = new BlockingObjectInputStream();
                this.buffers.put(end, list);
            }
        }
        return list;
    }

    private BlockingObjectInputStream getBufferFromServer(String end, boolean canCreate) {
        return this.getBufferToClient(end, canCreate);
    }

    private BlockingObjectInputStream getBufferToClient(Node node, boolean canCreate) {
        return this.getBufferToClient(node.toString(), canCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingObjectInputStream getBufferToClient(String node, boolean canCreate) {
        BlockingObjectInputStream list;
        Object object = this.buffers_LOCK;
        synchronized (object) {
            this.clearOldBuffers();
            list = (BlockingObjectInputStream)this.buffers.get(node);
            if (list == null && canCreate) {
                if (VERBOSE_OPS) {
                    System.out.println("[HttpTransport] ***WARNING Creating buffer on get for " + node + " without equalising");
                }
                list = new BlockingObjectInputStream();
                this.buffers.put(node, list);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void equaliseBuffer(String node, String node2, boolean canCreate) {
        Object object = this.buffers_LOCK;
        synchronized (object) {
            BlockingObjectInputStream bin = (BlockingObjectInputStream)this.buffers.get(node);
            if (bin == null) {
                bin = (BlockingObjectInputStream)this.buffers.get(node2);
            }
            if (bin == null && canCreate) {
                if (VERBOSE_OPS) {
                    System.out.println("[HttpTransport] Creating buffer for " + node + " / " + node2);
                }
                bin = this.getBufferToClient(node, canCreate);
            }
            if (bin != null) {
                if (VERBOSE_OPS) {
                    System.out.println("[HttpTransport] Equalising buffers for " + node + " / " + node2);
                }
                this.buffers.put(node, bin);
                this.buffers.put(node2, bin);
            }
        }
    }

    public FullDuplexHttpTransport(Node node) {
        this.mynode = node;
    }

    @Override
    public void ensureAcceptingOn(Endpoint ee) throws Exception {
        HttpEndpoint e = (HttpEndpoint)ee;
        this.server = new HttpEndpoint(new URL("http://SERVER/"));
        if (Robustness.ALL_HTTP_BINDS_FAIL) {
            throw new Exception("Robustness forcing all HTTP binds (server creates) to fail");
        }
        e.factory.redirectUrlRequests(e.url, this);
    }

    void waitForBufferSpace(BlockingObjectInputStream buffer) throws IOException {
        long tquit = SafeClock.currentTimeMillis() + (long)NodeLink.DEFAULT_ERROR_TIMEOUT;
        while (buffer.size() > 5) {
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!Switches.SH_1468_fullDuplexSpaceWaitTimeout || SafeClock.currentTimeMillis() <= tquit) continue;
            throw new IOException("FullDuplexHttpTransport timed out waiting for space");
        }
    }

    @Override
    public void sendPacketTo(Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        this.sendPacketTo(this.mynode, target, ep, data, rarelyVerifyLiveness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacketTo(Node sentFrom, Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        if (this.dropAll) {
            return;
        }
        if (ep == this.server) {
            BlockingObjectInputStream buffer;
            if (VERSBOSE_ENTRY_EXIT) {
                System.out.println("[HttpTransport] sent packet " + data.length + " from " + sentFrom + " to " + target);
            }
            if (DEBUG) {
                System.out.println("PACKET - server sending packet to " + target);
            }
            if ((buffer = this.getBufferToClient(target, true)) != null) {
                this.waitForBufferSpace(buffer);
                buffer.add(new DestinedPacket(sentFrom, data));
                if (DEBUG) {
                    System.out.println("PACKET - server added packet to buffer");
                }
                return;
            }
            System.out.println("UNEXPECTED ERROR server making HTTP request? " + data.length);
        } else {
            if (DEBUG) {
                System.out.println("PACKET - client sending packet");
            }
            BlockingObjectInputStream buffer = this.getBufferToServer(this.CLIENT_PUSHING, true);
            byte[] packet = new byte[4 + data.length];
            ByteArrayUtils.writeInt(packet, 0, data.length);
            System.arraycopy(data, 0, packet, 4, data.length);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataUtils.writeStringUTF8(bout, sentFrom.getUID());
            if (this.alsoFetch == null) {
                DataUtils.writeStringUTF8(bout, sentFrom.getUID());
            } else {
                DataUtils.writeStringUTF8(bout, this.alsoFetch.getUID());
            }
            DataUtils.writeBytes(bout, data);
            this.waitForBufferSpace(buffer);
            buffer.add(bout.toByteArray());
            HttpEndpoint e = (HttpEndpoint)ep;
            Object object = this.pollers_LOCK;
            synchronized (object) {
                Poller[] poller = (Poller[])this.pollers.get(e.toString());
                if (poller == null && !this.dead) {
                    int i;
                    poller = new Poller[PUSHER_COUNT + PULLER_COUNT];
                    for (i = 0; i < PUSHER_COUNT; ++i) {
                        poller[i] = new Poller(e, target, true);
                        poller[i].start();
                    }
                    this.pollers.put(e.toString(), poller);
                    for (i = PUSHER_COUNT; i < PUSHER_COUNT + PULLER_COUNT; ++i) {
                        poller[i] = new Poller(e, target, false);
                        poller[i].start();
                    }
                    this.pollers.put(e.toString(), poller);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeHttpRequest(Node sentFrom, HttpEndpoint e, BlockingObjectInputStream boon, Node target, boolean puller) throws Exception {
        if (this.dead) {
            throw new IOException(this.deadReason);
        }
        if (SafeClock.currentTimeMillis() - this.lastData > (long)NodeLink.DEFAULT_RECONNECT_TIMEOUT) {
            if (VERBOSE_OPS) {
                System.out.println("[FDHTTP " + e + "] Quit due to no incoming data for extended period");
            }
            this.die("[FDHTTP " + e + "] Quit due to no incoming data for extended period");
            throw new IOException(this.deadReason);
        }
        String name = "Puller";
        if (!puller) {
            name = "Pusher";
        }
        if (sentFrom == null) {
            sentFrom = this.lastSentFrom != null ? this.lastSentFrom : this.mynode;
        } else {
            this.lastSentFrom = sentFrom;
        }
        HttpRequestPoster poster = e.cfactory.newClient();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataUtils.writeString(bout, sentFrom.getUID());
            if (this.alsoFetch == null) {
                DataUtils.writeString(bout, sentFrom.getUID());
            } else {
                DataUtils.writeString(bout, this.alsoFetch.getUID());
            }
            DataUtils.writeBoolean(bout, puller);
            if (DEBUG) {
                System.out.println("[FDHTTP " + e + "] " + name + " Wrote identifying info into POST");
            }
            if (puller) {
                BufferedInputStream bbin = new BufferedInputStream(poster.doPost(e.url, bout.toByteArray(), 0, null));
                bout = null;
                if (VERBOSE_OPS) {
                    System.out.println("[FDHTTP " + e + "] " + name + " got inputstream to pull from");
                }
                try {
                    while (true) {
                        String sendingNode = DataUtils.readNStringUTF8(bbin, 10000);
                        this.mynode.setRemoteNodeAddress(new Node(sendingNode), e, this);
                        byte[] packet = DataUtils.readNBytes(bbin, 10000000);
                        if (packet.length == 0) {
                            throw new IOException("[FDHTTP " + e + "] " + name + " HTTP connection ended");
                        }
                        this.lastData = SafeClock.currentTimeMillis();
                        if (DEBUG) {
                            System.out.println("[FDHTTP " + e + "] Pulled packet " + packet.length);
                        }
                        if (this.dropAll) continue;
                        if (this.areForwarding()) {
                            this.fwdTransport.sendPacketTo(this.fwdNode, this.fwdEndpoint, packet, false);
                            continue;
                        }
                        this.mynode.processPacket(packet, target.toString());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        bbin.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        poster.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (DEBUG) {
                System.out.println("[FDHTTP " + e + "] " + name + " setting up outputstream to push to");
            }
            poster.doPost(e.url, bout.toByteArray(), STREAM_LEN, this.getBufferToServer(this.CLIENT_PUSHING, true));
        }
        catch (IOException x) {
            if (VERBOSE_OPS) {
                System.out.println("[FDHTTP " + e + "] " + name + " request terminated - " + x);
            }
        }
        catch (Throwable x) {
            if (VERBOSE_OPS) {
                System.out.println("[FDHTTP " + e + "] " + name + " request terminated - " + x);
            }
            if (VERBOSE_OPS) {
                x.printStackTrace();
            }
        }
        finally {
            try {
                poster.close();
            }
            catch (Throwable x) {}
        }
    }

    @Override
    public int getStreamContentLength() {
        return STREAM_LEN;
    }

    @Override
    public boolean isStreamProcessor() {
        return true;
    }

    @Override
    public byte[] processHttpRequest(byte[] incoming, boolean isSslConnection, InetAddress fromAddr) throws Exception {
        throw new Exception("Unsupported HTTP processing method");
    }

    @Override
    public void processHttpRequest(Socket sock, InputStream in, OutputStream out, boolean isSslConnection, final InetAddress fromAddr) throws Exception {
        System.out.println("[FDHTTP " + fromAddr + "] Processing new HTTP request...");
        if (SslToTcp.ACCEPT_ONLY_SSL_CONNECTIONS && !isSslConnection) {
            throw new Exception("Refusing non-SSL session connections");
        }
        String fromnode = DataUtils.readNString(in, 100000);
        String fetchnode = DataUtils.readNString(in, 10000);
        this.fromAddresses.addToCache(fromnode, fromAddr);
        this.mynode.setRemoteNodeAddress(new Node(fromnode), this.server, this);
        boolean puller = DataUtils.readBoolean(in);
        if (puller) {
            System.out.println("[FDHTTP " + fromAddr + "] Server got connection to puller for " + fromnode + " / " + fetchnode);
            this.equaliseBuffer(fromnode, fetchnode, true);
            BlockingObjectInputStream buffer = this.getBufferToClient(fromnode, true);
            buffer.setOwner(Thread.currentThread());
            System.out.println("[FDHTTP " + fromAddr + "] Puller for " + fromnode + " set up OK");
            try {
                if (Switches.SH_2092_useNioHandlerForFDHTTP) {
                    final String packetsNode = fromnode;
                    final String packetsFetch = fetchnode;
                    final InputStream packetsIn = in;
                    final OutputStream packetsOut = out;
                    buffer.setBlockingObjectHandler(new BlockingObjectHandler(){
                        boolean first = true;
                        boolean closed = false;

                        @Override
                        public void processBlockingObject(Object o) {
                            if (this.closed) {
                                return;
                            }
                            DestinedPacket dp = (DestinedPacket)o;
                            if (DEBUG || this.first) {
                                System.out.println("[FDHTTP " + fromAddr + "] SEND server dumping packet into stream " + dp.getData().length);
                            }
                            if (VERSBOSE_ENTRY_EXIT || this.first) {
                                System.out.println("[FDHTTP " + fromAddr + "] writing packet " + dp.getData().length + " from " + dp.getNode() + " to " + packetsNode + "/" + packetsFetch);
                            }
                            try {
                                DataUtils.writeStringUTF8(packetsOut, dp.getNode().getUID());
                                DataUtils.writeBytes(packetsOut, dp.getData());
                                packetsOut.flush();
                            }
                            catch (IOException x) {
                                try {
                                    packetsIn.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    packetsOut.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (Switches.SH_xxxx_fdhttpNoFullTraceOnClose) {
                                    System.out.println("[FDHTTP " + fromAddr + "] HTTP connection ended - " + x);
                                } else {
                                    x.printStackTrace();
                                }
                                this.closed = true;
                            }
                            if (this.first) {
                                System.out.println("[FDHTTP " + fromAddr + "] Packet sent to " + packetsNode);
                            }
                            this.first = false;
                        }
                    });
                    return;
                }
                boolean first = true;
                while (true) {
                    if (DEBUG || first) {
                        System.out.println("[FDHTTP " + fromAddr + "] Server waiting for packet on " + buffer + "...");
                    }
                    DestinedPacket dp = (DestinedPacket)buffer.next();
                    if (DEBUG || first) {
                        System.out.println("[FDHTTP " + fromAddr + "] SEND server dumping packet into stream " + dp.getData().length);
                    }
                    if (VERSBOSE_ENTRY_EXIT || first) {
                        System.out.println("[FDHTTP " + fromAddr + "] writing packet " + dp.getData().length + " from " + dp.getNode() + " to " + fromnode + "/" + fetchnode);
                    }
                    DataUtils.writeStringUTF8(out, dp.getNode().getUID());
                    DataUtils.writeBytes(out, dp.getData());
                    out.flush();
                    if (first) {
                        System.out.println("[FDHTTP " + fromAddr + "] Packet sent to " + fromnode);
                    }
                    first = false;
                }
            }
            catch (Exception x) {
                try {
                    in.close();
                }
                catch (Exception dp) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception dp) {
                    // empty catch block
                }
                if (Switches.SH_xxxx_fdhttpNoFullTraceOnClose) {
                    System.out.println("[FDHTTP " + fromAddr + "] HTTP connection ended - " + x);
                } else {
                    x.printStackTrace();
                }
                throw new Exception("[FDHTTP " + fromAddr + "] HTTP connection ended");
            }
        }
        System.out.println("[FDHTTP " + fromAddr + "] Server got connection to pusher for " + fromnode);
        try {
            boolean first = DEBUG_FIRST_CONTACT;
            while (true) {
                if (Switches.SH_XXXX_fdhttp_read_timeout) {
                    closemap.closeSocketIfNoUpdate(sock, NodeLink.DEFAULT_ERROR_TIMEOUT);
                }
                fromnode = DataUtils.readNStringUTF8(in, 100000);
                fetchnode = DataUtils.readNStringUTF8(in, 10000);
                this.fromAddresses.addToCache(fromnode, fromAddr);
                this.mynode.setRemoteNodeAddress(new Node(fromnode), this.server, this);
                int size = DataUtils.readInt(in);
                if (DEBUG || first) {
                    System.out.println("[FDHTTP " + fromAddr + "] RECEIVE server got len " + size);
                }
                byte[] packet = DataUtils.readBytes(in, size);
                if (DEBUG || first) {
                    System.out.println("[FDHTTP " + fromAddr + "] RECEIVE server got " + packet);
                }
                if (packet.length == 0) {
                    if (DEBUG || first) {
                        System.out.println("[FDHTTP " + fromAddr + "] Packet empty, HTTP connection ended");
                    }
                    throw new IOException("[FDHTTP " + fromAddr + "] HTTP connection ended");
                }
                if (!this.dropAll) {
                    if (this.areForwarding()) {
                        if (VERSBOSE_ENTRY_EXIT || first) {
                            System.out.println("[FDHTTP " + fromAddr + "] forwarding packet " + packet.length + " from " + fromnode);
                        }
                        this.fwdTransport.sendPacketTo(this.fwdNode, this.fwdEndpoint, packet, false);
                    } else {
                        if (VERSBOSE_ENTRY_EXIT || first) {
                            System.out.println("[FDHTTP " + fromAddr + "] processing packet " + packet.length + " from " + fromnode);
                        }
                        this.mynode.processPacket(packet, fromnode);
                    }
                }
                if (first) {
                    System.out.println("[FDHTTP " + fromAddr + "] Packet read from " + fromnode);
                }
                first = false;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public Object getLockObject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnections() throws Exception {
        System.out.println("[FDHTTP] Cleaning up all connections");
        this.die("FDHTTP asked to clean up all connections (NL shutdown)");
        Object object = this.pollers_LOCK;
        synchronized (object) {
            System.out.println("[FDHTTP] Trying to shut down threads");
            Object[] arrays = this.pollers.values().toArray();
            for (int i = 0; i < arrays.length; ++i) {
                Poller[] tmp = (Poller[])arrays[i];
                for (int k = 0; k < tmp.length; ++k) {
                    tmp[k].join();
                }
                System.out.println("[FDHTTP] Joined " + (1 + i) + " of " + arrays.length);
            }
        }
    }

    @Override
    public void cleanupAllConnectionsTo(Node target) throws Exception {
        this.cleanupAllConnections();
    }

    @Override
    public void setMyNode(Node node, Endpoint e) {
        if (VERBOSE_OPS) {
            System.out.println("[FDHTTP " + e + "] My Node set to " + this.mynode + " from " + node);
        }
        this.mynode = node;
    }

    public void addFetchTarget(Node node) {
        if (VERBOSE_OPS) {
            System.out.println("[FDHTTP] Also fetching packets for node " + node);
        }
        this.alsoFetch = node;
    }

    @Override
    public void dropAllPackets() {
        this.dropAll = true;
    }

    @Override
    public void stopDroppingAllPackets() {
        this.dropAll = false;
    }

    @Override
    public void swapTargetsWith(Node myTarget, Transport fromTransport, Endpoint fromEndpoint, Node fromTarget) {
    }

    @Override
    public void forwardAllPacketsTo(Transport transport, Node target, Endpoint ep) throws Exception {
        this.fwdEndpoint = ep;
        this.fwdNode = target;
        this.fwdTransport = transport;
    }

    @Override
    public boolean isProxiedConnection(Endpoint ep) {
        return false;
    }

    public boolean areForwarding() {
        return this.fwdTransport != null;
    }

    @Override
    public void copyTransportData(Node currentTarget, Node newTarget, Endpoint myEp) {
    }

    class Poller
    extends Thread {
        HttpEndpoint e;
        Node target;
        Node orig;
        byte[] empty = new byte[0];
        boolean pusher;
        String type;

        public Poller(HttpEndpoint e, Node target, boolean pusher) {
            this.type = pusher ? "Pusher" : "Puller";
            this.setName("HttpTransport_" + this.type + "_" + e);
            this.e = e;
            this.target = target;
            this.orig = target;
            this.pusher = pusher;
            this.setPriority(10);
            this.setDaemon(true);
            if (VERBOSE_OPS) {
                System.out.println("[FDHTTP " + e + "] " + this.type + " created for " + target + " (" + e + ") (httpT=" + FullDuplexHttpTransport.this.hashCode() + ")");
            }
        }

        @Override
        public void run() {
            int errors = 0;
            String name = "Puller";
            if (this.pusher) {
                name = "Pusher";
            }
            SocketRestrictor sres = new SocketRestrictor();
            FullDuplexHttpTransport.this.lastData = SafeClock.currentTimeMillis();
            long since = SafeClock.currentTimeMillis();
            int REQ = 1;
            long initialConnectTimeout = SafeClock.currentTimeMillis() + 60000L;
            try {
                while (!FullDuplexHttpTransport.this.dead) {
                    try {
                        ++REQ;
                        if (DEBUG_SIMULATE_POLLER_QUITS && SafeClock.currentTimeMillis() - since > 20000L) {
                            System.out.println("[FDHTTP " + this.e + "] Debug: Simulating " + name + " QUIT");
                            since = SafeClock.currentTimeMillis();
                            break;
                        }
                        if (STREAM_LEN != STREAM_LEN_TESTING && sres.requestCreateOrQuit("FDHTTP " + this.e)) {
                            System.out.println("[FDHTTP " + this.e + "] " + name + " quit for " + this.target + " (" + this.e + ") (httpT=" + FullDuplexHttpTransport.this.hashCode() + ")");
                            return;
                        }
                        if (VERBOSE_OPS) {
                            System.out.println("[FDHTTP " + this.e + "] " + name + " attempting request " + REQ + " (" + (SafeClock.currentTimeMillis() - FullDuplexHttpTransport.this.lastData) / 1000L + "s since data)");
                        }
                        if (this.pusher) {
                            FullDuplexHttpTransport.this.makeHttpRequest(null, this.e, null, this.target, false);
                        } else {
                            FullDuplexHttpTransport.this.makeHttpRequest(null, this.e, FullDuplexHttpTransport.this.getBufferFromServer(FullDuplexHttpTransport.this.CLIENT_PULLING, true), this.target, true);
                        }
                        errors = 0;
                    }
                    catch (Throwable t) {
                        if (VERBOSE_OPS) {
                            System.out.println("[FDHTTP " + this.e + "] Break (" + t + ") will reconnect");
                        }
                        t.printStackTrace();
                        if (VERBOSE) {
                            t.printStackTrace();
                        }
                        if (errors >= 10) {
                            if (VERBOSE_OPS) {
                                System.out.println("[FDHTTP " + this.e + "] " + name + " quit established connection for " + this.target + " (" + this.e + ") (httpT=" + FullDuplexHttpTransport.this.hashCode() + ")");
                            }
                            return;
                        }
                        ++errors;
                        try {
                            if (VERBOSE) {
                                System.out.println("[FDHTTP " + this.e + "] " + name + " sleeping for " + errors + "secs");
                            }
                            Thread.sleep(errors * 1000);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (SafeClock.currentTimeMillis() >= initialConnectTimeout || REQ <= 3) continue;
                    if (VERBOSE_OPS) {
                        System.out.println("[FDHTTP " + this.e + "] " + name + " quit initial connect for " + this.target + " (" + this.e + ") (httpT=" + FullDuplexHttpTransport.this.hashCode() + ")");
                    }
                    FullDuplexHttpTransport.this.die("FDHTTP " + this.e + " quit initial connect for " + this.target);
                    return;
                }
            }
            catch (Throwable t) {
                System.out.println("[FDHTTP " + this.e + "] [HttpTransport] Died due to " + name + " quits");
                FullDuplexHttpTransport.this.die("FDHTTP " + this.e + " " + name + " died unexpectedly - " + t);
            }
        }
    }
}

