/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.attempt.socket;

import com.aem.nodelink.attempt.Attempt;
import com.aem.nodelink.attempt.ConcurrentAttempt;
import com.aem.nodelink.attempt.socket.ServerSocketConnectAttempt;
import com.aem.nodelink.attempt.socket.SocketConnectAttempt;
import com.aem.nodelink.utils.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class ClientSocketConnectAttempt
implements SocketConnectAttempt {
    String host;
    int port;
    int retries;
    long retryDelay;
    long delay;
    long connectTimeout;
    boolean expectData = false;
    int expected;
    Socket sock;
    boolean aborted = false;
    boolean finished = false;
    boolean success = false;

    public ClientSocketConnectAttempt(String host, int port, int retries, long retryDelay, long delay) {
        this(host, port, retries, 8000L, retryDelay, delay);
    }

    public ClientSocketConnectAttempt(String host, int port, int retries, long connectTimeout, long retryDelay, long delay) {
        this.host = host;
        this.port = port;
        this.retries = retries;
        this.retryDelay = retryDelay;
        this.delay = delay;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Socket getSocket() {
        return this.sock;
    }

    @Override
    public void abortAttempt() {
        this.aborted = true;
        try {
            System.out.println("[ClientConnect] Aborted - closing socket as precatution " + this.sock);
            this.sock.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.success = false;
        this.finished = true;
    }

    @Override
    public void attemptNow() {
        for (int i = 0; i < this.retries + 1; ++i) {
            try {
                block13: {
                    this.sock = new Socket();
                    this.sock.connect(new InetSocketAddress(this.host, this.port), (int)this.connectTimeout);
                    if (this.aborted) {
                        try {
                            System.out.println("[ClientConnect] Aborted - closing socket after creation " + this.sock);
                            this.sock.close();
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    try {
                        if (!this.expectData) break block13;
                        InputStream in = this.sock.getInputStream();
                        this.sock.setSoTimeout(8000);
                        int first = DataUtils.readInt(in);
                        if (first != this.expected) {
                            try {
                                this.sock.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw new IOException("Expected data not received data");
                        }
                        this.sock.setSoTimeout(0);
                    }
                    catch (Exception x) {
                        this.success = false;
                        break;
                    }
                }
                System.out.println("[ClientConnect] Success - got socket " + this.sock);
                this.success = true;
                break;
            }
            catch (IOException x) {
                try {
                    Thread.sleep(this.retryDelay);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.finished = true;
    }

    public void setExpectedFirstData(int expected) {
        this.expectData = true;
        this.expected = expected;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean wasSuccessful() {
        return this.success;
    }

    public String toString() {
        return "Client connection to " + this.host + ":" + this.port;
    }

    public static void main(String[] args) throws Exception {
        ConcurrentAttempt ca = new ConcurrentAttempt();
        ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt("localhost", 1000, 10, 1000L, 100L));
        ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt("localhost", 2000, 10, 1000L, 500L));
        ca.appendAttemptToCurrentLayer(new ServerSocketConnectAttempt(new ServerSocket(9999), true, 0L));
        ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt("localhost", 8888, 10, 1000L, 3000L));
        ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt("localhost", 8080, 10, 1000L, 3000L));
        Attempt success = ca.attemptNow();
        Socket sock = ((SocketConnectAttempt)success).getSocket();
        System.out.println(sock);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            sock.sendUrgentData(2);
            System.out.println("OK");
        }
    }
}

