/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.RTTBuckets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class NodeLinkStats {
    public long sessionStarted;
    public long diedTimes;
    public int type = -1;
    public long currentTime = -1L;
    public long sent = 0L;
    public long received = 0L;
    public double maxReadRateKB;
    public RTTBuckets buckets = new RTTBuckets();

    public NodeLinkStats cloneSelf() {
        NodeLinkStats stats = new NodeLinkStats();
        stats.buckets = this.buckets.cloneSelf();
        stats.sessionStarted = this.sessionStarted;
        stats.diedTimes = this.diedTimes;
        stats.type = this.type;
        stats.currentTime = this.currentTime;
        stats.sent = this.sent;
        stats.received = this.received;
        stats.maxReadRateKB = this.maxReadRateKB;
        return stats;
    }

    public void rttMeasured(long rtt) {
        this.buckets.rttMeasured(rtt);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NL Stats:");
        sb.append("\n- type: " + this.type);
        sb.append("\n- started: " + this.sessionStarted);
        sb.append("\n- duration: " + (this.currentTime - this.sessionStarted));
        sb.append("\n- sent: " + this.sent);
        sb.append("\n- received: " + this.received);
        return sb.toString();
    }

    public byte[] toBytes() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DataUtils.writeLong(out, this.sessionStarted);
            DataUtils.writeLong(out, this.diedTimes);
            DataUtils.writeInt(out, this.type);
            DataUtils.writeLong(out, this.currentTime);
            DataUtils.writeLong(out, this.sent);
            DataUtils.writeLong(out, this.received);
            DataUtils.writeInt(out, this.buckets.rtts.length);
            for (int i = 0; i < this.buckets.rtts.length; ++i) {
                DataUtils.writeInt(out, (int)this.buckets.rtts[i]);
            }
            DataUtils.writeDouble(out, this.maxReadRateKB);
        }
        catch (Exception x) {
            return null;
        }
        return out.toByteArray();
    }

    public static NodeLinkStats fromBytes(byte[] dat) {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        NodeLinkStats stats = new NodeLinkStats();
        try {
            stats.sessionStarted = DataUtils.readLong(bin);
            stats.diedTimes = DataUtils.readLong(bin);
            stats.type = DataUtils.readInt(bin);
            stats.currentTime = DataUtils.readLong(bin);
            stats.sent = DataUtils.readLong(bin);
            stats.received = DataUtils.readLong(bin);
            stats.buckets.rtts = new long[DataUtils.readInt(bin)];
            for (int i = 0; i < stats.buckets.rtts.length; ++i) {
                stats.buckets.rtts[i] = DataUtils.readInt(bin);
            }
            stats.maxReadRateKB = DataUtils.readDouble(bin);
        }
        catch (Exception e) {
            return null;
        }
        return stats;
    }
}

