/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.HoleRequestThread;
import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.utils.HeadlessByteVisualiserInterface;
import com.aem.nodelink.utils.ObjectPool;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.vis.NLOptimisationFeed;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import utils.switches.Switches;

public class HoleyBigBuffer
extends InputStream {
    public static final int INFINITE_BUF = -1;
    public static final int DEFAULT_BUF = 400000;
    private static final int REMOVE_FROM_CACHE = -5;
    Object LOCK = new Object();
    LinkedList valids = new LinkedList();
    LinkedList holes = new LinkedList();
    long oldRestartPoint = 0L;
    Span restartSpan = null;
    LinkedList datas = new LinkedList();
    int validLength = 0;
    byte[] dataBuf = new byte[0];
    int dataPtr = 0;
    boolean isClosed = false;
    IOException fatalerror = null;
    boolean waitingForData = false;
    boolean waitingForSpace = false;
    int max_buf = 400000;
    NodeLink mynl;
    NLOptimisationFeed OPT_FEED;
    long startingPoint = 0L;
    long byteCount = 0L;
    long BW_SAMPLE_MS = 6000L;
    long bwReadBytes = 0L;
    long bwReadFinish = SafeClock.currentTimeMillis();
    double maxKB = 0.0;
    byte[] readOne = new byte[1];
    InfiniteLoop il_read = new InfiniteLoop();
    HeadlessByteVisualiserInterface hbv;
    byte[] empty = new byte[0];
    long holesLogicalClock = 0L;
    boolean waitingForResend = false;
    static final long MAX_HOLE = 5000L;
    int printPacketsNminus = 0;
    ArrayList ooop = new ArrayList();
    int ooop_MAX = 80;
    int ooop_FAIL_ON_FYIS_ONLY = 20;
    long lastRecreated = -999L;
    InfiniteLoop il_subAddData = new InfiniteLoop();
    ObjectPool pool = new ObjectPool();

    public void setOptimisationFeed(NLOptimisationFeed feed) {
        this.OPT_FEED = feed;
    }

    public HoleyBigBuffer(NodeLink mynl, int ooopMax, int max_buffer, String threadPostfix) {
        this.mynl = mynl;
        this.ooop_MAX = ooopMax;
        this.max_buf = max_buffer;
        HoleRequestThread.register(this);
    }

    public long getSize() {
        while (true) {
            try {
                return this.getLengthOfAll();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private long getLengthOfAll() {
        return this.getEndOfAll() - this.getStartOfValids();
    }

    private long getStartOfValids() {
        if (this.valids.isEmpty()) {
            return this.startingPoint;
        }
        return ((Span)this.valids.getFirst()).start;
    }

    private long getEndOfValids() {
        if (this.valids.isEmpty()) {
            return this.startingPoint;
        }
        return ((Span)this.valids.getLast()).end;
    }

    private long getEndOfAll() {
        return Math.max(this.getEndOfValids(), this.getEndOfHoles());
    }

    private long getEndOfHoles() {
        if (this.holes.isEmpty()) {
            return this.startingPoint;
        }
        return ((Span)this.holes.getLast()).end;
    }

    private long getValidSoFar() {
        return this.startingPoint + this.getValidLength();
    }

    private long getValidLength() {
        if (this.valids.isEmpty()) {
            return 0L;
        }
        if (this.holes.isEmpty()) {
            Span first = (Span)this.valids.getFirst();
            Span last = (Span)this.valids.getLast();
            return last.end - first.start;
        }
        Span last = (Span)this.holes.getFirst();
        return Math.max(0L, last.start - this.startingPoint);
    }

    private void waitUntilData() {
        InfiniteLoop il = new InfiniteLoop();
        while (this.getValidLength() <= 0L && !this.isClosed) {
            il.LOOP();
            try {
                if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                    System.out.println("DELETEME - reading thread waiting for data (" + this.startingPoint + ", " + this.getValidLength() + ")");
                    this.printHoles();
                    this.printValids();
                }
                this.waitingForData = true;
                this.LOCK.wait();
                this.waitingForData = false;
                if (!NodeLink.VERBOSE_HOLEY_BIG_BUFFER) continue;
                System.out.println("DELETEME - reading thread told data is available " + this.getValidLength() + "");
                this.printHoles();
                this.printValids();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed() {
        this.isClosed = true;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.waitingForData) {
                this.LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(IOException t) {
        this.isClosed = true;
        this.fatalerror = t;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.waitingForData) {
                this.LOCK.notifyAll();
            }
        }
    }

    private void throwError() throws IOException {
        if (this.fatalerror != null) {
            IOException e = new IOException(this.fatalerror.getMessage());
            e.initCause(this.fatalerror);
            throw e;
        }
    }

    public void clearMaxReadRate() {
        this.maxKB = 0.0;
    }

    public double getMaxReadRate() {
        return this.maxKB;
    }

    private void bwRead(int len) {
        this.bwReadBytes += (long)len;
        long Tnow = SafeClock.currentTimeMillis();
        if (Tnow > this.bwReadFinish + this.BW_SAMPLE_MS) {
            long delta = Tnow - this.bwReadFinish;
            double kbPerSec = this.bwReadBytes;
            if ((kbPerSec /= (double)delta) > this.maxKB) {
                this.maxKB = kbPerSec;
            }
            this.bwReadBytes = 0L;
            this.bwReadFinish = Tnow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        this.il_read.reset();
        Object object = this.LOCK;
        synchronized (object) {
            while (this.read(this.readOne) == 0) {
                this.il_read.LOOP();
            }
            this.bwRead(1);
            return 0xFF & this.readOne[0];
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isClosed && this.getValidLength() == 0L) {
                this.throwError();
                return -1;
            }
            this.getNextData();
            if (this.isClosed && this.getValidLength() == 0L) {
                this.throwError();
                return -1;
            }
            int tmplen = this.dataBuf.length - this.dataPtr;
            if (tmplen <= length) {
                this.bwRead(tmplen);
                System.arraycopy(this.dataBuf, this.dataPtr, b, off, tmplen);
                this.dataPtr += tmplen;
                return tmplen;
            }
            this.bwRead(length);
            System.arraycopy(this.dataBuf, this.dataPtr, b, off, length);
            this.dataPtr += length;
            return length;
        }
    }

    private void dump(byte b) {
    }

    private void getNextData() {
        if (this.dataPtr >= this.dataBuf.length) {
            this.waitUntilData();
            if (!this.isClosed || this.getValidLength() > 0L) {
                this.dataBuf = (byte[])this.datas.removeFirst();
                Span tmp = (Span)this.valids.removeFirst();
                if (tmp.start != this.startingPoint) {
                    System.err.println("*** VALID START NOT SAME AS STARTING POINT " + tmp + " vs " + this.startingPoint);
                    System.exit(0);
                }
                this.doneWithSpan(tmp);
                this.startingPoint = tmp.end;
                this.byteCount += (long)this.dataBuf.length;
                if (this.byteCount != this.startingPoint) {
                    System.err.println("*** BYTE COUNT NOT SAME AS STARTING POINT " + tmp + ", " + this.byteCount + " vs " + this.startingPoint);
                    System.exit(0);
                }
                this.dataPtr = 0;
            }
            if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                System.out.println("[NL HBB] - reading thread freed up " + this.dataBuf.length + " of data, new starting point is " + this.startingPoint);
            }
            if (this.waitingForSpace) {
                this.LOCK.notifyAll();
                if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                    System.out.println("[NL HBB] - reading notified more space is available");
                }
            }
        }
    }

    public void fyi(long start) {
        if (start == 0L) {
            return;
        }
        if (this.restartSpan == null) {
            if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                System.out.println("[NL HBB] Incoming FYI current pos packet " + start);
            }
            this.subAddData(this.empty, start);
        }
    }

    public long addData(byte[] dat, long start) {
        return this.subAddData(dat, start);
    }

    void requestRestart(long from, long fyiHoleSize, String justification) {
        Span tmp = this.getHole(from, -1L, this.holesLogicalClock++, fyiHoleSize);
        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
            System.out.println("[NL HBB] had to request restart from " + tmp.start);
        }
        this.mynl.requestRestart(justification, tmp.holeClock, tmp.start, tmp.fyiHoleSize);
        tmp.updateClock(System.currentTimeMillis() + 500L);
        this.restartSpan = tmp;
    }

    void requestHole(Span hole) {
        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
            System.out.println("[NL HBB] had to request hole " + hole);
        }
        this.mynl.requestHolePatch(hole.holeClock, hole.start, hole.end);
        this.mynl.requestHolePatch(hole.holeClock, hole.start, hole.end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestAllHoles() throws IOException {
        if (!this.mynl.isAlive() && Switches.SH_1670_nlHrtQuitOnDeadNl) {
            throw new IOException("NL " + this.mynl + " is dead, unable to request further resends");
        }
        if (this.restartSpan != null || this.holes.size() > 0) {
            if (this.OPT_FEED != null && !this.waitingForResend) {
                this.waitingForResend = true;
                System.out.println("[NL Optimisation] Waiting for resend ->....");
                this.OPT_FEED.waitingForResend();
            }
            Object object = this.LOCK;
            synchronized (object) {
                long T = System.currentTimeMillis();
                for (int i = 0; i < this.holes.size(); ++i) {
                    Span hole = (Span)this.holes.get(i);
                    this.mynl.requestHolePatch(hole.holeClock, hole.start, hole.end);
                    hole.updateClock(T);
                }
                if (this.restartSpan != null) {
                    if (this.mynl == null) {
                        System.out.println("WARNING MYNL:" + this.mynl);
                    }
                    this.mynl.requestRestart("BigBuffer is full up but waiting for patches", this.restartSpan.holeClock, this.restartSpan.start, this.restartSpan.fyiHoleSize);
                    this.restartSpan.updateClock(T);
                }
            }
        } else if (this.OPT_FEED != null && this.waitingForResend) {
            this.waitingForResend = false;
            System.out.println("[NL Optimisation] Receiving fresh data ->->->");
            this.OPT_FEED.receivingFreshData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHole(long from, long to) {
        System.out.println("[NL HBB] Hole detected: " + from + " " + to + " (" + (to - from) + ")");
        Object object = this.LOCK;
        synchronized (object) {
            Span hole;
            while (to - from > 5000L) {
                hole = this.getHole(from, from + 5000L, this.holesLogicalClock++, 0L);
                from += 5000L;
                this.holes.addLast(hole);
                this.requestHole(hole);
            }
            if (to - from > 0L) {
                hole = this.getHole(from, to, this.holesLogicalClock++, 0L);
                from += 5000L;
                this.holes.addLast(hole);
                this.requestHole(hole);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void UNUSED_setExpectedLength(long max) {
        Object object = this.LOCK;
        synchronized (object) {
            long ourmax = Math.max(this.getEndOfValids(), this.getEndOfHoles());
            if (max > ourmax) {
                this.addHole(ourmax, max);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long subAddData(byte[] dat, long start) {
        long nextPacketRequired = this.getNextPacketRequired();
        int recreatedCount = 0;
        Object object = this.LOCK;
        synchronized (object) {
            byte[] recreated;
            while (nextPacketRequired != start && dat.length != 0 && (recreated = this.mynl.getRecreatedPacket(nextPacketRequired)) != null) {
                if (this.lastRecreated == nextPacketRequired) {
                    new Throwable("DUPLICATE RECREATION?").printStackTrace();
                }
                this.lastRecreated = nextPacketRequired;
                ++recreatedCount;
                this.subAddDataProcess(recreated, nextPacketRequired, false);
                nextPacketRequired = this.getNextPacketRequired();
            }
        }
        long ret = this.subAddDataProcess(dat, start, false);
        int ooopFilledCount = 0;
        if (ret != -1L) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                while (this.ooop.size() > 0) {
                    if (NodeLink.VERBOSE_OOOP) {
                        System.out.println("[NL HBB] " + this.ooop.size() + " cached ooo packets");
                    }
                    boolean usedOoop = false;
                    for (int i = 0; i < this.ooop.size(); ++i) {
                        Packet p = (Packet)this.ooop.get(i);
                        long nret = this.subAddDataProcess(p.dat, p.start, true);
                        if (nret != -1L) {
                            ++ooopFilledCount;
                            if (NodeLink.VERBOSE_OOOP) {
                                System.out.println("[NL HBB] Processed out of order packet " + p.start);
                            }
                            this.ooop.remove(i);
                            ret = nret;
                            usedOoop = true;
                            break;
                        }
                        if (nret != -5L) continue;
                        this.ooop.remove(i--);
                        if (!NodeLink.VERBOSE_OOOP) continue;
                        System.out.println("[NL HBB] Trimmed to " + this.ooop.size() + " cached ooo packets");
                    }
                    if (usedOoop) continue;
                    break;
                }
            }
        }
        if (recreatedCount > 0 || ooopFilledCount > 0) {
            System.out.println("[NL HBB] Patched RS=" + recreatedCount + " OOOP=" + ooopFilledCount);
            if (recreatedCount > 60) {
                this.mynl.requestSlowdown("large area");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextPacketRequired() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.restartSpan != null) {
                return this.restartSpan.start;
            }
            return this.getEndOfAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long subAddDataProcess(byte[] dat, long start, boolean fromCache) {
        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
            System.out.println("[NL HBB] incoming data packet (" + start + " - " + (start + (long)dat.length) + ")");
        }
        if (this.printPacketsNminus > 0) {
            --this.printPacketsNminus;
            System.out.println("[NL HBB] --p(" + (15 - this.printPacketsNminus) + ")-- " + start + " -> " + (start + (long)dat.length) + " (" + dat.length + ")");
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean inDetail = false;
            if (this.restartSpan != null) {
                if (start > this.restartSpan.start) {
                    if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                        System.out.println("[NL HBB] ignored " + start + " (!= " + this.restartSpan.start + ")");
                    }
                    return -1L;
                }
                if (start == this.restartSpan.start) {
                    System.out.println("[NL HBB] ***restart " + start + " (" + this.getEndOfAll() + ") picked up OK (+" + (start - this.oldRestartPoint) + "b since last one)");
                    this.oldRestartPoint = start;
                    this.restartSpan = null;
                    System.out.println("[NL HBB] ***restart " + start + " (" + this.getEndOfAll() + ") picked up OK (+" + (start - this.oldRestartPoint) + "b since last one)");
                    inDetail = true;
                }
            }
            long endAll = this.getEndOfAll();
            boolean DONT_PATCH_HOLES_JUST_RESTART = true;
            boolean DONT_MAKE_HOLES_AFTER_HOLES = false;
            if (start + (long)dat.length < endAll) {
                if (inDetail) {
                    System.out.println("[NL HBB] Remove from cache");
                }
                return -5L;
            }
            if (start > endAll) {
                if (inDetail) {
                    System.out.println("[NL HBB] Hole");
                }
                if (fromCache) {
                    return -1L;
                }
                if (DONT_PATCH_HOLES_JUST_RESTART || DONT_MAKE_HOLES_AFTER_HOLES && endAll > this.getEndOfValids()) {
                    if (dat.length == 0 || this.ooop.size() == 0 || this.ooop.size() % 40 == 0 || this.ooop.size() == this.ooop_MAX) {
                        if (this.ooop.size() == this.ooop_MAX) {
                            System.out.println("[HoleyBigBuffer] Expected " + endAll + ", Got " + start + " (" + (endAll - start) + ") " + (dat.length == 0 ? "(FYI)" : "(Data)") + " (ooop=" + this.ooop.size() + " max)");
                        } else {
                            System.out.println("[HoleyBigBuffer] Expected " + endAll + ", Got " + start + " (" + (endAll - start) + ") " + (dat.length == 0 ? "(FYI)" : "(Data)") + " (ooop=" + this.ooop.size() + ")");
                        }
                    }
                    boolean noRealDataComingThrough = false;
                    if (this.ooop.size() > this.ooop_FAIL_ON_FYIS_ONLY) {
                        boolean allFYI = true;
                        for (int i = this.ooop.size() - this.ooop_FAIL_ON_FYIS_ONLY; i < this.ooop.size(); ++i) {
                            Packet packet = (Packet)this.ooop.get(i);
                            if (packet.dat.length <= 0) continue;
                            allFYI = false;
                        }
                        if (allFYI) {
                            noRealDataComingThrough = true;
                        }
                    }
                    if (!noRealDataComingThrough && this.ooop.size() < this.ooop_MAX) {
                        this.ooop.add(new Packet(dat, start));
                    } else {
                        this.ooop.clear();
                        this.mynl.dumpRecreatedPacketFail(this.getNextPacketRequired());
                        this.requestRestart(endAll, endAll - start, "ooop maxed out");
                    }
                    return -1L;
                }
                this.addHole(endAll, start);
                endAll = this.getEndOfAll();
            }
            if (dat.length > 0) {
                if (inDetail) {
                    System.out.println("[NL HBB] Non empty packet");
                }
                if (start == endAll) {
                    if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                        System.out.println("[NL HBB] valid latest data  (" + start + " == " + endAll + ")");
                    }
                    boolean printValids = false;
                    this.il_subAddData.reset();
                    while (!((long)dat.length + this.getLengthOfAll() + (long)(this.dataBuf.length - this.dataPtr) <= (long)this.max_buf || this.valids.isEmpty() && this.holes.isEmpty() || this.max_buf < 0)) {
                        this.il_subAddData.LOOP();
                        if (this.holes.size() > 0) {
                            NodeLink.VERBOSE_HOLEY_BIG_BUFFER = true;
                            if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                                System.out.println("[NL HBB] full up and unable to wait for space (" + this.waitingForData + ")");
                            }
                            this.printHoles();
                            this.printValids();
                            NodeLink.VERBOSE_HOLEY_BIG_BUFFER = false;
                            if (this.restartSpan == null) {
                                this.requestRestart(endAll, 0L, "ooop not maxed out");
                            }
                            return -1L;
                        }
                        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                            System.out.println("[NL HBB] waiting for space (" + this.waitingForData + ")");
                        }
                        this.waitingForSpace = true;
                        try {
                            this.LOCK.wait();
                        }
                        catch (InterruptedException allFYI) {
                            // empty catch block
                        }
                        this.waitingForSpace = false;
                        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                            System.out.println("[NL HBB] got space (" + this.waitingForData + ")");
                        }
                        printValids = true;
                    }
                    this.datas.addLast(dat);
                    Span span = this.getValidSpan(start, start + (long)dat.length);
                    this.valids.addLast(span);
                    if (printValids) {
                        this.printHoles();
                        this.printValids();
                    }
                    if (this.waitingForData) {
                        this.LOCK.notify();
                    }
                    if (this.holes.size() == 0) {
                        return this.getValidSoFar();
                    }
                    return -1L;
                }
                if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                    System.out.println("[NL HBB] patch (" + start + " < " + endAll + ")");
                }
                boolean applied = false;
                boolean firstHole = true;
                for (int i = 0; i < this.holes.size(); ++i) {
                    Span hole = (Span)this.holes.get(i);
                    if (start == hole.start) {
                        if (start + (long)dat.length != hole.end) {
                            return -1L;
                        }
                        applied = true;
                        System.out.println("DELETEME applied patch to " + hole);
                        this.printHoles();
                        this.holes.remove(i--);
                        this.printHoles();
                        this.printValids();
                        boolean added = false;
                        if (this.valids.size() == 0) {
                            this.valids.add(hole);
                            this.datas.add(dat);
                            added = true;
                        } else {
                            for (int k = 0; k < this.valids.size(); ++k) {
                                Span valid = (Span)this.valids.get(k);
                                if (start < valid.start) {
                                    this.valids.add(k, hole);
                                    this.datas.add(k, dat);
                                    added = true;
                                    break;
                                }
                                if (valid.end == start) {
                                    this.valids.add(k + 1, hole);
                                    this.datas.add(k + 1, dat);
                                    added = true;
                                    break;
                                }
                                if (k != this.valids.size() - 1 || start <= valid.end) continue;
                                this.valids.add(hole);
                                this.datas.add(dat);
                                added = true;
                            }
                        }
                        if (!added) {
                            System.err.println("*** VALID " + hole + " NOT ADDED TO LIST FOR SOME REASON");
                            this.printValids();
                            System.exit(0);
                        }
                        this.printValids();
                        if (!firstHole || !this.waitingForData) break;
                        this.LOCK.notify();
                        break;
                    }
                    firstHole = false;
                }
                if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER && applied) {
                    System.out.println("[NL HBB] patch just didn't match at all");
                }
                if (firstHole) {
                    return this.getValidSoFar();
                }
                return -1L;
            }
            if (inDetail) {
                System.out.println("[NL HBB] Empty packet");
            }
            if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                System.out.println("[NL HBB] Empty packet before current valid position");
            }
            return -1L;
        }
    }

    private void printValids() {
        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
            System.out.println("Valids:");
            for (int i = 0; i < this.valids.size(); ++i) {
                System.out.println(this.valids.get(i));
            }
        }
    }

    private void printHoles() {
        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
            System.out.println("Holes:");
            for (int i = 0; i < this.holes.size(); ++i) {
                System.out.println(this.holes.get(i));
            }
        }
    }

    private Span getValidSpan(long start, long end) {
        Span span = (Span)this.pool.getFromPool();
        if (span == null) {
            span = new Span();
        }
        span.start = start;
        span.end = end;
        return span;
    }

    private Span getHole(long start, long end, long holeClock, long fyiHoleSize) {
        if (NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
            if (end == -1L) {
                System.out.println("[NL HBB]    adding restart hole: " + start + " " + end + " (" + (end != -1L ? "" + (end - start) : "-") + ")");
            } else {
                System.out.println("[NL HBB]    adding hole: " + start + " " + end + " (" + (end != -1L ? "" + (end - start) : "-") + ")");
            }
        }
        Span tmp = this.getValidSpan(start, end);
        tmp.holeClock = holeClock;
        tmp.realClock = System.currentTimeMillis();
        tmp.fyiHoleSize = fyiHoleSize;
        return tmp;
    }

    private void doneWithSpan(Span span) {
        this.pool.returnToPool(span);
    }

    class Packet {
        byte[] dat;
        long start;

        public Packet(byte[] dat, long start) {
            this.dat = dat;
            this.start = start;
        }
    }

    class Span {
        long start;
        long end;
        long holeClock;
        long realClock;
        long myClockCount = 0L;
        long fyiHoleSize;

        Span() {
        }

        public String toString() {
            return "(" + this.start + " - " + this.end + " clock=" + this.holeClock + ")";
        }

        public void updateClock(long tnow) {
            long updateTime = HoleyBigBuffer.this.mynl.getLatestRTT() + 100L + 500L + Math.min(2000L, this.myClockCount * 250L);
            updateTime = (long)((double)updateTime * 1.1);
            updateTime = Math.max(200L, updateTime);
            if (tnow - this.realClock > (updateTime = Math.min(5000L, updateTime))) {
                if (this.end == -1L && NodeLink.VERBOSE_HOLEY_BIG_BUFFER) {
                    System.out.println("[NL HBB] restart span clock updated (every " + updateTime + ") (based on rtt=" + HoleyBigBuffer.this.mynl.getLatestRTT() + ")");
                }
                ++this.myClockCount;
                this.holeClock = HoleyBigBuffer.this.holesLogicalClock++;
                this.realClock = tnow;
            }
        }

        public void forceUpdateClock() {
            this.holeClock = HoleyBigBuffer.this.holesLogicalClock++;
        }
    }
}

