/*
 * Decompiled with CFR 0.152.
 */
package com.aem;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import jwrapper.crypt.jz.GZIPInputStream;
import jwrapper.crypt.jz.GZIPOutputStream;
import jwrapper.crypt.jz.marker.ByteArrayStreamMatcher;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.progtools.collections.FixedSizeMap;
import utils.progtools.streams.RandomAccessFileInputStream;
import utils.stream.StreamUtils;
import utils.string.Base64;

public class SaltedFileUtil {
    private SaltedFileUtilCache cache;
    private final String key;
    private final ArrayList<String> keys = new ArrayList();
    private boolean multiKeyMode = false;
    private final int work;
    private final boolean compress;
    private final boolean useAFOS;
    private boolean syncFlush;
    private byte[] logsMarker;
    private long minBytesBetweenMarkers;

    public SaltedFileUtil(String key, int work, int cacheSize) {
        this(key, work, true, cacheSize);
    }

    public SaltedFileUtil(String key, int work, boolean compress, int cacheSize) {
        this(key, work, compress, true, cacheSize);
    }

    public SaltedFileUtil(String key, int work, boolean compress, boolean useAFOS, int cacheSize) {
        this.useAFOS = useAFOS;
        this.key = key;
        this.work = work;
        this.compress = compress;
        this.cache = new SaltedFileUtilCache(Math.max(1, cacheSize));
    }

    public static SaltedFileUtil initWithBase64Key(String base64Key, int work, boolean compress, int cacheSize) {
        return SaltedFileUtil.initWithBase64Key(base64Key, work, compress, true, cacheSize);
    }

    public static SaltedFileUtil initWithBase64Key(String base64Key, int work, boolean compress, boolean useAFOS, int cacheSize) {
        return new SaltedFileUtil(new String(Base64.base64ToByteArray((String)base64Key), StandardCharsets.UTF_8), work, compress, useAFOS, cacheSize);
    }

    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }

    public OutputStream saveToStream(String id, OutputStream out) throws IOException {
        SaltedFileUtilCacheEntry cacheEntry = this.cache.getCacheEntryFor(id, null, this.getLastKeyIndex());
        try {
            StreamUtils.writeStringUTF8((OutputStream)out, (String)cacheEntry.salt);
            if (this.multiKeyMode) {
                StreamUtils.writeInt((OutputStream)out, (int)this.getLastKeyIndex());
            }
            BCUtilOutputStream bcout = new BCUtilOutputStream(out, cacheEntry.bcUtil, this.logsMarker, this.minBytesBetweenMarkers);
            if (this.compress) {
                GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)bcout);
                gzout.setSyncFlush(this.syncFlush);
                return gzout;
            }
            return bcout;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public OutputStream saveFileAsStream(String id, File file, boolean append) throws IOException {
        SaltedFileUtilCacheEntry cacheEntry = this.cache.getCacheEntryFor(id, null, this.getLastKeyIndex());
        Object afos = append && file.exists() || !this.useAFOS ? new BufferedOutputStream(new FileOutputStream(file, true)) : new AtomicFileOutputStream(file);
        try {
            StreamUtils.writeStringUTF8((OutputStream)afos, (String)cacheEntry.salt);
            if (this.multiKeyMode) {
                StreamUtils.writeInt((OutputStream)afos, (int)this.getLastKeyIndex());
            }
            BCUtilOutputStream bcout = new BCUtilOutputStream((OutputStream)afos, cacheEntry.bcUtil, this.logsMarker, this.minBytesBetweenMarkers);
            if (this.compress) {
                GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)bcout);
                gzout.setSyncFlush(this.syncFlush);
                return gzout;
            }
            return bcout;
        }
        catch (Throwable t) {
            FileUtil.robustClose((OutputStream)afos);
            throw new IOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String id, File file, byte[] data) throws IOException {
        OutputStream outputStream = this.saveFileAsStream(id, file, false);
        try {
            outputStream.write(data);
        }
        finally {
            FileUtil.robustClose((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(String id, File file) throws IOException {
        InputStream inputStream = this.loadFileAsStream(id, file);
        try {
            byte[] byArray = StreamUtils.readAll((InputStream)inputStream);
            return byArray;
        }
        finally {
            FileUtil.robustClose((InputStream)inputStream);
        }
    }

    public InputStream loadFileAsStream(String id, File file) throws IOException {
        if (this.useAFOS) {
            AtomicFileOutputStream.prepareForReading((File)file);
        }
        FileInputStream fin = new FileInputStream(file);
        try {
            try {
                return this.loadFromStream(id, fin);
            }
            catch (IOException ex) {
                if (ex.getMessage().equals("Bad message size")) {
                    FileUtil.robustClose((InputStream)fin);
                    System.out.println("REMOVING " + id);
                    this.cache.idToEntryMap.remove(id);
                    fin = new FileInputStream(file);
                    return this.loadFromStream(id, fin);
                }
                throw ex;
            }
        }
        catch (Throwable t) {
            FileUtil.robustClose((InputStream)fin);
            throw new IOException(t);
        }
    }

    public InputStream loadFileAsStream(String id, File file, long offset) throws IOException {
        if (offset <= 0L) {
            return this.loadFileAsStream(id, file);
        }
        if (this.useAFOS) {
            AtomicFileOutputStream.prepareForReading((File)file);
        }
        RandomAccessFileInputStream rafis = new RandomAccessFileInputStream(file);
        try {
            String salt = StreamUtils.readNStringUTF8((InputStream)rafis, (int)100);
            int keyIndex = 0;
            if (this.multiKeyMode) {
                keyIndex = StreamUtils.readInt((InputStream)rafis);
            }
            BCUtil bcUtil = this.cache.getBCUtilFor(id, salt, keyIndex);
            rafis.seek(offset);
            BufferedInputStream bin = new BufferedInputStream(rafis);
            ByteArrayStreamMatcher matcher = new ByteArrayStreamMatcher(this.logsMarker);
            if (!matcher.readUntilMatch((InputStream)bin)) {
                FileUtil.robustClose((InputStream)bin);
                return null;
            }
            BCUtilInputStream bcin = new BCUtilInputStream((InputStream)bin, bcUtil, this.logsMarker, this.minBytesBetweenMarkers);
            if (this.compress) {
                return new GZIPInputStream((InputStream)bcin);
            }
            return bcin;
        }
        catch (Throwable t) {
            FileUtil.robustClose((InputStream)rafis);
            throw new IOException(t);
        }
    }

    public InputStream loadFromStream(String id, InputStream in) throws IOException {
        String salt = StreamUtils.readNStringUTF8((InputStream)in, (int)100);
        int keyIndex = 0;
        if (this.multiKeyMode) {
            keyIndex = StreamUtils.readInt((InputStream)in);
        }
        BCUtil bcUtil = this.cache.getBCUtilFor(id, salt, keyIndex);
        BCUtilInputStream bcin = new BCUtilInputStream(in, bcUtil, this.logsMarker, this.minBytesBetweenMarkers);
        if (this.compress) {
            return new GZIPInputStream((InputStream)bcin);
        }
        return bcin;
    }

    public static void main(String[] args) throws IOException {
        File[] files;
        SaltedFileUtil saltedFileUtil = SaltedFileUtil.initWithBase64Key("ArqNnu5755CxDMdU83fCcibdYrbE3sMOr8+ikc4f2aD2OFkNflvONtQrkqoGofKoT42bt+5KRZFgH/NbcDKlCg==", 200, true, 1);
        for (File file : files = FileUtil.deepList((File)new File("/Users/gchristelis/Desktop/v4-accounts"))) {
            if (!file.getName().endsWith("enc")) continue;
            try {
                byte[] bytes = saltedFileUtil.readFile(file.getAbsolutePath(), file);
                System.out.println("[OK] " + file);
            }
            catch (Throwable t) {
                System.out.println("[FAIL] " + file);
            }
        }
        SaltedFileUtil test = new SaltedFileUtil(";sdkfjlsdkjfl;sakdjf", 200, false, true, 1);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStream outputStream = test.saveToStream(null, bout);
        outputStream.write(1);
        outputStream.write(2);
        outputStream.write(3);
        outputStream.close();
        byte[] data = bout.toByteArray();
        InputStream inputStream = test.loadFromStream(null, new ByteArrayInputStream(data));
        System.out.println(inputStream.read());
        System.out.println(inputStream.read());
        System.out.println(inputStream.read());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKey(int keyIndex) {
        ArrayList<String> arrayList = this.keys;
        synchronized (arrayList) {
            return this.keys.get(keyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKey(String key) {
        ArrayList<String> arrayList = this.keys;
        synchronized (arrayList) {
            this.keys.add(key);
        }
    }

    public void setMarker(byte[] logsMarker, long minBytesBetweenMarkers) {
        this.logsMarker = logsMarker;
        this.minBytesBetweenMarkers = minBytesBetweenMarkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastKeyIndex() {
        if (!this.multiKeyMode) {
            return 0;
        }
        ArrayList<String> arrayList = this.keys;
        synchronized (arrayList) {
            return this.keys.size() - 1;
        }
    }

    public void setMultipleKeyMode() {
        if (!this.multiKeyMode) {
            this.multiKeyMode = true;
            this.keys.add(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKeys() {
        ArrayList<String> arrayList = this.keys;
        synchronized (arrayList) {
            return this.keys.toArray(new String[0]);
        }
    }

    public class SaltedFileUtilCache {
        private final FixedSizeMap<String, SaltedFileUtilCacheEntry> idToEntryMap;

        public SaltedFileUtilCache(int cacheSize) {
            this.idToEntryMap = new FixedSizeMap(10, cacheSize);
        }

        private String generateSalt() throws UnsupportedEncodingException {
            return BCUtil.generateBase64Salt((int)32);
        }

        private BCUtil getBCUtilFor(String id, String salt, int keyIndex) throws UnsupportedEncodingException {
            return this.getCacheEntryFor((String)id, (String)salt, (int)keyIndex).bcUtil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SaltedFileUtilCacheEntry getCacheEntryFor(String id, String saltOrNull, int keyIndex) throws UnsupportedEncodingException {
            FixedSizeMap<String, SaltedFileUtilCacheEntry> fixedSizeMap = this.idToEntryMap;
            synchronized (fixedSizeMap) {
                SaltedFileUtilCacheEntry saltedFileUtilCacheEntry;
                if (id != null && (saltedFileUtilCacheEntry = (SaltedFileUtilCacheEntry)this.idToEntryMap.get(id)) != null && saltedFileUtilCacheEntry.bcUtil != null) {
                    return saltedFileUtilCacheEntry;
                }
                SaltedFileUtilCacheEntry entry = new SaltedFileUtilCacheEntry();
                entry.salt = saltOrNull == null ? this.generateSalt() : saltOrNull;
                entry.bcUtil = new BCUtil();
                if (SaltedFileUtil.this.multiKeyMode) {
                    entry.bcUtil.initFromSecret(entry.salt, SaltedFileUtil.this.getKey(keyIndex), SaltedFileUtil.this.work);
                } else {
                    entry.bcUtil.initFromSecret(entry.salt, SaltedFileUtil.this.key, SaltedFileUtil.this.work);
                }
                if (id != null) {
                    this.idToEntryMap.put(id, entry);
                }
                return entry;
            }
        }
    }

    public class SaltedFileUtilCacheEntry {
        String salt;
        BCUtil bcUtil;
    }
}

