/*
 * Decompiled with CFR 0.152.
 */
package com.aem;

import jwrapper.jwutils.JWJreVerifierApp;
import utils.ostools.OS;

public class JreVerifier {
    public static void main(String[] args) {
        boolean is64bit;
        String version = System.getProperty("java.version");
        String vendor = System.getProperty("java.vendor");
        String vendorurl = System.getProperty("java.vendor.url");
        String vminfo = System.getProperty("java.vm.info");
        String vmname = System.getProperty("java.vm.name");
        String sunarch = System.getProperty("sun.arch.data.model");
        System.out.println("[SH JRE Verifier] Version: " + version);
        System.out.println("[SH JRE Verifier] Vendor: " + vendor);
        System.out.println("[SH JRE Verifier] Vendor URL: " + vendorurl);
        System.out.println("[SH JRE Verifier] VM Info: " + vminfo);
        System.out.println("[SH JRE Verifier] VM Name: " + vmname);
        System.out.println("[SH JRE Verifier] Sun Arch: " + sunarch);
        try {
            if (sunarch.trim().length() == 0) {
                sunarch = null;
            }
            is64bit = sunarch.contains("64");
        }
        catch (Exception x) {
            is64bit = vmname.contains("64");
        }
        if (OS.isMacOS() && OS.isMacOS1073OrLater() && !is64bit) {
            System.out.println("[SH JRE Verifier] JRE is NOT SUPPORTED - 32 bit JVM on MacOS 10.7.3 or later");
            JWJreVerifierApp.exitJvm_JreIsNotSupported();
        }
        boolean isVersionOK = false;
        if (OS.isMacOS()) {
            if (version.startsWith("1.8")) {
                isVersionOK = true;
            }
        } else if (version.startsWith("1.7") || version.startsWith("1.8")) {
            isVersionOK = true;
        }
        if (isVersionOK) {
            if (vendorurl.contains("java.sun.com") || vendorurl.contains("java.oracle.com") || vendor.contains("Sun Microsystems") || vendor.contains("Oracle")) {
                System.out.println("[SH JRE Verifier] JRE is OK");
                JWJreVerifierApp.exitJvm_JreIsSupported();
            } else {
                System.out.println("[SH JRE Verifier] JRE is NOT SUPPORTED - Not a Sun/Oracle JVM");
                JWJreVerifierApp.exitJvm_JreIsNotSupported();
            }
        } else {
            System.out.println("[SH JRE Verifier] JRE is NOT SUPPORTED - Not a 1.8 JVM");
            JWJreVerifierApp.exitJvm_JreIsNotSupported();
        }
    }
}

