/*
 * Decompiled with CFR 0.152.
 */
package utils.sync;

import utils.progtools.IdentiThread;
import utils.sync.QueuedBlockingMap;
import utils.sync.UnqueuedSemaphore;

public class ThreadPool {
    int total = 0;
    UnqueuedSemaphore sem = new UnqueuedSemaphore(1);
    QueuedBlockingMap map = new QueuedBlockingMap();
    UnqueuedSemaphore conc;
    boolean exit = false;
    AllocatorThread at = new AllocatorThread();

    public ThreadPool(int maxConcurrency) {
        this.conc = new UnqueuedSemaphore(maxConcurrency + 1);
        this.at.start();
    }

    public void run(Runnable r) {
        try {
            ++this.total;
            this.map.put("x", r);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void joinAll() {
        this.sem.doWait(this.total);
        this.exit = true;
        try {
            this.at.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        long t = System.currentTimeMillis();
        ThreadPool pool = new ThreadPool(10);
        for (int i = 0; i < 100; ++i) {
            pool.run((Runnable)new IdentiThread(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("done");
                }
            });
        }
        System.out.println(System.currentTimeMillis() - t);
        pool.joinAll();
        System.out.println(System.currentTimeMillis() - t);
    }

    class PoolThread
    extends IdentiThread {
        Runnable r;

        public PoolThread(Runnable r) {
            this.r = r;
        }

        public void run() {
            try {
                this.r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ThreadPool.this.conc.doSignal(1);
            ThreadPool.this.sem.doSignal(1);
        }
    }

    class AllocatorThread
    extends IdentiThread {
        AllocatorThread() {
        }

        public void run() {
            while (!ThreadPool.this.exit) {
                try {
                    ThreadPool.this.conc.doWait(1);
                    Runnable r = (Runnable)ThreadPool.this.map.get("x");
                    new PoolThread(r).start();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

