/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import utils.swing.utils.LoadStateThread;
import utils.swing.utils.SaveStateThread;
import utils.swing.utils.StaticSaveStateThread;
import utils.swing.utils.TreeState;

public class TreeUtil {
    private static HashMap TREE_LOCK_MAP = new HashMap();

    public static ArrayList<TreeNode> treeModelAsList(TreeModel model) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeUtil.nodesAsList((TreeNode)model.getRoot(), list);
        return list;
    }

    public static ArrayList<TreeNode> nodesAsList(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeUtil.nodesAsList(node, list);
        return list;
    }

    public static Object getUserObject(TreeNode node) {
        return ((DefaultMutableTreeNode)node).getUserObject();
    }

    public static void nodesAsList(TreeNode node, ArrayList<TreeNode> list) {
        list.add(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtil.nodesAsList(node.getChildAt(i), list);
        }
    }

    public static Object blockSelectionEvents(JTree tree) {
        TreeSelectionListener[] listeners = tree.getTreeSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            tree.removeTreeSelectionListener(listeners[i]);
        }
        return listeners;
    }

    public static void restoreSelectionEvents(JTree tree, Object listeners) {
        TreeSelectionListener[] list = (TreeSelectionListener[])listeners;
        for (int i = 0; i < list.length; ++i) {
            tree.addTreeSelectionListener(list[i]);
        }
    }

    public static void updateUI(JTree tree) {
        if (SwingUtilities.isEventDispatchThread()) {
            new TreeUpdate(tree).run();
        } else {
            SwingUtilities.invokeLater(new TreeUpdate(tree));
        }
    }

    public static void ensureRootsVisible(JTree tree) {
        if (!tree.isRootVisible()) {
            TreeModel model = tree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[2];
            path[0] = root;
            for (int i = 0; i < model.getChildCount(root); ++i) {
                Object expandy;
                path[1] = expandy = model.getChild(root, i);
                tree.expandPath(new TreePath(path));
            }
        } else {
            tree.expandRow(0);
        }
    }

    public static void expandTree(JTree tree) {
        TreeModel model = tree.getModel();
        TreeUtil.expandNode(tree, model, model.getRoot(), new Object[0], 0, 1000000);
    }

    public static void expandTree(JTree tree, int maxdepth) {
        TreeModel model = tree.getModel();
        TreeUtil.expandNode(tree, model, model.getRoot(), new Object[0], 0, maxdepth);
    }

    public static void expandBySearch(JTree tree, Object userObject) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtil.expandBySearch(tree, root, userObject);
    }

    private static boolean expandBySearch(JTree tree, TreeNode parent, Object userObject) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode node = parent.getChildAt(i);
            DefaultMutableTreeNode dm = (DefaultMutableTreeNode)node;
            Object o = dm.getUserObject();
            boolean thisOne = false;
            if (o == null) {
                if (userObject == null) {
                    thisOne = true;
                }
            } else if (o == userObject) {
                thisOne = true;
            } else if (o.equals(userObject)) {
                thisOne = true;
            }
            if (thisOne) {
                TreePath path = new TreePath(dm.getPath());
                tree.expandPath(path);
                return true;
            }
            if (!TreeUtil.expandBySearch(tree, node, userObject)) continue;
            return true;
        }
        return false;
    }

    private static void expandNode(JTree tree, TreeModel model, Object o, Object[] parents, int cur, int max) {
        if (cur > max) {
            return;
        }
        Object[] tmp = new Object[parents.length + 1];
        for (int i = 0; i < parents.length; ++i) {
            tmp[i] = parents[i];
        }
        tmp[parents.length] = o;
        TreePath path = new TreePath(tmp);
        tree.expandPath(path);
        for (int i = 0; i < model.getChildCount(o); ++i) {
            TreeUtil.expandNode(tree, model, model.getChild(o, i), tmp, cur + 1, max);
        }
    }

    public static void collapseTree(JTree tree, int maxdepth) {
        TreeModel model = tree.getModel();
        TreeUtil.collapseNode(tree, model, model.getRoot(), new Object[0], 0, maxdepth);
        if (!tree.isRootVisible()) {
            tree.expandPath(new TreePath(model.getRoot()));
        }
    }

    private static void collapseNode(JTree tree, TreeModel model, Object o, Object[] parents, int cur, int max) {
        int i;
        if (cur > max) {
            return;
        }
        Object[] tmp = new Object[parents.length + 1];
        for (i = 0; i < parents.length; ++i) {
            tmp[i] = parents[i];
        }
        tmp[parents.length] = o;
        for (i = 0; i < model.getChildCount(o); ++i) {
            TreeUtil.collapseNode(tree, model, model.getChild(o, i), tmp, cur + 1, max);
        }
        TreePath path = new TreePath(tmp);
        tree.collapsePath(path);
    }

    public static void saveState(JTree tree, TreeState state) {
        if (tree == null) {
            return;
        }
        StaticSaveStateThread saveState = new StaticSaveStateThread(tree, state);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(saveState);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            saveState.run();
        }
    }

    public static Object saveState(JTree tree) {
        if (tree == null) {
            return null;
        }
        SaveStateThread saveState = new SaveStateThread(tree);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(saveState);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            saveState.run();
        }
        return saveState.getState();
    }

    public static void loadState(JTree sgMachineTree, Object stateObject) {
        if (sgMachineTree != null && stateObject != null) {
            TreeUtil.loadState(sgMachineTree, stateObject, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getLockForTree(JTree tree) {
        HashMap hashMap = TREE_LOCK_MAP;
        synchronized (hashMap) {
            Object lock = TREE_LOCK_MAP.get(tree);
            if (lock == null) {
                lock = new Object();
                TREE_LOCK_MAP.put(tree, lock);
            }
            return lock;
        }
    }

    public static void loadState(JTree tree, Object stateObject, Comparator recreateComparator) {
        LoadStateThread thread = new LoadStateThread(tree, (TreeState)stateObject, recreateComparator);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(thread);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            thread.run();
        }
    }

    public static Object[] getSelected(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return new Object[0];
        }
        ArrayList<Object> pathList = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            if (path == null) continue;
            pathList.add(path.getLastPathComponent());
        }
        return pathList.toArray();
    }

    public static Object getSingleSelected(JTree tree) {
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            return path.getLastPathComponent();
        }
        return null;
    }

    public static void setSelected(JTree tree, Object o) {
        if (o == null) {
            tree.setSelectionPath(null);
        } else {
            TreeModel model = tree.getModel();
            Object root = model.getRoot();
            Stack stack = new Stack();
            TreeUtil.setSelected(stack, tree, root, o);
        }
    }

    public static void setSelected(Stack stack, JTree tree, Object node, Object toSelect) {
        stack.push(node);
        if (node.equals(toSelect)) {
            Object[] path = new Object[]{};
            for (int i = 0; i < stack.size(); ++i) {
                Object[] npath = new Object[path.length + 1];
                System.arraycopy(path, 0, npath, 0, path.length);
                path = npath;
                path[i] = stack.get(i);
                if (i == stack.size() - 1) {
                    tree.setSelectionPath(new TreePath(path));
                    continue;
                }
                tree.expandPath(new TreePath(path));
            }
        } else {
            TreeModel model = tree.getModel();
            for (int i = 0; i < model.getChildCount(node); ++i) {
                Object child = model.getChild(node, i);
                TreeUtil.setSelected(stack, tree, child, toSelect);
            }
        }
        stack.pop();
    }

    private static class TreeUpdate
    implements Runnable {
        JTree tree;

        public TreeUpdate(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void run() {
            this.tree.updateUI();
        }
    }
}

