/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.utils;

import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.utils.TreeState;

public class LoadStateThread
implements Runnable {
    JTree tree;
    TreeState state;
    Comparator recreateComparator;

    public LoadStateThread(JTree tree, TreeState state, Comparator recreateComparator) {
        this.tree = tree;
        this.recreateComparator = recreateComparator;
        this.state = state;
    }

    @Override
    public void run() {
        if (this.recreateComparator != null) {
            LoadStateThread.recreateTreeStateByComparison(this.state, this.tree, this.recreateComparator);
        }
        for (int i = 0; i < this.state.expanded.size(); ++i) {
            TreePath path = (TreePath)this.state.expanded.get(i);
            this.tree.expandPath(path);
        }
        this.tree.setSelectionPaths(this.state.selection);
        if (this.state.selection != null) {
            TreePath[] paths = new TreePath[this.state.selection.length];
            for (int i = 0; i < this.state.selection.length; ++i) {
                TreePath path;
                paths[i] = path = this.state.selection[i];
            }
            this.tree.setSelectionPaths(paths);
        }
        this.tree.repaint();
    }

    private static void recreateTreeStateByComparison(TreeState state, JTree tree, Comparator c) {
        int i;
        if (state.selection != null) {
            for (i = 0; i < state.selection.length; ++i) {
                state.selection[i] = LoadStateThread.recreateTreePathByComparison(state.selection[i], tree, c);
            }
        }
        for (i = 0; i < state.expanded.size(); ++i) {
            state.expanded.set(i, LoadStateThread.recreateTreePathByComparison((TreePath)state.expanded.get(i), tree, c));
        }
    }

    private static TreePath recreateTreePathByComparison(TreePath path, JTree tree, Comparator c) {
        int index;
        Object[] list = path.getPath();
        TreeModel model = tree.getModel();
        Object o = model.getRoot();
        if (c.compare(o, list[index = 0]) == 0) {
            list[index] = o;
            ++index;
        }
        for (int i = 0; i < model.getChildCount(o) && index < list.length; ++i) {
            Object test = model.getChild(o, i);
            if (c.compare(list[index], test) != 0) continue;
            list[index] = test;
            ++index;
            o = test;
            i = -1;
        }
        path = new TreePath(list);
        return path;
    }
}

