/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import aurelienribon.tweenengine.TweenEquation;
import aurelienribon.tweenengine.TweenManager;
import aurelienribon.tweenengine.equations.Quint;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;

public class AnimCardPanel
extends SLPanel {
    public static final SLSide TOP = SLSide.TOP;
    public static final SLSide BOTTOM = SLSide.BOTTOM;
    public static final SLSide LEFT = SLSide.LEFT;
    public static final SLSide RIGHT = SLSide.RIGHT;
    private double DEF_SECONDS = 0.6;
    private TweenManager manager;
    private JComponent current;
    private boolean skipHistory = false;
    private final Object history_LOCK = new Object();
    private ArrayList<Back> history = new ArrayList();
    long lastCardShown = 0L;

    public AnimCardPanel() {
        this.manager = SLAnimator.createTweenManager();
        this.setTweenManager(this.manager);
    }

    private SLConfig getBasicConfig(JComponent showme) {
        return new SLConfig(this).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, showme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHistory() {
        Object object = this.history_LOCK;
        synchronized (object) {
            return this.history.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void back() {
        Object object = this.history_LOCK;
        synchronized (object) {
            if (this.history.size() == 0) {
                return;
            }
            Back back = this.history.remove(this.history.size() - 1);
            this.skipHistory = true;
            try {
                this.showCard(back.showme, back.side, back.seconds, back.reverseTransition);
            }
            finally {
                this.skipHistory = false;
            }
        }
    }

    public long getLastCardShown() {
        return this.lastCardShown;
    }

    public void showInstantCard(JComponent showme) {
        this.lastCardShown = System.currentTimeMillis();
        this.initialize(this.getBasicConfig(showme));
        this.current = showme;
    }

    public static SLSide opposite(SLSide side) {
        if (side == TOP) {
            return BOTTOM;
        }
        if (side == BOTTOM) {
            return TOP;
        }
        if (side == RIGHT) {
            return LEFT;
        }
        if (side == LEFT) {
            return RIGHT;
        }
        return LEFT;
    }

    public void showCard(JComponent showme, SLSide side) {
        this.showCard(showme, side, this.DEF_SECONDS, false);
    }

    public void showCard(JComponent showme, SLSide side, double seconds) {
        this.showCard(showme, side, seconds, false);
    }

    public void showCard(JComponent showme, SLSide side, boolean reverseTransition) {
        this.showCard(showme, side, this.DEF_SECONDS, reverseTransition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCard(JComponent showme, SLSide side, double seconds, boolean reverseTransition) {
        SLTransition trans;
        this.lastCardShown = System.currentTimeMillis();
        if (this.isShowing(showme)) {
            return;
        }
        if (!this.isInitialized()) {
            this.showInstantCard(showme);
            return;
        }
        showme.setSize(new Dimension(0, 0));
        SLConfig config = this.getBasicConfig(showme);
        if (reverseTransition) {
            trans = new SLTransition(this, this.manager).push(new SLKeyframe(config, (float)seconds).setStartSide(side, showme).setEndSide(AnimCardPanel.opposite(side), this.current));
            trans.setEase((TweenEquation)Quint.IN);
        } else {
            trans = new SLTransition(this, this.manager).push(new SLKeyframe(config, (float)seconds).setStartSide(side, showme));
            trans.setEase((TweenEquation)Quint.OUT);
        }
        new DoTransition(trans).start();
        if (!this.skipHistory && this.current != null) {
            Object object = this.history_LOCK;
            synchronized (object) {
                this.history.add(new Back(this.current, AnimCardPanel.opposite(side), seconds, !reverseTransition));
            }
        }
        this.current = showme;
    }

    public boolean isShowing(JComponent comp) {
        return this.current == comp;
    }

    public boolean isInitialized() {
        return this.current != null;
    }

    class Back {
        JComponent showme;
        SLSide side;
        double seconds;
        boolean reverseTransition;

        public Back(JComponent showme, SLSide side, double seconds, boolean reverseTransition) {
            this.showme = showme;
            this.side = side;
            this.seconds = seconds;
            this.reverseTransition = reverseTransition;
        }
    }
}

