/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dnd.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import utils.swing.dnd.FileDropListener;
import utils.swing.dnd.TextDropListener;

public class DndTransferHandler {
    FileDropListener fdrop;
    TextDropListener tdrop;

    public DndTransferHandler(FileDropListener f) {
        this.fdrop = f;
    }

    public DndTransferHandler(TextDropListener f) {
        this.tdrop = f;
    }

    public DndTransferHandler(FileDropListener f, TextDropListener t) {
        this.fdrop = f;
        this.tdrop = t;
    }

    public void addListFromDrop(Transferable t) {
        boolean fdropped = false;
        boolean tdropped = false;
        DataFlavor[] flav = t.getTransferDataFlavors();
        for (int i = 0; i < flav.length; ++i) {
            if (this.fdrop != null && !fdropped && flav[i].isFlavorJavaFileListType()) {
                fdropped = true;
                try {
                    List file_list = (List)t.getTransferData(flav[i]);
                    File[] files = new File[file_list.size()];
                    file_list.toArray(files);
                    this.fdrop.filesDropped(files);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.tdrop == null || tdropped || !flav[i].isFlavorTextType()) continue;
            tdropped = true;
            try {
                if (flav[i].isRepresentationClassReader()) {
                    Reader reader = flav[i].getReaderForText(t);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    int n = reader.read();
                    while (n != -1) {
                        bout.write(n);
                        n = reader.read();
                    }
                    this.tdrop.textDropped(new String(bout.toByteArray()));
                    continue;
                }
                Object o = t.getTransferData(flav[i]);
                if (o instanceof String) {
                    this.tdrop.textDropped((String)o);
                    continue;
                }
                System.out.println("Failed drop: " + o.getClass());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.fdrop != null && !fdropped) {
            try {
                DataFlavor flavour = new DataFlavor("text/uri-list;class=java.lang.String");
                fdropped = true;
                String data = (String)t.getTransferData(flavour);
                String[] uris = data.split("\n");
                File[] files = new File[uris.length];
                for (int i = 0; i < uris.length; ++i) {
                    files[i] = new File(new URI(uris[i].trim()));
                }
                this.fdrop.filesDropped(files);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

