/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHScrollButton;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHMiniScrollBarUI
extends BasicScrollBarUI {
    public static final int WIDTH = 8;
    private int orientation = -1;
    private boolean isRollover = false;
    private boolean wasRollover = false;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.incrButton = new JButton();
        this.incrButton.setPreferredSize(new Dimension(0, 0));
        this.decrButton = new JButton();
        this.decrButton.setPreferredSize(new Dimension(0, 0));
        this.scrollbar.setBorder(null);
    }

    @Override
    protected void installComponents() {
        this.scrollbar.setEnabled(this.scrollbar.isEnabled());
    }

    public static ComponentUI createUI(JComponent c) {
        c.putClientProperty("JComponent.sizeVariant", "mini");
        return new SHMiniScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new SHScrollButton(orientation, 8);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new SHScrollButton(orientation, 8);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.orientation == -1) {
            this.orientation = this.scrollbar.getOrientation();
        }
        Rectangle trackBounds = this.getTrackBounds();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(c.getBackground());
        g2d.fill(trackBounds);
        float width = SHButtonUI.getBorderStrokeWidth();
        Rectangle thumbBounds = this.getThumbBounds();
        RoundRectangle2D.Double shape = this.scrollbar.getOrientation() == 1 ? new RoundRectangle2D.Double(thumbBounds.x, thumbBounds.y, (float)thumbBounds.width - width, (float)thumbBounds.height - width, SimpleHelpLookAndFeel.scale((int)4), SimpleHelpLookAndFeel.scale((int)4)) : new RoundRectangle2D.Double(thumbBounds.x, thumbBounds.y, (float)thumbBounds.width - width, (float)thumbBounds.height - width, SimpleHelpLookAndFeel.scale((int)8), SimpleHelpLookAndFeel.scale((int)8));
        g2d.setPaint(SHButtonUI.getFill((SHUI.ButtonColor)SHUI.BUTTON_NORMAL, (boolean)c.isEnabled(), (int)thumbBounds.height, (boolean)this.isDragging));
        g2d.fill(shape);
        g2d.setStroke(SHButtonUI.getBorderStroke());
        g2d.setColor(SHButtonUI.getBorderColor((SHUI.ButtonColor)SHUI.BUTTON_NORMAL, (boolean)c.isEnabled()));
        g2d.draw(shape);
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(SHMiniScrollBarUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            SHMiniScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            SHMiniScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SHMiniScrollBarUI.this.isRollover = false;
            SHMiniScrollBarUI.this.wasRollover = false;
            if (SHMiniScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHMiniScrollBarUI.this.isRollover = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SHMiniScrollBarUI.this.isRollover = false;
            if (SHMiniScrollBarUI.this.isRollover != SHMiniScrollBarUI.this.wasRollover) {
                SHMiniScrollBarUI.this.scrollbar.repaint();
                SHMiniScrollBarUI.this.wasRollover = SHMiniScrollBarUI.this.isRollover;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SHMiniScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHMiniScrollBarUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (SHMiniScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                SHMiniScrollBarUI.this.isRollover = true;
                if (!SHMiniScrollBarUI.this.wasRollover) {
                    SHMiniScrollBarUI.this.scrollbar.repaint();
                    SHMiniScrollBarUI.this.wasRollover = SHMiniScrollBarUI.this.isRollover;
                }
            } else {
                SHMiniScrollBarUI.this.isRollover = false;
                if (SHMiniScrollBarUI.this.wasRollover) {
                    SHMiniScrollBarUI.this.scrollbar.repaint();
                    SHMiniScrollBarUI.this.wasRollover = SHMiniScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

