/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.TranslationUtil;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class WidthSlider {
    private GbPanel rootComponent = new GbPanel(new ScaledInsets(0, 0, 0, 0));
    private ResourceBundle bundle;
    private JSlider slider;
    private JLabel descriptionLabel;
    private SwingStyleInterface style;
    private AbstractField.ChangeListener listener;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public WidthSlider(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        this.listener = listener;
        this.bundle = bundle;
        this.style = style;
        this.initUI();
    }

    private void initUI() {
        this.slider = new JSlider(0, 10);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing(1);
        this.slider.setValue(10);
        SwingUtil.setWidth((JComponent)this.slider, (int)SimpleHelpLookAndFeel.scale((int)100));
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setForeground(this.style.getExampleTextColor());
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(SimpleHelpLookAndFeel.scale((float)10.0f)));
        this.rootComponent.add((Component)this.slider, 0, 0, 1, 1, 0, 1, 10, 0);
        this.rootComponent.add((Component)this.descriptionLabel, 0, 1, 1, 1, 0, 1, 10, 0);
        this.updateLabel();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WidthSlider.this.updateLabel();
                if (WidthSlider.this.listener != null) {
                    WidthSlider.this.listener.changed(null);
                }
            }
        });
    }

    public int getValuePercentage() {
        return this.slider.getValue() * 10;
    }

    public void setValuePercentage(int value) {
        this.slider.setValue(value / 10);
    }

    private void updateLabel() {
        int value = this.slider.getValue();
        String label = value == 0 ? this.bundle.getString("CUI_WIDTH_REQUIRED") : (value == 10 ? this.bundle.getString("CUI_WIDTH_FULL") : TranslationUtil.getString(this.bundle, "CUI_WIDTH_MESSAGE", new Object[]{value * 10 + "%"}));
        this.descriptionLabel.setText(label);
        this.descriptionLabel.repaint();
    }
}

