/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.components.checklist.CheckListRenderer;
import utils.swing.components.listui.AbstractListUI;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.RadioButtonField;
import utils.swing.cui.ui.ConfigUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public class RadioButtonsConfigUI
extends ConfigUI {
    private ComboOptionsUI cOptionsUI;

    public RadioButtonsConfigUI(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        super(bundle, style, listener);
    }

    @Override
    public void initUI() {
        JLabel label = new JLabel(this.bundle.getString("CUI_COMBODESC") + ": ");
        this.cOptionsUI = new ComboOptionsUI();
        SwingUtil.setWidth((JComponent)((Object)this.cOptionsUI), (int)SimpleHelpLookAndFeel.scale((int)200));
        this.rootComponent.add((Component)label, 0, 0, 1, 1, 0, 0, 18, 0);
        this.rootComponent.add((Component)((Object)this.cOptionsUI), 0, 1, 1, 1, 1, 0, 17, 0);
    }

    @Override
    public void loadConfigurationFrom(CUIField type) {
        RadioButtonField field = (RadioButtonField)type;
        String[] choices = field.getChoices();
        int[] validIndicesArray = field.getValidIndicesArray();
        CheckedItem[] checkedItems = new CheckedItem[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            checkedItems[i] = new CheckedItem(choices[i]);
            checkedItems[i].isChecked = AbstractField.isValidIndex((int[])validIndicesArray, (int)i);
        }
        this.cOptionsUI.setObjects(checkedItems);
    }

    @Override
    public void saveConfigurationTo(CUIField type) {
        CheckedItem[] items = this.cOptionsUI.getObjects(new CheckedItem[0]);
        String[] results = new String[items.length];
        ArrayList<Integer> validIndices = new ArrayList<Integer>();
        for (int i = 0; i < items.length; ++i) {
            CheckedItem ci = items[i];
            results[i] = ci.sourceObject.toString();
            if (!ci.isChecked) continue;
            validIndices.add(new Integer(i));
        }
        int[] validIndicesArray = new int[validIndices.size()];
        for (int i = 0; i < validIndices.size(); ++i) {
            validIndicesArray[i] = (Integer)validIndices.get(i);
        }
        ((RadioButtonField)type).setOptions(results);
        ((RadioButtonField)type).setValidOptions(validIndicesArray);
    }

    class CheckedItem {
        boolean isChecked = true;
        Object sourceObject;

        public CheckedItem(Object object) {
            this.sourceObject = object;
        }

        public String toString() {
            return this.sourceObject.toString();
        }
    }

    class ComboOptionsUI
    extends AbstractListUI<CheckedItem> {
        final int SIZE_OF_CHECKBOX;

        public ComboOptionsUI() {
            super(RadioButtonsConfigUI.this.bundle, true, true);
            this.SIZE_OF_CHECKBOX = new JCheckBox().getPreferredSize().width;
            this.elementList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    JList list = (JList)event.getSource();
                    if (event.getPoint().x <= ComboOptionsUI.this.SIZE_OF_CHECKBOX) {
                        int index = list.locationToIndex(event.getPoint());
                        Object it = list.getModel().getElementAt(index);
                        ComboOptionsUI.this.registerSelection(it);
                        list.repaint(list.getCellBounds(index, index));
                    }
                }
            });
        }

        private void registerSelection(Object it) {
            ((CheckedItem)it).isChecked = !((CheckedItem)it).isChecked;
            RadioButtonsConfigUI.this.notifyOfChange();
        }

        @Override
        protected ListCellRenderer getCellRenderer() {
            CheckListRenderer c = new CheckListRenderer(){

                @Override
                public boolean isObjectSelected(Object it) {
                    return ((CheckedItem)it).isChecked;
                }
            };
            return c;
        }

        @Override
        protected Icon getAddIcon() {
            return ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16");
        }

        @Override
        protected Icon getDeleteIcon() {
            return ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16");
        }

        @Override
        protected Icon getUpIcon() {
            return ImageLoader.getImageIcon((String)"images/svg/arrows/up.svg,10");
        }

        @Override
        protected Icon getDownIcon() {
            return ImageLoader.getImageIcon((String)"images/svg/arrows/down.svg,10");
        }

        @Override
        protected CheckedItem getNewObject() {
            String title = SHGlassOptionPane.showInputDialog((RootPaneContainer)((RootPaneContainer)((Object)this.getRootPane().getParent())), (String)("<html>" + this.lang.getString("CUI_COMBOBOX_ADDOPTION") + "</html>"), (String)this.lang.getString("CUI_COMBOBOX_ADDOPTION_TITLE"), (Icon)ImageLoader.getImageIcon((String)"O[images/svg/users/profile.svg,48 | images/svg/general/add.svg,16]"), (String)this.lang.getString("DONE"), (String)"");
            if (title == null) {
                return null;
            }
            CheckedItem item = new CheckedItem(title);
            return item;
        }

        @Override
        protected Icon getIconForObject(CheckedItem element) {
            return null;
        }

        @Override
        protected void listChanged() {
            RadioButtonsConfigUI.this.notifyOfChange();
        }
    }
}

