/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import utils.swing.SwingStyleInterface;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.ui.FieldCreator;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class FieldListUI
implements FieldCreator.ReorderingListener {
    private GbPanel panel = new GbPanel();
    private JButton newTypeButton;
    private ResourceBundle bundle;
    private SwingStyleInterface style;
    private ArrayList listOfAllCreatorUIs = new ArrayList();
    private AbstractField.ChangeListener listener;
    private GbPanel paddingPanel;
    private GbPanel buttonPanel;

    public GbPanel getRootComponent() {
        return this.panel;
    }

    public FieldListUI(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        this.bundle = bundle;
        this.style = style;
        this.listener = listener;
        this.initUI();
    }

    private void addTypeCreateToList(FieldCreator newCreator) {
        this.listOfAllCreatorUIs.add(newCreator);
        this.setReorderingButtonsState();
        int componentCount = this.panel.getComponentCount();
        Component paddy = this.panel.getComponent(componentCount - 1);
        this.panel.remove(paddy);
        this.panel.add((Component)newCreator.getRootComponent(), 0, componentCount - 1, 1, 1, 1, 0, 10, 1);
        this.panel.add(paddy, 0, componentCount, 1, 1, 1, 10000, 10, 1);
        newCreator.getRootComponent().setBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR));
    }

    protected void clearAll() {
        for (int i = this.listOfAllCreatorUIs.size() - 1; i >= 0; --i) {
            FieldCreator creator = (FieldCreator)this.listOfAllCreatorUIs.remove(i);
            this.panel.remove((Component)creator.getRootComponent());
        }
    }

    @Override
    public void delete(FieldCreator creatorToRemove) {
        this.listOfAllCreatorUIs.remove(creatorToRemove);
        this.panel.remove((Component)creatorToRemove.getRootComponent());
        this.setReorderingButtonsState();
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void moveDown(int currentIndex) {
        FieldCreator current = (FieldCreator)this.listOfAllCreatorUIs.get(currentIndex);
        FieldCreator belowOne = (FieldCreator)this.listOfAllCreatorUIs.get(currentIndex + 1);
        this.listOfAllCreatorUIs.set(currentIndex + 1, current);
        this.listOfAllCreatorUIs.set(currentIndex, belowOne);
        this.panel.getGridBagLayout().setConstraints((Component)current.getRootComponent(), new GridBagConstraints(0, currentIndex + 1, 1, 1, 1.0, 0.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        this.panel.getGridBagLayout().setConstraints((Component)belowOne.getRootComponent(), new GridBagConstraints(0, currentIndex, 1, 1, 1.0, 0.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        this.setReorderingButtonsState();
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void moveUp(int currentIndex) {
        FieldCreator current = (FieldCreator)this.listOfAllCreatorUIs.get(currentIndex);
        FieldCreator aboveOne = (FieldCreator)this.listOfAllCreatorUIs.get(currentIndex - 1);
        this.listOfAllCreatorUIs.set(currentIndex - 1, current);
        this.listOfAllCreatorUIs.set(currentIndex, aboveOne);
        this.panel.getGridBagLayout().setConstraints((Component)current.getRootComponent(), new GridBagConstraints(0, currentIndex - 1, 1, 1, 1.0, 0.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        this.panel.getGridBagLayout().setConstraints((Component)aboveOne.getRootComponent(), new GridBagConstraints(0, currentIndex, 1, 1, 1.0, 0.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        this.setReorderingButtonsState();
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void setReorderingButtonsState() {
        if (this.listOfAllCreatorUIs.size() == 0) {
            return;
        }
        if (this.listOfAllCreatorUIs.size() == 1) {
            ((FieldCreator)this.listOfAllCreatorUIs.get(0)).setReorderingButtonsEnabled(false, false);
            return;
        }
        for (int i = 0; i < this.listOfAllCreatorUIs.size(); ++i) {
            if (i == 0) {
                ((FieldCreator)this.listOfAllCreatorUIs.get(i)).setReorderingButtonsEnabled(false, true);
                continue;
            }
            if (i == this.listOfAllCreatorUIs.size() - 1) {
                ((FieldCreator)this.listOfAllCreatorUIs.get(i)).setReorderingButtonsEnabled(true, false);
                continue;
            }
            ((FieldCreator)this.listOfAllCreatorUIs.get(i)).setReorderingButtonsEnabled(true, true);
        }
    }

    public void initUIForList(CUIField[] allFields) {
        this.clearAll();
        for (int i = 0; i < allFields.length; ++i) {
            FieldCreator newCreator = new FieldCreator(this.bundle, this.style, true, this.listener);
            newCreator.loadFrom(allFields[i]);
            newCreator.setReorderingListener(this);
            newCreator.requestFocus();
            this.addTypeCreateToList(newCreator);
        }
    }

    private void initUI() {
        this.newTypeButton = new JButton(this.bundle.getString("CUI_NEW_FIELD"));
        this.newTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldCreator newCreator = new FieldCreator(FieldListUI.this.bundle, FieldListUI.this.style, true, FieldListUI.this.listener);
                newCreator.setReorderingListener(FieldListUI.this);
                newCreator.requestFocus();
                FieldListUI.this.addTypeCreateToList(newCreator);
                FieldListUI.this.panel.revalidate();
                FieldListUI.this.panel.repaint();
            }
        });
        this.paddingPanel = new GbPanel();
        this.paddingPanel.setBackground(UIManager.getColor("TextField.background"));
        this.buttonPanel = new GbPanel();
        this.buttonPanel.setBackground(UIManager.getColor("TextField.background"));
        this.buttonPanel.add((Component)this.newTypeButton, 0, 0, 1, 1, 1, 0, 10, 0, (Insets)new ScaledInsets(5, 5, 5, 5));
        this.buttonPanel.add((Component)this.paddingPanel, 0, 1, 1, 1, 1, 1000, 10, 1);
        this.panel.add((Component)this.buttonPanel, 0, 0, 1, 1, 1, 1000, 10, 1);
    }

    @Override
    public void moveUp(FieldCreator typeCreator) {
        int index = this.listOfAllCreatorUIs.indexOf(typeCreator);
        this.moveUp(index);
    }

    @Override
    public void moveDown(FieldCreator typeCreator) {
        int index = this.listOfAllCreatorUIs.indexOf(typeCreator);
        this.moveDown(index);
    }

    public CUIField[] getFields() {
        CUIField[] fields = new CUIField[this.listOfAllCreatorUIs.size()];
        for (int i = 0; i < this.listOfAllCreatorUIs.size(); ++i) {
            FieldCreator type = (FieldCreator)this.listOfAllCreatorUIs.get(i);
            fields[i] = type.generateUIType();
        }
        return fields;
    }

    public void setBackground(Color backgroundColor) {
        this.paddingPanel.setBackground(backgroundColor);
        this.buttonPanel.setBackground(backgroundColor);
    }
}

