/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.documents;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerRangeTextDocument
extends PlainDocument {
    private int minValueInclusive;
    private int maxValueInclusive;

    public IntegerRangeTextDocument(int minValueInclusive, int maxValueInclusive) {
        this.minValueInclusive = minValueInclusive;
        this.maxValueInclusive = maxValueInclusive;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        String prefix = "";
        String suffix = "";
        if (offs > 0) {
            prefix = this.getText(0, offs);
        }
        if (offs < this.getLength()) {
            suffix = this.getText(offs, this.getLength() - offs);
        }
        String newString = prefix + str + suffix;
        try {
            int val = Integer.parseInt(newString);
            if (this.minValueInclusive > val) break block7;
            if (val <= this.maxValueInclusive) {
                super.insertString(offs, str, a);
            }
        }
        finally {
            return;
        }
        {
            block7: {
            }
        }
    }
}

