/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.checklist;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public abstract class JCheckListTable
extends JPanel {
    private JTable table;
    private Object[] rowData = new Object[0];

    public abstract boolean isSelected(Object var1);

    public abstract void setSelected(Object var1, boolean var2);

    public JCheckListTable() {
        this.initUI();
    }

    public void setRowData(Object[] rowData) {
        this.rowData = rowData == null ? new Object[0] : rowData;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
    }

    private void initUI() {
        this.setLayout(new GridLayout(1, 1));
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return JCheckListTable.this.rowData.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return new Boolean(JCheckListTable.this.isSelected(JCheckListTable.this.rowData[row]));
                }
                return JCheckListTable.this.rowData[row];
            }
        };
        this.table = new JTable(dataModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new CheckListRenderer());
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.setRowHeight(new JCheckBox().getPreferredSize().height);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JTable table = (JTable)event.getSource();
                int row = table.rowAtPoint(event.getPoint());
                int column = table.columnAtPoint(event.getPoint());
                if (column == 0) {
                    JCheckListTable.this.setSelected(JCheckListTable.this.rowData[row], !JCheckListTable.this.isSelected(JCheckListTable.this.rowData[row]));
                    table.repaint(table.getCellRect(row, column, false));
                }
            }
        });
        this.add(this.table);
    }

    public JTable getTable() {
        return this.table;
    }

    class CheckListRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckListRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            Boolean selected = (Boolean)value;
            this.setSelected(selected);
            this.setFont(table.getFont());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

