/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;
import utils.switches.oem.OEMSwitches;

public class StrippedContentPanel {
    private final Icon expandIcon;
    private final Icon contractIcon;
    private GbPanel parentPanel;
    private boolean startDark;
    private Font titleFont;
    private Color backgroundDarker = !OEMSwitches.DARK_THEME ? SHStyle.PANEL_BACKGROUND_MEDIUM : SHStyle.PANEL_BACKGROUND_DARK;
    private Color backgroundLighter = !OEMSwitches.DARK_THEME ? SHStyle.PANEL_BACKGROUND_LIGHT : SHStyle.PANEL_BACKGROUND_MEDIUM;
    private int topBottomPadding = 0;
    private Insets zeroInsets = new ScaledInsets(0, 0, 0, 0);
    private Color lastColor;

    public void setStartDark(boolean startDark) {
        this.startDark = startDark;
    }

    public Color getLastColor() {
        return this.lastColor;
    }

    public void setBackgroundColors(Color dark, Color light) {
        this.backgroundDarker = dark;
        this.backgroundLighter = light;
    }

    public void setTopBottomPadding(int topBottomPadding) {
        this.topBottomPadding = topBottomPadding;
    }

    public StrippedContentPanel(GbPanel parentPanel, Icon expandIcon, Icon contractIcon) {
        this(parentPanel, true, expandIcon, contractIcon);
    }

    public StrippedContentPanel(GbPanel parentPanel, boolean startDark, Icon expandIcon, Icon contractIcon) {
        this.startDark = startDark;
        this.parentPanel = parentPanel;
        this.expandIcon = expandIcon;
        this.contractIcon = contractIcon;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void removeVerticalFiller() {
        if (this.parentPanel.getComponentCount() > 0) {
            this.parentPanel.remove(this.parentPanel.getComponentCount() - 1);
        }
    }

    public JPanel addVerticalFiller() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(1, 1));
        panel.setMinimumSize(panel.getPreferredSize());
        this.parentPanel.add((Component)panel, 0, this.parentPanel.getComponentCount(), 1, 1, 10, 1000, 11, 1, this.zeroInsets);
        return panel;
    }

    public TitledSection addContent(JComponent jc, String title) {
        return this.addContent(jc, title, true);
    }

    public TitledSection addContent(JComponent jc, String title, boolean allowChangeBackground) {
        TitledSection tmp = new TitledSection(jc, title, null, null, allowChangeBackground, this.titleFont, null);
        this.parentPanel.add((Component)tmp, 0, this.parentPanel.getComponentCount(), 1, 1, 10, 0, 11, 2, this.zeroInsets);
        return tmp;
    }

    public TitledSection addContentGrabVertical(JComponent jc, String title, boolean allowChangeBackground) {
        TitledSection tmp = new TitledSection(jc, title, null, null, allowChangeBackground, this.titleFont, null);
        this.parentPanel.add((Component)tmp, 0, this.parentPanel.getComponentCount(), 1, 1, 10, 1, 11, 1, this.zeroInsets);
        return tmp;
    }

    public TitledSection addContent(JComponent jc, String title, StrippedContentPanelListener listener, String tooltip) {
        TitledSection tmp = new TitledSection(jc, title, listener, tooltip, true, this.titleFont, null);
        this.parentPanel.add((Component)tmp, 0, this.parentPanel.getComponentCount(), 1, 1, 10, 0, 11, 2, this.zeroInsets);
        return tmp;
    }

    public ExpandableTitledSection addExpandableContent(JComponent jc, String title) {
        ExpandableTitledSection tmp = new ExpandableTitledSection(jc, title);
        this.parentPanel.add((Component)tmp, 0, this.parentPanel.getComponentCount(), 1, 1, 10, 0, 11, 2, this.zeroInsets);
        return tmp;
    }

    public static JPanel createTitledSection(JComponent main, String title, Icon expandIcon) {
        return new TitledSection(main, title, null, null, true, null, expandIcon);
    }

    public void removeContent(JComponent component) {
        boolean found = false;
        for (int i = 0; i < this.parentPanel.getComponentCount(); ++i) {
            Component child = this.parentPanel.getComponent(i);
            if (!found) {
                if (child == component) {
                    found = true;
                    this.parentPanel.remove((Component)component);
                }
                if (!(child instanceof TitledSection)) continue;
                TitledSection section = (TitledSection)child;
                if (section.main != component) continue;
                found = true;
                this.parentPanel.remove(child);
                continue;
            }
            GridBagConstraints constraints = this.parentPanel.getGridBagLayout().getConstraintsWithoutClone(child);
            --constraints.gridy;
        }
        this.parentPanel.revalidate();
        this.parentPanel.repaint();
    }

    public void setBackgroundColours() {
        this.setBackgroundColours(true);
    }

    public void setBackgroundColours(boolean hasFiller) {
        int count = 0;
        int dark = 0;
        if (!this.startDark) {
            dark = 1;
        }
        int max = this.parentPanel.getComponentCount() - 1;
        if (!hasFiller) {
            ++max;
        }
        for (int i = 0; i < max; ++i) {
            JComponent c1 = (JComponent)this.parentPanel.getComponent(i);
            if (!c1.isVisible() || c1 instanceof TitledSection && !((TitledSection)c1).allowChangeBackground) continue;
            if (count > 0) {
                c1.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)SHStyle.BORDER_COLOR_LIGHTER), (Border)SHBorderFactory.createEmptyBorder((int)(4 + this.topBottomPadding), (int)4, (int)(4 + this.topBottomPadding), (int)4)));
            } else {
                c1.setBorder(SHBorderFactory.createEmptyBorder((int)(4 + this.topBottomPadding), (int)4, (int)(4 + this.topBottomPadding), (int)4));
            }
            if (count % 2 == dark) {
                c1.setBackground(this.backgroundDarker);
            } else {
                c1.setBackground(this.backgroundLighter);
            }
            this.lastColor = c1.getBackground();
            for (Component c2 : c1.getComponents()) {
                c2.setBackground(c1.getBackground());
            }
            ++count;
        }
        if (max > 0 && hasFiller) {
            JComponent filler = (JComponent)this.parentPanel.getComponent(max);
            filler.setBackground(this.lastColor);
        } else if (hasFiller) {
            JComponent filler = (JComponent)this.parentPanel.getComponent(max);
            filler.setBackground(this.parentPanel.getBackground());
        }
        this.parentPanel.repaint();
    }

    class ExpandableTitledSection
    extends TitledSection
    implements MouseListener {
        public ExpandableTitledSection(JComponent main, String title) {
            super(main, title, null, null, true, StrippedContentPanel.this.titleFont, StrippedContentPanel.this.expandIcon);
            this.titleLabel.setIcon(StrippedContentPanel.this.contractIcon);
            this.titleLabel.addMouseListener(this);
            main.setVisible(false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean visible = !this.main.isVisible();
            this.main.setVisible(visible);
            if (visible) {
                this.titleLabel.setIcon(StrippedContentPanel.this.expandIcon);
            } else {
                this.titleLabel.setIcon(StrippedContentPanel.this.contractIcon);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public static class TitledSection
    extends JPanel
    implements ActionListener {
        public JComponent main;
        public JLabel titleLabel;
        private StrippedContentPanelListener listener;
        private JButton titleButton;
        private boolean allowChangeBackground;

        public TitledSection(JComponent main, String title, StrippedContentPanelListener listener, String tooltip, boolean allowChangeBackground, Font titleFont, Icon expandIcon) {
            super(new BorderLayout());
            this.allowChangeBackground = allowChangeBackground;
            this.main = main;
            this.listener = listener;
            this.add((Component)main, "Center");
            if (title != null) {
                GbPanel topPanel = new GbPanel();
                this.titleLabel = new JLabel();
                this.titleLabel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)5, (int)0));
                if (titleFont == null) {
                    this.titleLabel.setFont(SHStyle.largeFont);
                } else {
                    this.titleLabel.setFont(titleFont);
                }
                this.titleLabel.setText(title);
                topPanel.add((Component)this.titleLabel, 0, 0, 1, 1, 1, 0, 17, 2);
                this.add((Component)topPanel, "North");
                if (listener != null) {
                    this.titleButton = new JButton(expandIcon);
                    this.titleButton.setToolTipText(tooltip);
                    this.titleButton.addActionListener(this);
                    topPanel.add((Component)this.titleButton, 1, 0, 1, 1, 1, 0, 13, 0);
                }
            }
        }

        public void setButtonHeight(int height) {
            if (this.titleButton != null) {
                SwingUtil.setHeight((JComponent)this.titleButton, (int)height);
            }
        }

        @Override
        public String toString() {
            if (this.titleLabel != null) {
                return this.titleLabel.getText();
            }
            return super.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.titleButton.setVisible(false);
            this.listener.sectionExpanded();
        }

        public void setLabelAlignment(int swingConstantsAlignment) {
            this.titleLabel.setHorizontalAlignment(swingConstantsAlignment);
        }
    }

    public static interface StrippedContentPanelListener {
        public void sectionExpanded();
    }
}

