/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import utils.swing.borders.RoundRectBorder;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;

public class RoundBorderPanel
extends JPanel {
    private final boolean inverted;
    private Border border;
    private TitledBorder titleBorder = null;

    public RoundBorderPanel() {
        this((String)null);
    }

    public RoundBorderPanel(String title) {
        this(title, false);
    }

    public RoundBorderPanel(boolean inverted) {
        this((String)null, inverted);
    }

    public RoundBorderPanel(String title, boolean inverted) {
        this.inverted = inverted;
        this.setBorderText(title, inverted);
    }

    @Override
    public Component add(Component c) {
        Component ret = super.add(c);
        if (c instanceof JPanel || c instanceof JCheckBox) {
            c.setBackground(!this.inverted ? SHStyle.ROUNDRECTBORDER.getFillColor() : SHStyle.ROUNDRECTBORDER_INV.getFillColor());
        }
        return ret;
    }

    public static JPanel getPaddyPanel(boolean darker) {
        JPanel panel = new JPanel();
        if (darker) {
            panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        }
        return panel;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.titleBorder != null) {
            this.titleBorder.setTitleColor(b ? (Color)UIManager.get("Label.foreground") : Color.GRAY);
        }
    }

    public void setBorderText(String title) {
        this.setBorderText(title, this.inverted);
    }

    public void setBorderText(String title, boolean inverted) {
        RoundRectBorder roundBorder;
        RoundRectBorder roundRectBorder = roundBorder = !inverted ? SHStyle.ROUNDRECTBORDER : SHStyle.ROUNDRECTBORDER_INV;
        if (title != null) {
            this.titleBorder = SHBorderFactory.createTitledBorder((Border)roundBorder, (String)title);
            this.titleBorder.setTitlePosition(1);
            this.border = this.titleBorder;
            this.border = SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createEmptyBorder((int)10, (int)3, (int)3, (int)3), (Border)this.border);
        } else {
            this.border = roundBorder;
            this.border = SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5), (Border)this.border);
        }
        this.border = SHBorderFactory.createCompoundBorder((Border)this.border, (Border)SHBorderFactory.createEmptyBorder((int)7, (int)7, (int)7, (int)7));
        this.setBorder(this.border);
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        JPanel test = new JPanel(new GridLayout(1, 3));
        test.setBackground(Color.red);
        RoundBorderPanel test1 = new RoundBorderPanel();
        RoundBorderPanel test2 = new RoundBorderPanel("TEST");
        test.add(test1);
        test.add(test2);
        frame.getContentPane().add(test);
        frame.setVisible(true);
    }
}

